/**************************************************************************
*
*	partsout.fs     
*
*	FORM:	partsout       
*	DESCRIPTION:	This script manages the Parts Out for Repair
*			form.
*
*	AUTHOR:    DWM
*	DATE:      Unknown
*	REVIEWER:  DWM
*
****************************************************************************/

FORM partsout        

TARGET_TABLE parout

LOCAL count, ven_old;

BEFORE FORM
   SET partsout:AUTO_COMMIT TO TRUE
   IF PREV_FORM = 'problem' THEN 
   BEGIN
      SET partsout:AUD_ON_ENTRY TO TRUE
      IF problem:pr_node <> UNDEFINED THEN
      BEGIN
         SET partsout:po_nid:CLEAR_ADD_EXP TO problem:pr_node
         SET partsout:po_ven:CLEAR_ADD_EXP TO problem:pr_vendor
         SET partsout:po_phone TO problem:pr_phone
         SET partsout:po_stat:CLEAR_ADD_EXP  TO problem:pr_stat
         SET partsout:po_tagd:CLEAR_ADD_EXP  TO problem:pr_open_date
         SET partsout:po_prob:CLEAR_ADD_EXP  TO problem:pr_id
         SET partsout:po_pnam:CLEAR_ADD_EXP  TO problem:pr_model
         SET partsout:po_sn:CLEAR_ADD_EXP    TO problem:pr_sn
         SET partsout:po_phone TO UNDEFINED	     
	 SET partsout:flag TO FALSE
      END
   END

ON CLEAR TO ADD
   SET po_stat TO 'O'
   SET po_tagd TO current_date$()
   SET po_fix:STOP_FOR_INPUT TO FALSE
   SET po_fix2:STOP_FOR_INPUT TO FALSE
   SET po_cost:STOP_FOR_INPUT TO FALSE
   SET po_fail:STOP_FOR_INPUT TO TRUE
   SET po_fal2:STOP_FOR_INPUT TO TRUE
   SET partsout:po_phone TO UNDEFINED	     
   SET partsout:po_probdesc TO UNDEFINED

ON CLEAR TO FIND
   SET po_stat:CLEAR_FIND_EXP TO 'O'
   SET po_fix:STOP_FOR_INPUT TO TRUE
   SET po_fix2:STOP_FOR_INPUT TO TRUE
   SET po_cost:STOP_FOR_INPUT TO TRUE
   SET po_fail:STOP_FOR_INPUT TO TRUE
   SET po_fal2:STOP_FOR_INPUT TO TRUE

BEFORE FIND
   IF flag = TRUE THEN 
   BEGIN
      DISPLAY 'Printing.....' FOR FYI_MESSAGE
      CREATE PIPELINE pipe1 'RPT /accell/rptdir/po_rep.r -', printer;
   END

ON FIND 
   IF flag = TRUE THEN
      WRITE PIPELINE pipe1 po_ven,po_tic,po_nid,po_sn,po_ship;

AFTER FIND
   IF flag = TRUE THEN
   BEGIN
      CLOSE PIPELINE pipe1;
      REFRESH SCREEN;
      DISPLAY 'Done Printing.' FOR FYI_MESSAGE WAIT
   END

FIELD po_stat
   ON FIELD
      INPUT
      SWITCH po_stat
      BEGIN
         CASE 'O': DISPLAY po_stat
	           SET po_retd TO str_to_date$('**/**/**')
         CASE 'C': DISPLAY po_stat
                   SET po_retd TO current_date$()
         CASE UNDEFINED: SET po_stat TO 'O'
	                 DISPLAY po_stat
         DEFAULT: DISPLAY 'Enter O or C only.  Press RETURN.' FOR FYI_MESSAGE
                  WAIT
                  RESTART ON FIELD
      END

FIELD po_nid
   WHEN FIELD CHANGES
      SET $ven_old TO partsout:po_ven
      SET partsout:po_ven TO
         SELECT #no_ven FROM node WHERE #no_id = partsout:po_nid
      IF partsout:po_ven = UNDEFINED THEN	/* so if there is no node id */
         SET partsout:po_ven TO ven_old		/* name won't flash away */

FIELD po_ven
   BEFORE FIELD 
      ENABLE ZOOM to vendor RETURN KEY
   WHEN FIELD CHANGES
      SET partsout:po_phone TO
         SELECT #ve_ph FROM vendor WHERE #ve_id = partsout:po_ven

FIELD po_div
   ON FIELD
      INPUT
      SWITCH po_div
      BEGIN
         CASE 'N': DISPLAY po_div
         CASE 'S': DISPLAY po_div
         DEFAULT: DISPLAY 'Enter N or S only. Press RETURN.' FOR FYI_MESSAGE
                  WAIT
	          RESTART ON FIELD
      END

FIELD po_prob
   BEFORE FIELD
      ENABLE ZOOM to probcode RETURN KEY
   WHEN FIELD CHANGES
      SET partsout:po_probdesc TO
         SELECT #prc_des FROM probcode WHERE #prc_id = po_prob
