/**************************************************************************
*
*	pchard.fs       
*
*	FORM:	pchard         
*	DESCRIPTION:	This script handles the PC Hardware form that
*			is used to both enter and search for data.
*
*	AUTHOR:    BSY
*	DATE:      9/28/89
*	REVIEWER:  BSY
*
****************************************************************************/

FORM pchard          

TARGET_TABLE pchard

BEFORE FORM
   SET pchard:AUTO_COMMIT TO TRUE
   IF PREV_FORM = 'node' THEN
   BEGIN
      SET pchard:ph_node: CLEAR_ADD_EXP TO node:no_id
      SET pchard:ph_node: CLEAR_FIND_EXP to node:no_id
      SET pchard:next_line: CLEAR_ADD_EXP to node:no_next_hard
      SET pchard:ph_node: STOP_FOR_INPUT to FALSE
      IF node:no_next_hard > 0 THEN
         SET pchard:AUTO_FIND TO TRUE
      ELSE
         SET pchard:AUD_ON_ENTRY TO TRUE
      END

ON NEXT FORM
   IF ph_node = UNDEFINED THEN
   BEGIN
      beep$(1);
      DISPLAY 'Cannot NEXT-FORM without Node ID.  Press RETURN to continue.'
         FOR FYI_MESSAGE WAIT;
      REJECT OPERATION
   END

ON CLEAR TO ADD
   IF PREV_FORM <> 'node' THEN
   BEGIN
      beep$(1)
      DISPLAY 'To add PC hardware, go to Node Information, find the node, and press NEXT-FORM.'
         FOR FYI_MESSAGE WAIT
   END

BEFORE ADD
   IF PREV_FORM <> 'node' THEN
   BEGIN
      DISPLAY 'Cannot add records here.  Follow instructions previously given.'
         FOR FYI_MESSAGE WAIT
      REJECT OPERATION
   END
   SET pchard:ph_lnum TO pchard:next_line
   SET pchard:next_line TO pchard:next_line + 1

AFTER ADD
   SET node:no_next_hard TO pchard:next_line
   UPDATE node SET #no_next_hard to pchard:next_line WHERE #no_id = node:no_id

FIELD ph_node
   INIT FIELD
      ENABLE ZOOM TO node

FIELD ph_mod
   BEFORE FIELD
      ENABLE ZOOM TO part RETURN KEY
   ON FIELD                     /* Display the cost of part if a match  */
      INPUT
				 /* is found in the PARTS records */
      IF pchard:ph_mod <> UNDEFINED THEN
      BEGIN
         SET pchard:ph_amount TO
            SELECT #pa_amount FROM parts WHERE #pa_name = pchard:ph_mod 
      END
