/**************************************************************************
*
*	pcreport.fs     
*
*	FORM:	pcreport       
*	DESCRIPTION:	This script generates reports for PC's where
*			each PC is listed with its corresponding
*			hardware and software.
*
*	AUTHOR:    DWM
*	DATE:      01/12/90
*	REVIEWER:  DWM
*
****************************************************************************/

#define ESC char_code_to_str$(27)
#define MAXLINES 80
#define set_select(prevf,curf,fieldname) \
    SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES
#define pcol(X) \
    ESC,'&a',X,'C'
#define FormFeed char_code_to_str$(12)
#define mtstring ''
#define regset \
   ESC,'(8U',ESC,'(s0p16.67h8.5v0s0b0T',ESC,'&l0o'
#define heading(pageno) \
   WRITE PIPELINE pcreport:pipe1 ESC,'(8U',ESC,'(s1p12.0v0s0b5T',ESC,'&l0o',pcol(1), \
   current_date$(),'   ',\
   current_time$(), \
   '                                 PC Report            ', \
   '                                          ', pageno,'\n', \
   regset
#define setund ESC,'&dD'
#define unsetund ESC,'&d@'
#define addline \
   IF $LINENO > 60 THEN \
   BEGIN \
      WRITE PIPELINE pcreport:pipe1 FormFeed; \
      SET $PAGE TO ($PAGE+1) \
      heading(PAGE)  \
      SET $LINENO TO 0 \
   END \
   ELSE \
      SET $LINENO TO ($LINENO+1)

/***************************************************************************/

FORM pcreport        

TARGET_TABLE node 

LOCAL sel

BEFORE FORM
   SET sel TO UNDEFINED
   SET pcreport:AUTO_FIND TO TRUE
   SET pcreport:$printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(node,pcreport,no_id)
   set_select(node,pcreport,no_site)
   set_select(node,pcreport,no_group)
   set_select(node,pcreport,no_location)
   set_select(node,pcreport,no_model)
   set_select(node,pcreport,no_dept)
   set_select(node,pcreport,no_ser)
   set_select(node,pcreport,no_phone)
   set_select(node,pcreport,no_vendor)
   set_select(node,pcreport,no_floor_jack)
   set_select(node,pcreport,no_serv_num)
   set_select(node,pcreport,no_trob_prt)
   set_select(node,pcreport,no_install_date)
   set_select(node,pcreport,no_move_date)
   set_select(node,pcreport,no_prob_esc_code)
   set_select(node,pcreport,no_comment1)
   set_select(node,pcreport,no_comment2)
   set_select(node,pcreport,no_comment3)
   set_select(node,pcreport,no_comment4)
   set_select(node,pcreport,no_prnum)
   set_select(node,pcreport,no_pur_date)
   set_select(node,pcreport,no_pur_ven)
   set_select(node,pcreport,no_pur_order)
   set_select(node,pcreport,no_pri_user)
   set_select(node,pcreport,no_cost_center)
   set_select(node,pcreport,no_cc_head)
   set_select(node,pcreport,no_total_mem)
   set_select(node,pcreport,no_hard_disk_ty)
   set_select(node,pcreport,no_vtam_id)
   set_select(node,pcreport,no_copro)
   set_select(node,pcreport,no_keyid)
   IF sel = 2 THEN
   BEGIN
      SET $PAGE TO 1
      SET $LINENO TO 1
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
      CREATE PIPELINE pcreport:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         pcreport:$printer
      heading($PAGE)
   END

ON FIND
   IF sel = 2 THEN
   BEGIN
      IF $LINENO > 45 THEN
      BEGIN
         SET $PAGE TO ($PAGE+1)
	 WRITE PIPELINE pcreport:pipe1 FormFeed
         heading($PAGE)  
	 SET $LINENO TO 1
      END
      WRITE PIPELINE pcreport:pipe1 pcol(1),setund,'Node',pcol(26),
         'Location',pcol(58),'Project/User',pcol(75),'Memory/Hard Drive',
         pcol(99),'Escalation', unsetund
      addline
      WRITE PIPELINE  pcreport:pipe1 pcol(1),no_id,pcol(26),no_site,
         pcol(58),no_prnum,pcol(75),no_total_mem,'   ',no_hard_disk_ty,
         pcol(99),no_prob_esc_code
      addline
      SET pcreport:hours,pcreport:days TO
         SELECT #ec_hours,#ec_days FROM ecode WHERE #ec_num = no_prob_esc_code
      IF no_vtam_id <> UNDEFINED THEN
      BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(1),no_model,pcol(26),
            no_location,pcol(58),no_pri_user,pcol(75),'VTAM: ',no_vtam_id,
            pcol(99),pcreport:hours,' Hrs.  ',pcreport:days,' Days'
      END
      ELSE
      BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(1),no_model,pcol(26),
            no_location,pcol(58),no_pri_user,pcol(75),'VTAM: N/A',
            pcol(99), pcreport:hours,' Hrs.  ',pcreport:days,' Days'
	 addline
      END
      WRITE PIPELINE pcreport:pipe1 pcol(1),no_vendor,' ',no_group,pcol(26),
         no_trob_prt, pcol(58),no_phone,pcol(75),'Co Pro: ',no_copro
      addline
      WRITE PIPELINE pcreport:pipe1 pcol(1),no_ser,pcol(58),no_floor_jack,
         pcol(75),'Key Id: ',no_keyid
      addline
      WRITE PIPELINE pcreport:pipe1 ' '
      addline
      WRITE PIPELINE pcreport:pipe1 pcol(1),'Purchased on ',no_pur_date,
         ' at ',no_pur_ven,'   PO# ',no_pur_order
      addline
      WRITE PIPELINE pcreport:pipe1 pcol(1),'Cost Center ', no_cost_center,
         '   Head ',no_cc_head
      addline
      WRITE PIPELINE pcreport:pipe1 ' '
      addline
      WRITE PIPELINE pcreport:pipe1 setund,'Comments',unsetund 
      addline
      IF strlen$(no_comment1) > 1 THEN
      BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment1
         addline
      END
      IF strlen$(no_comment2) > 1 THEN
      BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment2
         addline
      END
      IF strlen$(no_comment3) > 1 THEN
      BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment3
         addline
      END
      IF strlen$(no_comment4) > 1 THEN
      BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment4
         addline
      END
      WRITE PIPELINE pcreport:pipe1 ' '
      addline
      IF $LINENO > 45 THEN
      BEGIN
         SET $PAGE TO ($PAGE+1)
         WRITE PIPELINE pcreport:pipe1 FormFeed
         heading($PAGE)  
         SET $LINENO TO 1
      END
 /*  PC HARD STUFF  */
      WRITE PIPELINE pcreport:pipe1 pcol(26),setund,'Hardware Info',unsetund
      addline
      SET ven TO ' '
      SET mod TO ' '
      SET sn TO ' '
      SET slot TO ' '
      SET ven,mod,sn,slot TO
         SELECT #ph_ven,#ph_mod,#ph_sn,#ph_slot
         FROM pchard WHERE pcreport:no_id = #ph_node
      EXECUTING BEGIN
         IF slot <> UNDEFINED THEN
         BEGIN
            WRITE PIPELINE pcreport:pipe1 pcol(26),ven, ' ',mod,
               pcol(84),'SN:',sn,pcol(106),'Slot:',slot
         END
         ELSE
         BEGIN
	    WRITE PIPELINE pcreport:pipe1 pcol(26),ven, ' ',mod,
               pcol(84),'SN:',sn
         END
         addline
         SET sn to UNDEFINED
         SET slot TO UNDEFINED
      END
      WRITE PIPELINE pcreport:pipe1 ' '
      addline
      IF $LINENO > 45 THEN
      BEGIN
         SET $PAGE TO ($PAGE+1)
         WRITE PIPELINE pcreport:pipe1 FormFeed
         heading($PAGE)
	 SET $LINENO TO 0
      END
 /*   PC Soft Stuff   */
      WRITE PIPELINE pcreport:pipe1 pcol(26),setund,'PC Software',unsetund
      addline
      SET soft,ver,softsn TO
         SELECT #ps_soft,#ps_ver,#ps_sn
         FROM pcsoft WHERE #ps_node = pcreport:no_id
      EXECUTING BEGIN
         WRITE PIPELINE pcreport:pipe1 pcol(26),soft,' Ver ',ver,
            pcol(84),'SN: ', softsn
	 addline
      END
      SET $PAGE TO ($PAGE+1)
      WRITE PIPELINE pcreport:pipe1 FormFeed
      heading($PAGE)
      SET $LINENO TO 0
   END   

AFTER FIND
   IF sel = 2 THEN
   BEGIN
      CLOSE PIPELINE pcreport:pipe1;  
      DISPLAY 'Done printing.  Hit RETURN to continue.' FOR FYI_MESSAGE WAIT;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               CREATE PIPELINE pcreport:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
                  pcreport:$printer 
               DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
               heading($PAGE)
               WRITE PIPELINE pcreport:pipe1 pcol(1),setund,'Node',
                  pcol(26), 'Location',pcol(58),'Project/User',pcol(75),
                  'Memory/Hard Drive', pcol(99),'Escalation', unsetund
               WRITE PIPELINE  pcreport:pipe1 pcol(1),no_id,pcol(26),
                  no_site, pcol(58),no_prnum,pcol(75),no_total_mem,'   ',
                  no_hard_disk_ty, pcol(99),no_prob_esc_code
	       SET pcreport:hours,pcreport:days TO
                  SELECT #ec_hours,#ec_days
                  FROM ecode WHERE #ec_num = no_prob_esc_code
               IF no_vtam <> UNDEFINED THEN
               BEGIN
                  WRITE PIPELINE pcreport:pipe1 pcol(1),no_model,pcol(26),
                     no_location,pcol(58),no_pri_user,pcol(75),'VTAM: ',
                     no_vtam, pcol(99),pcreport:hours,' Hrs.  ',
                     pcreport:days,' Days'
               END
	       ELSE
               BEGIN
	          WRITE PIPELINE pcreport:pipe1 pcol(1),no_model,pcol(26),
                     no_location,pcol(58),no_pri_user,pcol(75),'VTAM: N/A',
                     pcol(99), pcreport:hours,' Hrs.  ',pcreport:days,' Days'
               END
	       WRITE PIPELINE pcreport:pipe1 pcol(1),no_vendor,' ',no_group,
                  pcol(26), no_trob_prt, pcol(58),no_phone,pcol(75),
                  'Co Pro: ',no_copro
	       WRITE PIPELINE pcreport:pipe1 pcol(1),no_ser,pcol(58),
                  no_floor_jack, pcol(75),'Key Id: ',no_keyid
	       WRITE PIPELINE pcreport:pipe1 ' '
	       WRITE PIPELINE pcreport:pipe1 pcol(1),'Purchased on ',
                  no_pur_date, ' at ',no_pur_ven,'   PO# ',no_pur_order
	       WRITE PIPELINE pcreport:pipe1 pcol(1),'Cost Center ',
                  no_cost_center,'   Head ',no_cc_head
	       WRITE PIPELINE pcreport:pipe1 ' '
               WRITE PIPELINE pcreport:pipe1 setund,'Comments',unsetund 
	       IF strlen$(no_comment1) > 1 THEN
	          WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment1
	       IF strlen$(no_comment2) > 1 THEN
	          WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment2
	       IF strlen$(no_comment3) > 1 THEN
	          WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment3
               IF strlen$(no_comment4) > 1 THEN
	          WRITE PIPELINE pcreport:pipe1 pcol(1),no_comment4
	       WRITE PIPELINE pcreport:pipe1 ' '
	       /*  PC HARD STUFF  */
	       WRITE PIPELINE pcreport:pipe1 pcol(26),setund,
                  'Hardware Info',unsetund
               SET ven TO ' '
	       SET mod TO ' '
	       SET sn TO ' '
	       SET slot TO ' '
               SET ven,mod,sn,slot TO
                  SELECT #ph_ven,#ph_mod,#ph_sn,#ph_slot
                  FROM pchard WHERE pcreport:no_id = #ph_node
	       EXECUTING BEGIN
	          IF slot <> UNDEFINED THEN
                  BEGIN
	             WRITE PIPELINE pcreport:pipe1 pcol(26),ven, ' ',mod,
                        pcol(84),'SN:',sn,pcol(106),'Slot:',slot
                  END
	          ELSE
                  BEGIN
	             WRITE PIPELINE pcreport:pipe1 pcol(26),ven, ' ',
                        mod,pcol(84),'SN:',sn
                  END
               END
	       WRITE PIPELINE pcreport:pipe1 ' '
	       /*   PC Soft Stuff   */
	       WRITE PIPELINE pcreport:pipe1 pcol(26),setund,'PC Software',
                  unsetund
	       SET soft,ver,softsn,vend,po,softdate TO
                  SELECT #ps_soft,#ps_ver,#ps_sn,#ps_vend,#ps_po,#ps_date
                  FROM pcsoft WHERE #ps_node = pcreport:no_id
	       EXECUTING BEGIN
	          WRITE PIPELINE pcreport:pipe1 pcol(26),soft,' Ver ',ver,
                     ' Vendor ',vend,' PO ',po,' Date ',softdate,pcol(84),
                     'SN: ', softsn
	       END
               CLOSE PIPELINE pcreport:pipe1
               DISPLAY 'Done Printing.  Hit RETURN to continue.'
                  FOR FYI_MESSAGE WAIT ;
               SET sel TO UNDEFINED
            END
         CASE 2:
            BEGIN
               DISPLAY 'Printing Report on selected records.  Please Wait.'
               FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'Enter either 1 OR 2.  Hit ENTER to Continue'
                  FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
