/**************************************************************************
*
*	pcsoft.fs       
*
*	FORM:	pcsoft         
*	DESCRIPTION:	This script handles the form that allows users
*			to enter or change the software inventory for a
*			particular PC.
*
*	AUTHOR:    BSY  (Modified by JWS)
*	DATE:      9/28/89
*	REVIEWER:  BSY
*
****************************************************************************/

FORM pcsoft          

TARGET_TABLE pcsoft

BEFORE FORM
   SET pcsoft:AUTO_COMMIT TO TRUE
   IF PREV_FORM = 'node' THEN
   BEGIN
      SET pcsoft:ps_node: CLEAR_ADD_EXP TO node:no_id
      SET pcsoft:ps_node: CLEAR_FIND_EXP to node:no_id
      SET pcsoft:next_line: CLEAR_ADD_EXP to node:no_next_soft
      SET pcsoft:ps_node: STOP_FOR_INPUT to FALSE
      IF node:no_next_soft > 0 THEN
         SET pcsoft:AUTO_FIND TO TRUE
      ELSE
         SET pcsoft:AUD_ON_ENTRY TO TRUE
   END

ON CLEAR TO ADD
   IF PREV_FORM <> 'node' THEN
   BEGIN
      beep$(1)
      DISPLAY 'To add a software record, go to Node Information, find a PC, and press [F2].' FOR FYI_MESSAGE WAIT
   END

BEFORE ADD
   IF PREV_FORM <> 'node' THEN
   BEGIN
      beep$(1)
      DISPLAY 'To add a PC software entry, go to node information, find a PC, and press [F2].' FOR FYI_MESSAGE WAIT
      REJECT OPERATION
   END
   ELSE
   BEGIN
      SET pcsoft:ps_lnum TO pcsoft:next_line
      SET pcsoft:next_line TO pcsoft:next_line + 1
   END

AFTER ADD
   SET node:no_next_soft TO pcsoft:next_line
   UPDATE node SET #no_next_soft to pcsoft:next_line WHERE #no_id = node:no_id

FIELD ps_soft
   BEFORE FIELD
      ENABLE ZOOM to part RETURN KEY
   ON FIELD
      INPUT
      BEGIN
         SET pcsoft:old_soft TO pcsoft:ps_soft
         SET pcsoft:ps_soft TO SELECT #pa_name FROM parts WHERE #pa_name = pcsoft:ps_soft
         IF status$() < 0 THEN
         BEGIN
            DISPLAY pcsoft:old_soft + ' was not found, press RETURN to continue.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD ps_ver
   ON FIELD
      INPUT
      SET pcsoft:ps_amount TO
         SELECT #sv_price FROM softvend
         WHERE #sv_sname = pcsoft:ps_soft AND #sv_ver = pcsoft:ps_ver
