/**************************************************************************
*
*	pcsoftrep.fs    
*
*	FORM:	pcsoftrep      
*	DESCRIPTION:	This script generates standard PC Software
*			reports.
*
*	AUTHOR:    DWM
*	DATE:      01/18/90
*	REVIEWER:  DWM
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM pcsoftrep       

TARGET_TABLE pcsoft

LOCAL sel,printer;

BEFORE FORM
   SET pcsoftrep:sel:STOP_FOR_INPUT TO TRUE
   SET pcsoftrep:FIRST_FIELD TO 'sel'
   SET pcsoftrep:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(pcsoft,pcsoftrep,ps_node)
   set_select(pcsoft,pcsoftrep,ps_lnum)
   set_select(pcsoft,pcsoftrep,ps_soft)
   set_select(pcsoft,pcsoftrep,ps_ver)
   set_select(pcsoft,pcsoftrep,ps_sn)
   set_select(pcsoft,pcsoftrep,ps_vend)
   set_select(pcsoft,pcsoftrep,ps_po)
   set_select(pcsoft,pcsoftrep,ps_date)
   IF sel = 2 THEN
   BEGIN
      CREATE PIPELINE pcsoftrep:pipe1 'RPT /usr/db/ACL4/rptdir/pcsoft.r -',
         printer;
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
   END

ON FIND
   IF sel = 2 THEN
      WRITE PIPELINE pcsoftrep:pipe1 ps_node, ps_soft, ps_ver, ps_sn,
         ps_vend, ps_po, ps_date

AFTER FIND
   IF sel = 2 THEN
   BEGIN
      CLOSE PIPELINE pcsoftrep:pipe1;
      DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE WAIT;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               CREATE PIPELINE pcsoftrep:pipe1 'RPT /usr/db/ACL4/rptdir/pcsoft.r -',
                  printer;
               WRITE PIPELINE pcsoftrep:pipe1 ps_node, ps_soft, ps_ver,
                  ps_sn, ps_vend, ps_po, ps_date
               CLOSE PIPELINE pcsoftrep:pipe1;
               DISPLAY 'Done printing Single record.  Hit RETURN to continue.'
                  FOR FYI_MESSAGE WAIT;
               SET sel TO UNDEFINED
            END
         CASE 2:
            BEGIN
               DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'Either 1 or 2.' FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
