/**************************************************************************
*
*	pcsoftrep2.fs   
*
*	FORM:	pcsoftrep2     
*	DESCRIPTION:	This script generates reports for PC Software
*			that make upgrades convenient.  Sorting is done
*			done by site, department, and software name.
*
*	AUTHOR:    JWS
*	DATE:      Summer 1991
*	REVIEWER:  JWS
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM pcsoftrep2

TARGET_TABLE pcsoft

LOCAL sel,printer;

BEFORE FORM
   SET pcsoftrep2:sel:STOP_FOR_INPUT TO TRUE
   SET pcsoftrep2:FIRST_FIELD TO 'sel'
   SET pcsoftrep2:AUTO_FIND TO TRUE
   SET sel TO UNDEFINED
   SET $printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(pcsoft_ind,pcsoftrep2,ps_node)
   set_select(pcsoft_ind,pcsoftrep2,ps_soft)
   set_select(pcsoft_ind,pcsoftrep2,ps_ver)
   set_select(pcsoft_ind,pcsoftrep2,ps_sn)
   set_select(pcsoft_ind,pcsoftrep2,ps_site)
   set_select(pcsoft_ind,pcsoftrep2,ps_dept)

   IF sel='2' THEN
      CREATE PIPELINE pcsoftrep2:pipe1 'RPT /usr/db/ACL4/rptdir/pcsoft2a.r -',
         printer;
   IF sel='3' THEN
      CREATE PIPELINE pcsoftrep2:pipe1 'RPT /usr/db/ACL4/rptdir/pcsoft2b.r -',
         printer;

   DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;

ON FIND
   IF ((sel = '2') OR (sel = '3')) THEN
      WRITE PIPELINE pcsoftrep2:pipe1 ps_node, ps_soft, ps_ver, ps_sn,
         ps_site, ps_dept

AFTER FIND
   IF ((sel = '2') OR (sel = '3')) THEN
   BEGIN
      CLOSE PIPELINE pcsoftrep2:pipe1;
      DISPLAY 'Done printing Report on selected records.' FOR FYI_MESSAGE WAIT;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE '1':
            BEGIN
               CREATE PIPELINE pcsoftrep2:pipe1 'RPT /usr/db/ACL4/rptdir/pcsoft2a.r -',
                  printer;
               WRITE PIPELINE pcsoftrep2:pipe1 pcsoft_ind:ps_node,
                  pcsoft_ind:ps_soft, pcsoft_ind:ps_ver, pcsoft_ind:ps_sn,
                  pcsoft_ind:ps_site, pcsoft_ind:ps_dept
               CLOSE PIPELINE pcsoftrep2:pipe1
               DISPLAY 'Done printing single record.  Hit RETURN to continue.'
                  FOR FYI_MESSAGE WAIT;
               SET sel TO UNDEFINED
            END
         CASE '2':
            BEGIN
               DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE '3':
            BEGIN
               DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN
               DISPLAY 'Enter either 1, 2, or 3.  Press RETURN to try again.'
                  FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
