/**************************************************************************
*
*	poreport.fs     
*
*	FORM:	poreport       
*	DESCRIPTION:	This script generates reports for the Parts
*			Out for Repair section of the database.
*
*	AUTHOR:    Unknown
*	DATE:      Unknown
*	REVIEWER:  Unknown
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM poreport        

TARGET_TABLE parout

LOCAL sel,printer

BEFORE FORM
   SET poreport:sel:STOP_FOR_INPUT TO TRUE
   SET poreport:FIRST_FIELD TO 'sel'
   SET poreport:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(partsout,poreport,po_tic)
   set_select(partsout,poreport,po_stat)
   set_select(partsout,poreport,po_nid)
   set_select(partsout,poreport,po_tagd)
   set_select(partsout,poreport,po_ven)
   set_select(partsout,poreport,po_ra)
   set_select(partsout,poreport,po_ship)
   set_select(partsout,poreport,po_div)
   set_select(partsout,poreport,po_req)
   set_select(partsout,poreport,po_retd)
   set_select(partsout,poreport,po_po)
   set_select(partsout,poreport,po_pnam)
   set_select(partsout,poreport,po_sn)
   set_select(partsout,poreport,po_fail)
   set_select(partsout,poreport,po_fal2)
   set_select(partsout,poreport,po_fix)
   set_select(partsout,poreport,po_fix2)
   set_select(partsout,poreport,po_cost)
   set_select(partsout,poreport,po_prob)
   IF sel = 2 THEN
   BEGIN
      CREATE PIPELINE poreport:pipe1 'RPT /usr/db/ACL4/rptdir/po_rep.r -',
         printer;
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
   END

ON FIND
   IF sel = 2 THEN
      WRITE PIPELINE poreport:pipe1 poreport:po_ven, poreport:po_tic,
         poreport:po_nid, poreport:po_sn,poreport:po_ship

AFTER FIND
   IF sel = 2 THEN
   BEGIN
      CLOSE PIPELINE poreport:pipe1;
      DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE WAIT;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
   INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               CREATE PIPELINE poreport:pipe1 'RPT /usr/db/ACL4/rptdir/po_rep.r -',
                  printer;
               WRITE PIPELINE poreport:pipe1 poreport:po_ven,poreport:po_tic,
                  poreport:po_nid,poreport:po_sn,poreport:po_ship;
               CLOSE PIPELINE poreport:pipe1;
               DISPLAY 'Done printing single record. Hit RETURN to continue.'
                  FOR FYI_MESSAGE WAIT;
               SET sel TO UNDEFINED
            END
         CASE 2:
            BEGIN
               DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'Enter either 1 or 2.  Hit RETURN to try again.'
                  FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
