/**************************************************************************
*
*	problem.fs      
*
*	FORM:	problem        
*	DESCRIPTION:	This form is the focal point of the problem
*			management and trouble ticketing sub-systems
*			of HDMS as far as the user is concerned.  This
*			is one of the more complex scripts in HDMS in
*			terms of the number of features.
*
*	AUTHOR:    BSY  (Modified by JWS)
*	DATE:      8/9/89
*	REVIEWER:  BSY
*
****************************************************************************/

FORM problem

TARGET_TABLE problem

BEFORE FORM
   SET problem:AUTO_COMMIT TO TRUE
   SET problem:pr_corn TO 'N'
   SET problem:typ TO '   Node'

   IF PREV_FORM = 'probres' THEN
   BEGIN
      SET problem:pr_num: CLEAR_FIND_EXP TO str_to_val$(probres:pt_pc3)
      SET problem:pr_stat: CLEAR_FIND_EXP TO '*'
      SET problem:AUTO_FIND TO TRUE
   END

   IF PREV_FORM = 'problems' THEN
   BEGIN
      SET problem:pr_num: CLEAR_FIND_EXP TO problems:pr_num
      SET problem:AUTO_FIND TO TRUE
   END

   IF PREV_FORM = 'sendprview' THEN
   BEGIN
      SET problem:$pr_num: CLEAR_FIND_EXP TO sendprview:$sp_prnum
      SET problem:pr_stat: CLEAR_FIND_EXP TO '*'
      SET problem: AUTO_FIND TO TRUE
   END

ON CLEAR TO ADD
   XLOCK nextnum
   SET problem:pr_num TO
      SELECT #nxt_num FROM nextnum WHERE #nxt_field_name = 'pr_num'
   UPDATE nextnum
      SET #nxt_num TO problem:pr_num + 1 WHERE #nxt_field_name='pr_num'
   UNLOCK nextnum
   SET pr_stat TO 'O'
   SET pr_corn to 'N'
   SET problem:typ to '   Node'
   SET pr_open_date to current_date$()
   SET pr_open_time to current_time$()
   SET problem:edes to UNDEFINED
   SET problem:problem_des to UNDEFINED
   SET pr_stat: STOP_FOR_INPUT to FALSE    
   SET pr_node: STOP_FOR_INPUT to TRUE
   SET pr_model: STOP_FOR_INPUT to FALSE
   SET pr_vendor: STOP_FOR_INPUT to TRUE 
   SET pr_sn: STOP_FOR_INPUT to TRUE
   SET pr_close_date: STOP_FOR_INPUT to FALSE
   SET pr_close_time: STOP_FOR_INPUT to FALSE

ON CLEAR TO FIND
   IF PREV_FORM = 'problems' THEN
      SET pr_stat: CLEAR_FIND_EXP TO problems:pr_stat
   ELSE IF PREV_FORM = 'probres' THEN
      SET pr_stat: CLEAR_FIND_EXP TO '*'
   ELSE
      SET pr_stat: CLEAR_FIND_EXP TO 'O'
   SET pr_corn TO 'N'
   SET typ TO '   Node'
   SET pr_stat: STOP_FOR_INPUT to TRUE    
   SET pr_num: STOP_FOR_INPUT TO TRUE
   SET pr_open_date: STOP_FOR_INPUT to TRUE
   SET pr_open_time: STOP_FOR_INPUT to TRUE
   SET pr_close_date: STOP_FOR_INPUT to TRUE
   SET pr_close_time: STOP_FOR_INPUT to TRUE
   SET pr_model: STOP_FOR_INPUT to TRUE
   SET pr_sn: STOP_FOR_INPUT to TRUE
   SET pr_phone: STOP_FOR_INPUT to TRUE
   SET pr_vendor: STOP_FOR_INPUT to TRUE
   SET pr_site: STOP_FOR_INPUT to TRUE
   SET pr_loc: STOP_FOR_INPUT to TRUE
   SET pr_vp: STOP_FOR_INPUT to TRUE

AFTER FIND
   SET pr_num: STOP_FOR_INPUT TO FALSE
   SET pr_open_date: STOP_FOR_INPUT to TRUE
   SET pr_open_time: STOP_FOR_INPUT to TRUE
   SET pr_model: STOP_FOR_INPUT to FALSE
   SET pr_vp: STOP_FOR_INPUT to FALSE
   SET pr_site: STOP_FOR_INPUT to FALSE

AFTER ADD
   SET pr_stat: STOP_FOR_INPUT TO TRUE    

ON NEXT FORM  
   IF (NOT is_current_record_stored$()) THEN
   BEGIN
      IF pr_stat = 'C' THEN
      BEGIN
         IF problem:$pr_close_date = str_to_date$('**/**/**') THEN
            SET pr_close_date TO current_date$()
			IF problem:$pr_close_time = str_to_time$('00:00') THEN
            SET pr_close_time TO current_time$()
      END
      UPDATE CURRENT RECORD
   END
   IF NOT record_is_current$() THEN
   BEGIN
      beep$(1)
      DISPLAY 'Cannot NEXT-FORM witout a problem number.  RETURN to continue.'
         FOR FYI_MESSAGE WAIT
      REJECT OPERATION
      UPDATE CURRENT RECORD
   END

ON PREVIOUS FORM
   IF (NOT is_current_record_stored$()) THEN
   BEGIN
      IF pr_stat = 'C' THEN
      BEGIN
         IF problem:$pr_close_date = str_to_date$('**/**/**') THEN
            SET pr_close_date TO current_date$()
			IF problem:$pr_close_time = str_to_time$('00:00') THEN
            SET pr_close_time TO current_time$()
      END
      IF pr_node <> UNDEFINED THEN
         UPDATE CURRENT RECORD
   END
		
AFTER FORM RETURN
   SET pr_stat: STOP_FOR_INPUT TO TRUE
   SET problem:trob_tick, problem:tech, problem:udate, problem:utime,
      problem:r1, problem:r2, problem:r3, problem:pr_assig TO
      SELECT #pt_trob_tick, #pt_tech, #pt_date, #pt_time, #pt_pc1,
         #pt_pc2, #pt_pc3, #pt_assig
      FROM probres
      WHERE #pt_num = problem:pr_num AND #pt_lnum = problem:pr_next_res - 1
   SET problem:resnum TO problem:pr_next_res
   UPDATE CURRENT RECORD

BEFORE UPDATE
   IF (NOT is_current_record_stored$()) THEN
   BEGIN
      IF pr_stat = 'C' THEN
      BEGIN
         IF problem:$pr_close_date = str_to_date$('**/**/**') THEN
            SET pr_close_date TO current_date$()
			IF problem:$pr_close_time = str_to_time$('00:00') THEN
            SET pr_close_time TO current_time$()
      END
   END

FIELD pr_stat
   BEFORE FIELD
      ENABLE ZOOM to probres
      SET problem:trob_tick, problem:tech, problem:udate, problem:utime,
         problem:r1, problem:r2, problem:r3, problem:pr_assig TO
         SELECT #pt_trob_tick, #pt_tech, #pt_date, #pt_time, #pt_pc1,
            #pt_pc2, #pt_pc3, #pt_assig
         FROM probres
         WHERE ((#pt_num=problem:pr_num) AND
                (#pt_lnum=problem:pr_next_res - 1))
      SET problem:resnum TO problem:pr_next_res
   ON FIELD
      INPUT
      SWITCH pr_stat
      BEGIN
         CASE 'O':
            BEGIN
               DISPLAY pr_stat
               SET pr_close_date TO str_to_date$('**/**/**')
               SET pr_close_time TO str_to_time$('00:00')
            END
         CASE 'P':
            DISPLAY pr_stat
         CASE 'C':
            DISPLAY pr_stat
         CASE UNDEFINED:
            BEGIN
               SET pr_stat to 'O'
               DISPLAY pr_stat
            END
         DEFAULT:
            BEGIN
               DISPLAY 'Enter O, C, or P. Press RETURN to try again.'
                  FOR FYI_MESSAGE WAIT
               RESTART ON FIELD
            END
      END
   WHEN FIELD CHANGES
      SWITCH pr_stat
      BEGIN
         CASE 'O': SET status to 'pen'
         CASE 'C': SET status to 'losed'
         CASE 'P': SET status to 'erpetual'
      END

FIELD pr_resp
   WHEN FIELD CHANGES
      SWITCH pr_resp
      BEGIN
	 CASE 'N': SET resp_text to 'orthern Netops'
	 CASE 'S': SET resp_text to 'outhern Netops'
	 CASE 'V': SET resp_text to 'endor'
	 CASE 'U': SET resp_text to 'ser Services'
	 DEFAULT: SET resp_text to ''
      END

FIELD pr_corn
   ON FIELD
      INPUT
      IF ((pr_corn <> 'N') AND (pr_corn <> 'C')) THEN
      BEGIN
         DISPLAY 'Enter N or C only.  Press RETURN to try again.'
            FOR FYI_MESSAGE WAIT
         RESTART ON FIELD
      END
   WHEN FIELD CHANGES
      SWITCH pr_corn
      BEGIN
         CASE 'N': SET problem:typ TO '   Node'
         CASE 'C': SET problem:typ TO 'Circuit'
      END

FIELD pr_node
   BEFORE FIELD
      IF problem:pr_corn='N' THEN
      BEGIN
         ENABLE ZOOM TO node
         SET problem:old_node TO problem:pr_node
      END
      ELSE
      BEGIN
         ENABLE ZOOM to mastcircin
         SET problem:old_node TO problem:pr_node
      END
   ON FIELD
      INPUT
      IF problem:old_node <> problem:pr_node THEN
      BEGIN
         IF problem:pr_corn='N' THEN
         BEGIN
            SET problem:old_node TO problem:pr_node
            SET problem:pr_sn TO SELECT #no_ser FROM node
               WHERE #no_id = problem:pr_node
      END
      ELSE
         SET problem:old_node TO problem:pr_node
         IF ((status$() < 0) AND (problem:pr_corn='N')) THEN
         BEGIN
            DISPLAY problem:old_node + ' was not found.  RETURN to try again.'
               FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
         ELSE
         BEGIN
            IF problem:pr_corn='N' THEN
            BEGIN
               SET problem:pr_node, problem:pr_model, problem:pr_sn,
                   problem:pr_phone, problem:pr_vendor, problem:pr_site,
                   problem:pr_loc, problem:pr_trob_prt,
                   problem:pr_prob_esc_code, problem:pr_serv, problem:pr_prio
               TO SELECT #no_id, #no_model, #no_ser, #no_phone, #no_vendor,
                      #no_site, #no_location, #no_trob_prt, #no_prob_esc_code,
                      #no_serv_num, #no_priority
               FROM node
               WHERE #no_id = problem:pr_node
            END
         END
      END

FIELD pr_num
   BEFORE FIELD
      IF pr_num <> UNDEFINED THEN
         SET pr_num: STOP_FOR_INPUT TO FALSE

/* FIELD pr_open_date
   BEFORE FIELD
      IF pr_open_date <> UNDEFINED THEN
         SET pr_open_date: STOP_FOR_INPUT TO FALSE */

/* FIELD pr_open_time
   BEFORE FIELD
      IF pr_open_time <> UNDEFINED THEN
         SET pr_open_time: STOP_FOR_INPUT TO FALSE */

FIELD pr_model
   BEFORE FIELD
      IF pr_model <> UNDEFINED THEN
         SET pr_model: STOP_FOR_INPUT TO FALSE

FIELD pr_sn
   BEFORE FIELD
      ENABLE ZOOM to circsum
      SET problem:old_sn TO problem:pr_sn
      IF problem:pr_corn = 'C' THEN
      BEGIN
         SET problem:pr_prob_esc_code TO 7
         SET problem:pr_trob_prt TO 'NCC'
      END
   ON FIELD
      INPUT
      IF problem:old_sn <> problem:pr_sn THEN
      BEGIN
         SET problem:old_sn TO problem:pr_sn
         IF ((status$() < 0) AND (problem:pr_corn='N')) THEN
         BEGIN
            DISPLAY problem:old_sn + ' was not found.  RETURN to try again.'
               FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD pr_vendor
   BEFORE FIELD
      ENABLE ZOOM to vendor RETURN KEY
      SET problem:old_vendor TO problem:pr_vendor
      IF pr_vendor <> UNDEFINED THEN
      BEGIN
         SET problem:pr_vp TO
            SELECT #ve_ph FROM vendor WHERE #ve_id = problem:pr_vendor
      END
   ON FIELD
      INPUT
      IF problem:old_vendor <> problem:pr_vendor THEN
      BEGIN
         SET problem:pr_vendor_code TO
            SELECT #vc_num FROM vcode
            WHERE #vc_site = problem:pr_site AND #vc_vend = problem:pr_vendor
         SET problem:old_vendor to problem:pr_vendor
         SET problem:pr_vp TO
            SELECT #ve_ph FROM vendor WHERE #ve_id = problem:pr_vendor
         IF status$() < 0 THEN
         BEGIN
            DISPLAY problem:old_vendor + ' was not found.  RETURN to try again.'
               FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD pr_site
   BEFORE FIELD
      IF pr_site <> UNDEFINED THEN
      BEGIN
         SET pr_site: STOP_FOR_INPUT TO FALSE
         SET problem:pr_address, problem:pr_city_state TO
            SELECT #si_address1, #si_city_state FROM site
            WHERE #si_id = problem:pr_site
      END
      ELSE
         ENABLE ZOOM to site RETURN KEY

FIELD pr_vp
   BEFORE FIELD
      IF pr_vp <> UNDEFINED THEN
         SET pr_vp: STOP_FOR_INPUT TO FALSE

FIELD pr_vendor_code
   BEFORE FIELD
      SET pr_vendor_code: STOP_FOR_INPUT TO FALSE
      SET problem:pr_vendor_code TO
         SELECT #vc_num FROM vcode
         WHERE #vc_site = problem:pr_site AND #vc_vend = problem:pr_vendor

FIELD pr_trob_prt
   BEFORE FIELD
      ENABLE ZOOM to tprt RETURN KEY
   ON FIELD
      INPUT;
      IF problem:pr_trob_prt <> UNDEFINED THEN
      BEGIN
         SET problem:trash TO
            SELECT #tp_name FROM tprt WHERE #tp_name = problem:pr_trob_prt
         IF status$() <> 0 THEN
         BEGIN
            DISPLAY problem:pr_trob_prt + ' is not a valid printer, press FIELD HELP (F5) for printer ids.'
               FOR FYI_MESSAGE WAIT
            SET problem:pr_trob_prt to UNDEFINED
            RESTART ON FIELD
         END
      END

FIELD pr_prob_esc_code
   BEFORE FIELD
      ENABLE ZOOM to ecode RETURN KEY
      SET problem:tmp TO UNDEFINED
      SET problem:hours TO UNDEFINED
      SET problem:days  TO UNDEFINED
   ON FIELD
      INPUT;
      IF problem:pr_prob_esc_code <> UNDEFINED THEN
      BEGIN
         SET problem:tmp TO
            SELECT #ec_num FROM ecode WHERE #ec_num = problem:pr_prob_esc_code
         IF status$() <> 0 THEN
         BEGIN
            DISPLAY 'Invalid escalation code.  ZOOM for list of escalation codes.'
               FOR FYI_MESSAGE WAIT
            SET problem:pr_prob_esc_code to 0
            RESTART ON FIELD
         END
      END
   WHEN FIELD CHANGES
      SET problem:hours TO
         SELECT #ec_hours FROM ecode WHERE #ec_num = pr_prob_esc_code
      SET problem:days TO
         SELECT #ec_days FROM ecode WHERE #ec_num = pr_prob_esc_code
      SET pr_code_des TO
         val_to_str$(problem:days)+' day '+val_to_str$(problem:hours)+' hr'

FIELD pr_id
   BEFORE FIELD
      ENABLE ZOOM to probcode RETURN KEY
   ON FIELD
      INPUT
      IF problem:pr_id <> UNDEFINED THEN
      BEGIN
         SET problem:trash TO
            SELECT #prc_id FROM probcode WHERE #prc_id = problem:pr_id
         IF status$() < 0 THEN
         BEGIN
            DISPLAY problem:pr_id + ' was not found.  RETURN to try again.'
               FOR FYI_MESSAGE WAIT
            SET problem:pr_id to UNDEFINED
            SET problem:problem_des to UNDEFINED
            RESTART ON FIELD
         END
      END
   WHEN FIELD CHANGES
   SET problem:problem_des TO
      SELECT #prc_des FROM probcode WHERE #prc_id = problem:pr_id

FIELD pr_contact
   BEFORE FIELD
      ENABLE ZOOM TO phone
