/**************************************************************************
*
*	probreport.fs   
*
*	FORM:	probreport     
*	DESCRIPTION:
*
*	AUTHOR:    DWM
*	DATE:      01/08/90
*	REVIEWER:  DWM
*
****************************************************************************/

#define ESC char_code_to_str$(27)

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define pcol(X)\
    ESC,'&a',X,'C'

#define FormFeed char_code_to_str$(12)

#define mtstring ''

#define regset ESC,'(8U',ESC,'(s0p16.67h8.5v0s0b0T',ESC,'&l0o'

#define heading(pageno) \
   WRITE PIPELINE probreport:pipe1 ESC,'(8U',ESC,'(s1p12.0v0s0b5T',ESC,'&l0o',pcol(1), \
   current_date$(),'   ',\
   current_time$(), \
   '                            PROBLEM REPORT            ', \
   '                                          ', pageno,'\n', \
   regset

#define setund ESC,'&dD'

#define unsetund ESC,'&d@'

#define addline \
   IF $LINENO > 60 THEN \
   BEGIN \
      WRITE PIPELINE probreport:pipe1 FormFeed; \
      SET PAGE TO PAGE + 1 \
      heading($PAGE)  \
      SET $LINENO TO 0 \
   END \
   ELSE \
      SET $LINENO TO ($LINENO+1)

FORM probreport      

TARGET_TABLE problem 

LOCAL sel,printer;

BEFORE FORM
   SET sel TO UNDEFINED
   SET probreport:AUTO_FIND TO TRUE
   SET printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(problem,probreport,pr_num)
   set_select(problem,probreport,pr_stat)
   set_select(problem,probreport,pr_open_date)
   set_select(problem,probreport,pr_open_time)
   set_select(problem,probreport,pr_close_date)
   set_select(problem,probreport,pr_close_time)
   set_select(problem,probreport,pr_node)
   set_select(problem,probreport,pr_site)
   set_select(problem,probreport,pr_vendor)
   set_select(problem,probreport,pr_vendor_code)
   set_select(problem,probreport,pr_prob_esc_code)
   set_select(problem,probreport,pr_trob_prt)
   set_select(problem,probreport,pr_pc1)
   set_select(problem,probreport,pr_pc2)
   set_select(problem,probreport,pr_pc3)
   set_select(problem,probreport,pr_pc4)
   set_select(problem,probreport,pr_pc5)
   set_select(problem,probreport,pr_next_res)
   set_select(problem,probreport,pr_phone)
   set_select(problem,probreport,pr_sn)
   set_select(problem,probreport,pr_vp)
   set_select(problem,probreport,pr_model)
   set_select(problem,probreport,pr_loc)
   set_select(problem,probreport,pr_address)
   set_select(problem,probreport,pr_city_state)
   set_select(problem,probreport,pr_esc_date)
   set_select(problem,probreport,pr_esc_time)
   set_select(problem,probreport,pr_contact)
   set_select(problem,probreport,pr_id)
   set_select(problem,probreport,pr_prt)
   set_select(problem,probreport,pr_code)
   set_select(problem,probreport,pr_major_prob)
   set_select(problem,probreport,pr_resp)
   IF sel = 2 THEN
   BEGIN
      SET $PAGE TO 1
      SET $LINENO TO 1
      CREATE PIPELINE probreport:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         printer;
      heading($PAGE)
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
   END
   IF sel = 3 THEN
   BEGIN
      CREATE PIPELINE probreport:pipe1 'RPT /usr/db/ACL4/rptdir/probtime.r -',
         printer;
   END
   IF sel = 4 THEN
   BEGIN
      CREATE PIPELINE probreport:pipe1 'RPT /usr/db/ACL4/rptdir/probtime.r -',
         printer;
   END

ON FIND
   IF sel = 3 THEN
   BEGIN
      DISPLAY 'Problem: ' + val_to_str$(pr_num) FOR FYI_MESSAGE
      WRITE PIPELINE probreport:pipe1 pr_num, pr_open_time, pr_open_date,
         pr_close_time, pr_close_date, pr_node
   END
   IF sel = 2 THEN
   BEGIN
      IF $LINENO > 45 THEN
      BEGIN
         SET $PAGE TO ($PAGE+1)
	 WRITE PIPELINE probreport:pipe1 FormFeed
         heading($PAGE)  
	 SET $LINENO TO 1
      END
      WRITE PIPELINE probreport:pipe1 regset,pcol(1),setund,'Problem',
         pcol(13),'Opened On',pcol(25),'Closed Date',pcol(41),'Node Id',
         pcol(61),'Contact',pcol(83),'Problem Code',pcol(105),
         'Trouble Printer',pcol(125),unsetund
      addline
      WRITE PIPELINE probreport:pipe1 pcol(1),pr_num,pcol(13),pr_open_date,
         pcol(25),pr_close_date,pcol(41),pr_node,pcol(61),pr_contact,
         pcol(83), pr_id,pcol(105),pr_trob_prt
      addline
      SET desc TO SELECT #prc_des FROM probcode WHERE #prc_id = $pr_id
      IF desc = UNDEFINED THEN
         SET desc TO ' '
      WRITE PIPELINE probreport:pipe1 pcol(13),pr_open_time,pcol(25),
         pr_close_time,pcol(41),pr_model,pcol(61),pr_phone,pcol(83),
         pr_site,pcol(105),pr_prob_esc_code
      addline
      WRITE PIPELINE probreport:pipe1 pcol(41),pr_sn,pcol(61),pr_loc,
         pcol(83),desc
      addline
      WRITE PIPELINE probreport:pipe1 ' '
      addline
      WRITE PIPELINE probreport:pipe1 pcol(33),setund, 'Problem Description',
         regset,unsetund
      addline
      IF pr_pc1 <> mtstring THEN
      BEGIN
	 WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc1
	 addline
      END
      IF pr_pc2 <> mtstring THEN
      BEGIN
         WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc2 
	 addline
      END
      IF pr_pc3 <> mtstring THEN
      BEGIN
         WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc3
	 addline
      END
      IF pr_pc4 <> mtstring THEN
      BEGIN
         WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc4 
	 addline
      END
      WRITE PIPELINE probreport:pipe1 ' '
      addline
      IF $LINENO > 49  THEN 
      BEGIN
         SET $PAGE TO ($PAGE+1)
	 WRITE PIPELINE probreport:pipe1 FormFeed
         heading($PAGE)  
	 SET $LINENO TO 0
      END
      WRITE PIPELINE probreport:pipe1 pcol(33),setund,'Problem Resolution(s)',
         regset,unsetund
      addline
      SET a, b, c, d, e, lnum, resdate, tech, restime TO
         SELECT #pt_pc1, #pt_pc2, #pt_pc3, #pt_pc4, #pt_pc5, #pt_lnum,
            #pt_date, #pt_tech, #pt_time
         FROM probres
         WHERE #pt_num = pr_num
      EXECUTING BEGIN
	 IF a <> mtstring THEN
	 BEGIN
	    WRITE PIPELINE probreport:pipe1 'Update# ', lnum, ' ', tech,
               pcol(33), a
	    addline
	 END
	 IF b <> mtstring THEN
	 BEGIN
	    WRITE PIPELINE probreport:pipe1 'Date ', resdate, ' Time ',
               restime, pcol(33), b
	    addline
         END 
	 ELSE
         BEGIN
            IF a <> mtstring THEN
	    BEGIN
 	       WRITE PIPELINE probreport:pipe1 'Date ', resdate, ' Time ',
                  restime
	       addline
            END
	 END
	 IF c <> mtstring THEN
	 BEGIN
	    WRITE PIPELINE probreport:pipe1 pcol(33), c;
	    addline
	 END 
	 IF d <> mtstring THEN
	 BEGIN
	    WRITE PIPELINE probreport:pipe1 pcol(33), d;
	    addline
	 END
	 IF e <> mtstring THEN
	 BEGIN
	    WRITE PIPELINE probreport:pipe1 pcol(33),e ;
	    addline
	 END
         WRITE PIPELINE probreport:pipe1 ' \n';
         addline
      END   
      WRITE PIPELINE probreport:pipe1 ' \n';
      addline
   END
   
AFTER FIND
   IF sel = 2 OR sel = 3 THEN
   BEGIN
      CLOSE PIPELINE probreport:pipe1;  
      DISPLAY 'Done printing all records.  Hit RETURN to continue.'
         FOR FYI_MESSAGE WAIT;
      SET sel TO UNDEFINED
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SET a TO ''
      SET b TO ''
      SET c TO ''
      SET d TO ''
      SET e TO ''
      SWITCH sel
      BEGIN
         CASE 1 : 
            BEGIN
               CREATE PIPELINE probreport:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
                  printer;
               SET $PAGE TO 1
               SET $LINENO TO 1
               heading($PAGE)
               WRITE PIPELINE probreport:pipe1 regset,pcol(1),setund,
                  'Problem', pcol(13),'Opened On',pcol(25),'Closed Date',
                  pcol(41),'Node Id', pcol(61),'Contact',pcol(83),
                  'Problem Code',pcol(105), 'Trouble Printer',pcol(125),
                  unsetund
               DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
               WRITE PIPELINE probreport:pipe1 pcol(1),pr_num,pcol(13),
                  pr_open_date, pcol(25),pr_close_date,pcol(41),pr_node,
                  pcol(61),pr_contact,pcol(83), pr_id,pcol(105),pr_trob_prt
               SET desc TO SELECT #prc_des FROM probcode WHERE #prc_id = $pr_id
               IF desc = UNDEFINED THEN
                  SET desc TO ' '
               WRITE PIPELINE probreport:pipe1 pcol(13),pr_open_time,pcol(25),
                  pr_close_time,pcol(41),pr_model,pcol(61),pr_phone,pcol(83),
                  pr_site,pcol(105),pr_prob_esc_code
               WRITE PIPELINE probreport:pipe1 pcol(41),pr_sn,pcol(61),pr_loc,
                  pcol(83),desc
               WRITE PIPELINE probreport:pipe1 ' '
               WRITE PIPELINE probreport:pipe1 pcol(48),setund,
                  'Problem Description', regset,unsetund
               IF pr_pc1 <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc1
               IF pr_pc2 <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc2 
               IF pr_pc3 <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc3
               IF pr_pc4 <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33),pr_pc4 
               WRITE PIPELINE probreport:pipe1 ' '
               WRITE PIPELINE probreport:pipe1 pcol(48),setund,
                  'Problem Resolution(s)', regset,unsetund
               SET a,b,c,d,e,lnum,resdate,tech,restime TO
                  SELECT #pt_pc1, #pt_pc2, #pt_pc3, #pt_pc4, #pt_pc5, #pt_lnum,
                     #pt_date, #pt_tech, #pt_time
                  FROM probres WHERE #pt_num = pr_num
               EXECUTING BEGIN
               IF a <> mtstring THEN
               BEGIN
                  WRITE PIPELINE probreport:pipe1 'Update# ',lnum,' Tech ',
                     tech,pcol(33),a;
               END
               IF b <> mtstring THEN
               BEGIN
                  WRITE PIPELINE probreport:pipe1 'Date ',resdate,' Time ',
                     restime,pcol(33),b
               END
               ELSE
               BEGIN
                  IF a <> mtstring THEN
                  BEGIN
                     WRITE PIPELINE probreport:pipe1 'Date ',resdate,' Time ',
                        restime;
                  END
               END
               IF c <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33), c;
               IF d <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33),d;
               IF e <> mtstring THEN
                  WRITE PIPELINE probreport:pipe1 pcol(33),e;
               WRITE PIPELINE probreport:pipe1 ' ';
            END
            WRITE PIPELINE probreport:pipe1 pcol(1),'------------------------------------------------------------------------------------------------------------------'
            CLOSE PIPELINE probreport:pipe1 
            DISPLAY 'Done printing single record.  Hit RETURN to continue.'
               FOR FYI_MESSAGE WAIT;
            SET sel TO UNDEFINED
         END
         CASE 2:
            BEGIN
               DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE 3:
            BEGIN
               IF problem:pr_stat:SEARCH_RANGES = 'O' THEN
               BEGIN
                  beep$(1)
                  DISPLAY 'This report prints only closed problems.'
                     FOR FYI_MESSAGE WAIT;
                  sleep$(2)
                  RESTART ON FIELD
               END
               DISPLAY 'Printing Report on selected records.' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE 4:
            BEGIN
               beep$(1)
               DISPLAY 'This function is under construction.' FOR FYI_MESSAGE
               sleep$(3)
               RESTART ON FIELD
            END
         DEFAULT:
            BEGIN 
               beep$(1)
               DISPLAY 'Enter 1, 2, 3, and 4 only.  Press RETURN to try again.'
                  FOR FYI_MESSAGE
               RESTART ON FIELD
            END
      END
