/**************************************************************************
*
*	probres.fs      
*
*	FORM:	probres
*	DESCRIPTION:	This scripts handles the problem resolution
*			form where HelpDesk personnel enter any number
*			of problem resolutions for each problem.  A
*			resolution is any small task done to take care
*			of the problem.  An example is "Called vendor,
*			spoke to Bob, was told to try reseating CPU."
*
*	AUTHOR:    BSY
*	DATE:      8/15/89
*	REVIEWER:  BSY
*
****************************************************************************/

FORM probres         

TARGET_TABLE probres

BEFORE FORM
   SET probres:AUTO_COMMIT TO TRUE
   IF PREV_FORM = 'problem' THEN
   BEGIN
      SET probres:pt_num: CLEAR_ADD_EXP TO problem:pr_num
      SET probres:pt_num: CLEAR_FIND_EXP to problem:pr_num
      SET probres:next_line: CLEAR_ADD_EXP to problem:pr_next_res
      IF problem:pr_next_res > 0 THEN
         SET probres:AUTO_FIND TO TRUE
      ELSE
      BEGIN
         SET probres:AUD_ON_ENTRY TO TRUE
         SET probres:OCCURRENCES to problem:pr_next_res       
      END
   END

BEFORE ADD
   IF PREV_FORM <> 'problem' THEN
   BEGIN
      DISPLAY 'You cannot add information here, you must go through Problem.'
         FOR FYI_MESSAGE WAIT;
      REJECT OPERATION;
   END
   IF PREV_FORM='problem' THEN
   BEGIN
      SET probres:pt_lnum TO probres:next_line
      SET probres:next_line TO probres:next_line + 1
   END

ON CLEAR TO ADD
   IF PREV_FORM = 'problem' THEN
   BEGIN
      IF problem:trob_tick <> UNDEFINED THEN
         SET probres:pt_trob_tick TO problem:trob_tick
      ELSE
         SET probres:pt_trob_tick TO 'N/A'
      SET probres:pt_date to current_date$()
      SET probres:pt_time to current_time$()
      SET probres:name TO user_name$()
      IF (strlen$(probres:name) > 8) THEN
         SET probres:pt_tech TO substr$(probres:name, 1, 8)
      ELSE
         SET probres:pt_tech TO probres:name
   END

AFTER ADD
   IF PREV_FORM='problem' THEN
   BEGIN
      SET problem:pr_next_res TO probres:next_line
      UPDATE problem SET #pr_next_res to probres:next_line
         WHERE #pr_num = problem:pr_num
      IF ((pt_assig <> UNDEFINED) AND (pt_assig <> '')) THEN
      BEGIN
         SET net_address TO UNDEFINED
         SET net_address TO SELECT #em_net_address FROM employee
            WHERE pt_assig=#em_init
         IF net_address <> UNDEFINED THEN
         BEGIN
            SET address TO 'mail -s Assigned_Problem ' + net_address
            SET header0 TO 'Assigned By:          ' + pt_tech
            SET header1 TO 'Problem Number:       ' + val_to_str$(pt_num)
            SET header2 TO 'Resolution Number:    ' + val_to_str$(pt_lnum)
            SET header3 TO 'Node ID:              ' + problem:pr_node
            SET header35 TO 'Trouble Ticket:       ' + probres:pt_trob_tick
            SET header4 TO 'Location:             ' + problem:pr_loc + ', ' +
               problem:pr_site
            SET header5 TO 'Contact:              ' + problem:pr_contact + ' '+
               problem:pr_phone
            SET header6 TO 'Assigned On:          ' +
               val_to_str$(probres:pt_date) + ' ' +
               val_to_str$(probres:pt_time)
            CREATE PIPELINE probres:$pipe1 address
            WRITE PIPELINE probres:$pipe1 header0
            WRITE PIPELINE probres:$pipe1 header1
            WRITE PIPELINE probres:$pipe1 header2
            WRITE PIPELINE probres:$pipe1 header3
            WRITE PIPELINE probres:$pipe1 header35
            WRITE PIPELINE probres:$pipe1 header4
            WRITE PIPELINE probres:$pipe1 header5
            WRITE PIPELINE probres:$pipe1 header6
            WRITE PIPELINE probres:$pipe1 '\nDescription of Problem:'
            WRITE PIPELINE probres:$pipe1 '-----------------------'
            WRITE PIPELINE probres:$pipe1 problem:pr_pc1
            WRITE PIPELINE probres:$pipe1 problem:pr_pc2
            WRITE PIPELINE probres:$pipe1 problem:pr_pc3
            WRITE PIPELINE probres:$pipe1 problem:pr_pc4
            WRITE PIPELINE probres:$pipe1 problem:pr_pc5
            WRITE PIPELINE probres:$pipe1 '\nDescription of Problem Assignment:'
            WRITE PIPELINE probres:$pipe1 '-----------------------------------'
            WRITE PIPELINE probres:$pipe1 pt_pc1
            WRITE PIPELINE probres:$pipe1 pt_pc2
            WRITE PIPELINE probres:$pipe1 pt_pc3
            WRITE PIPELINE probres:$pipe1 pt_pc4
            WRITE PIPELINE probres:$pipe1 pt_pc5
            CLOSE PIPELINE probres:$pipe1
         END
         ELSE
         BEGIN
            beep$(1)
            DISPLAY 'No address found for initials.  Assignment NOT sent.' FOR FYI_MESSAGE WAIT;
         END
      END
   END

ON PREVIOUS FORM
   IF PREV_FORM = 'problem' THEN
      UPDATE CURRENT RECORD

BEFORE UPDATE
   IF PREV_FORM <> 'problem' THEN
   BEGIN
      DISPLAY 'You cannot change information here, you must go through PROBLEM.'
         FOR FYI_MESSAGE WAIT;
      REJECT OPERATION;
   END

AFTER UPDATE
   IF PREV_FORM='problem' THEN
   BEGIN
      IF ((pt_assig <> UNDEFINED) AND (pt_assig <> '')) THEN
      BEGIN
         SET net_address TO UNDEFINED
         SET net_address TO SELECT #em_net_address FROM employee
            WHERE pt_assig=#em_init
         IF net_address <> UNDEFINED THEN
         BEGIN
            SET address TO 'mail -s Revised_Assigned_Problem ' + net_address
            SET header0 TO 'Assigned By:          ' + pt_tech
            SET header1 TO 'Problem Number:       ' + val_to_str$(pt_num)
            SET header2 TO 'Resolution Number:    ' + val_to_str$(pt_lnum)
            SET header3 TO 'Node ID:              ' + problem:pr_node
            SET header35 TO 'Trouble Ticket:       ' + probres:pt_trob_tick
            SET header4 TO 'Location:             ' + problem:pr_loc + ', ' +
               problem:pr_site
            SET header5 TO 'Contact:              ' + problem:pr_contact +
               ' ' + problem:pr_phone
            SET header6 TO 'Assigned On:          ' +
               val_to_str$(probres:pt_date) + ' ' +
               val_to_str$(probres:pt_time)
            CREATE PIPELINE probres:$pipe1 address
            WRITE PIPELINE probres:$pipe1 header0
            WRITE PIPELINE probres:$pipe1 header1
            WRITE PIPELINE probres:$pipe1 header2
            WRITE PIPELINE probres:$pipe1 header3
            WRITE PIPELINE probres:$pipe1 header35
            WRITE PIPELINE probres:$pipe1 header4
            WRITE PIPELINE probres:$pipe1 header5
            WRITE PIPELINE probres:$pipe1 header6
            WRITE PIPELINE probres:$pipe1 '\nDescription of Problem:'
            WRITE PIPELINE probres:$pipe1 '-----------------------'
            WRITE PIPELINE probres:$pipe1 problem:pr_pc1
            WRITE PIPELINE probres:$pipe1 problem:pr_pc2
            WRITE PIPELINE probres:$pipe1 problem:pr_pc3
            WRITE PIPELINE probres:$pipe1 problem:pr_pc4
            WRITE PIPELINE probres:$pipe1 problem:pr_pc5
            WRITE PIPELINE probres:$pipe1 '\nDescription of Problem Assignment:'
            WRITE PIPELINE probres:$pipe1 '-----------------------------------'
            WRITE PIPELINE probres:$pipe1 pt_pc1
            WRITE PIPELINE probres:$pipe1 pt_pc2
            WRITE PIPELINE probres:$pipe1 pt_pc3
            WRITE PIPELINE probres:$pipe1 pt_pc4
            WRITE PIPELINE probres:$pipe1 pt_pc5
            CLOSE PIPELINE probres:$pipe1
         END
         ELSE
         BEGIN
            beep$(1)
            DISPLAY 'No address found for these initials.  Assignment NOT sent.' FOR FYI_MESSAGE WAIT;
         END
      END
      UPDATE CURRENT RECORD
      NEXT ACTION IS PREVIOUS FORM
   END

BEFORE DELETE
   IF PREV_FORM <> 'problem' THEN
   BEGIN
      DISPLAY 'You cannot delete records without going through PROBLEM.'
         FOR FYI_MESSAGE WAIT;
      REJECT OPERATION;
   END

AFTER FIND
   IF PREV_FORM <> 'problem' THEN
   BEGIN
      SET pt_pc2 TO 'Problem Number:'
      SET pt_pc3 TO val_to_str$(pt_num);
   END
