/**************************************************************************
*
*	project.fs      
*
*	FORM:	project        
*	DESCRIPTION:	This script handles the project management
*			section of HDMS where projects are created and
*			then are split up into any number of tasks.
*
*	AUTHOR:    Unknown
*	DATE:      Unknown
*	REVIEWER:  Unknown
*
****************************************************************************/

FORM project

TARGET_TABLE proj

LOCAL group_code, oldcode

BEFORE FORM
   SET project:AUTO_COMMIT TO TRUE         /* locks the record */
   SET project:FIRST_FIELD TO 'pj_name'
   SET status to ''

ON CLEAR TO FIND
   SET pj_stat:STOP_FOR_INPUT TO TRUE

ON CLEAR TO ADD
   SET pj_stat TO 'O'
   SET status to 'pen'
   SET pj_north TO ' '
   SET pj_south TO ' '
   SET pj_us TO ' '
   SET project:$addmode TO 1

BEFORE ADD 
   SET pj_tasks TO 0 
   SET pj_next_task TO 1 

AFTER FORM RETURN
   IF project:$addmode=1 THEN
      UPDATE CURRENT RECORD

FIELD pj_name
   INIT FIELD
      ENABLE ZOOM to task
   ON FIELD
      INPUT
      IF project:$addmode=1 THEN
      BEGIN
         IF pj_name='U90' THEN
         BEGIN
            SET project:$next TO
            SELECT #nxt_num FROM nextnum WHERE #nxt_field_name='pj_u90_num'
            SET project:$value TO val_to_str$(project:$next)
            SWITCH strlen$(project:$value)
            BEGIN
               CASE 3: SET project:pj_name TO project:pj_name + '-' +
                          project:$value
               CASE 2: SET project:pj_name TO project:pj_name + '-0' +
                          project:$value
               DEFAULT: SET project:pj_name TO project:pj_name + '-00' +
                           project:$value
            END /* switch */
            UPDATE nextnum
               SET #nxt_num TO project:$next+1
               WHERE #nxt_field_name = 'pj_u90_num'
         END
         ELSE
            IF pj_name = 'M90' THEN
            BEGIN
               SET project:$next TO
                  SELECT #nxt_num FROM nextnum
                  WHERE #nxt_field_name = 'pj_m90_num'
               SET project:$value TO val_to_str$(project:$next)
               SWITCH strlen$(project:$value)
               BEGIN
                  CASE 3: SET project:pj_name TO project:pj_name + '-' +
                             project:$value
                  CASE 2: SET project:pj_name TO project:pj_name + '-0' +
                             project:$value
                  DEFAULT: SET project:pj_name TO project:pj_name + '-00' +
                              project:$value
               END /* switch */
               UPDATE nextnum
                  SET #nxt_num TO project:$next+1
                  WHERE #nxt_field_name = 'pj_m90_num'
            END
            ELSE
               IF pj_name = 'U91' THEN
               BEGIN
                  SET project:$next TO
                     SELECT #nxt_num FROM nextnum
                     WHERE #nxt_field_name = 'pj_u91_num'
                  SET project:$value TO val_to_str$(project:$next)
                  SWITCH strlen$(project:$value)
                  BEGIN
                     CASE 3: SET project:pj_name TO project:pj_name + '-' +
                                project:$value
                     CASE 2: SET project:pj_name TO project:pj_name + '-0' +
                                project:$value
                     DEFAULT: SET project:pj_name TO project:pj_name + '-00' +
                                 project:$value
                  END /* switch */
                  UPDATE nextnum
                     SET #nxt_num TO project:$next+1
                     WHERE #nxt_field_name = 'pj_u91_num'
               END
               ELSE
                  IF pj_name = 'M91' THEN
                  BEGIN
                     SET project:$next TO
                        SELECT #nxt_num FROM nextnum
                        WHERE #nxt_field_name = 'pj_m91_num'
                     SET project:$value TO val_to_str$(project:$next)
                     SWITCH strlen$(project:$value)
                     BEGIN
                        CASE 3: SET project:pj_name TO project:pj_name + '-' +
                                   project:$value
                        CASE 2: SET project:pj_name TO project:pj_name + '-0' +
                                   project:$value
                        DEFAULT: SET project:pj_name TO project:pj_name +'-00'+
                                    project:$value
                     END /* switch */
                     UPDATE nextnum
                        SET #nxt_num TO project:$next+1
                        WHERE #nxt_field_name = 'pj_m91_num'
                  END
               END

FIELD pj_stat
ON FIELD
   INPUT
   SWITCH pj_stat
   BEGIN
      CASE 'O': DISPLAY pj_stat
      CASE 'P': DISPLAY pj_stat
      CASE 'C': DISPLAY pj_stat
      CASE 'B': DISPLAY pj_stat
      CASE UNDEFINED: SET pj_stat to 'O'
                      DISPLAY pj_stat
      DEFAULT: DISPLAY 'Enter O, C, P, or B. Press RETURN.' FOR FYI_MESSAGE
               WAIT
               RESTART ON FIELD
   END
WHEN FIELD CHANGES
   SWITCH pj_stat
      BEGIN
	 CASE 'O': SET status to 'pen'
	 CASE 'C': SET status to 'losed'
	 CASE 'P': SET status to 'erpetual'
	 CASE 'B': SET status to 'udget'
      END

ON NEXT FORM
   IF ((pj_name=UNDEFINED) OR (pj_name='')) THEN
   BEGIN
      beep$(3);
      DISPLAY 'Must have a project before moving to next form. Hit return to Continue. ' FOR FYI_MESSAGE WAIT;
      REJECT OPERATION
   END
   ELSE
      UPDATE CURRENT RECORD

FIELD pj_site  
INIT FIELD
   ENABLE ZOOM to site RETURN KEY
BEFORE FIELD
   SET project:old_site TO project:pj_site
ON FIELD
   INPUT
   IF project:old_site <> project:pj_site THEN
   BEGIN
      SET project:old_site TO project:pj_site
      SET project:pj_site TO
         SELECT #si_id FROM site WHERE #si_id = project:pj_site
      IF status$() < 0 THEN
      BEGIN 
         DISPLAY project:old_site + ' was not found.  ZOOM to look at sites.' FOR FYI_MESSAGE WAIT
         RESTART ON FIELD
      END
   END

FIELD pj_north
   ON FIELD
      INPUT
      IF pj_north <> ' ' AND pj_north <> '' THEN
         SET pj_north TO 'X'
      ELSE
         SET pj_north TO ' '

FIELD pj_south
   ON FIELD
      INPUT
      IF pj_south <> ' ' AND pj_south <> '' THEN
	 SET pj_south TO 'X'
      ELSE
	 SET pj_south TO ' '

FIELD pj_us
   ON FIELD
      INPUT
      IF pj_us <> ' ' AND pj_us <> '' THEN
	 SET pj_us TO 'X'
      ELSE
	 SET pj_us TO ' '

FIELD pj_reqby
   BEFORE FIELD
      ENABLE ZOOM TO phone RETURN KEY
