/**************************************************************************
*
*	projectrep.fs   
*
*	FORM:		projectrep     
*	DESCRIPTION:	This script produces reports from the project
*			section of the database.
*
*	AUTHOR:	   DWM  (Modified by JWS)
*	DATE:	   Unknown
*	REVIEWER:  BSY
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define pcol(X) '&a',X,'C'

#define heading(pageno) \
   WRITE PIPELINE projectrep:$pipe1 get_message$(1), pcol(1), \
      current_date$(), '  ', current_time$(), pcol(60), get_message$(5), \
      pcol(110), get_message$(6), pageno,'\n', get_message$(1) \
   SET $LINENO TO ($LINENO+1)

#define addline \
   IF ($LINENO > 50) THEN \
   BEGIN \
      WRITE PIPELINE projectrep:$pipe1 get_message$(2); \
      SET $PAGE TO ($PAGE+1); \
      SET $LINENO TO 1; \
      heading($PAGE); \
   END \
   ELSE \
      SET $LINENO TO ($LINENO+1)

FORM projectrep      

TARGET_TABLE proj 

LOCAL sel, taskno, proj_num, resp, due, complete, started,
   desc1, desc2, desc3, desc4, desc5, hardware_cost, software_cost,
   project_total, is_there_a_pc, est_hours, act_hours, tot_est_hours,
   tot_act_hours;

BEFORE FORM
   SET sel TO UNDEFINED
   SET projectrep:$printer TO getenv$('SPOOLER')
   SET projectrep:AUTO_FIND TO TRUE
   open_message_file$('/usr/db/ACL4/aclenv/netops/message.file');

BEFORE FIND
   set_select(project,projectrep,pj_name)
   set_select(project,projectrep,pj_stat)
   set_select(project,projectrep,pj_site)
   set_select(project,projectrep,pj_start)
   set_select(project,projectrep,pj_due)
   set_select(project,projectrep,pj_compl)
   set_select(project,projectrep,pj_cc)
   set_select(project,projectrep,pj_reqby)
   set_select(project,projectrep,pj_desc)
   set_select(project,projectrep,pj_desc2)
   set_select(project,projectrep,pj_desc3)
   set_select(project,projectrep,pj_north)
   set_select(project,projectrep,pj_south)
   set_select(project,projectrep,pj_us)

ON FIND
   IF sel = 1 THEN
   BEGIN
      SET $project_total TO 0
      WRITE PIPELINE projectrep:$pipe1 pcol(1), projectrep:pj_name, pcol(20),
         get_message$(12), pcol(37), projectrep:pj_desc, pcol(109), 'Due: ',
         projectrep:pj_due
      SET $LINENO TO ($LINENO+1)
      WRITE PIPELINE projectrep:$pipe1 pcol(37), projectrep:pj_desc2,
         pcol(107), get_message$(13), projectrep:pj_start
      SET $LINENO TO ($LINENO+1)
      IF projectrep:pj_desc3 <> '' THEN
      BEGIN
         WRITE PIPELINE projectrep:$pipe1 pcol(37), projectrep:pj_desc3
         SET $LINENO TO ($LINENO+1)
      END
      WRITE PIPELINE projectrep:$pipe1 pcol(20), get_message$(7),
         projectrep:pj_site, pcol(42), 'Request by: ', pj_reqby
      addline;
      SET tot_est_hours TO 0
      SET tot_act_hours TO 0
      SET taskno TO UNDEFINED
      SET taskno, proj_num, resp, due, complete, started, desc1, desc2,
         desc3, desc4, desc5, site, cc, taskamou, est_hours, act_hours TO
         SELECT #tk_taskno, #tk_proj, #tk_resp, #tk_due, #tk_complete,
            #tk_start, #tk_desc1, #tk_desc2, #tk_desc3, #tk_desc4, #tk_desc5,
            #tk_site, #tk_cc, #tk_amou, #tk_eshrs, #tk_achrs
         FROM task
         WHERE projectrep:pj_name = #tk_proj
         ORDER BY #tk_taskno ASCENDING
      EXECUTING BEGIN
         SET tot_est_hours TO (tot_est_hours + est_hours)
         SET tot_act_hours TO (tot_act_hours + act_hours)
         SET $is_there_a_pc TO FALSE
         WRITE PIPELINE projectrep:$pipe1 ''
         SET $LINENO TO ($LINENO+1)
         WRITE PIPELINE projectrep:$pipe1 pcol(20), taskno, pcol(26), 'Resp: ',
            resp, pcol(40), 'Due: ', due, pcol(57), get_message$(13), started,
            pcol(76), 'Complete: ', complete, pcol(108), get_message$(7), site
         addline;
         WRITE PIPELINE projectrep:$pipe1 pcol(26), get_message$(12), pcol(110),
            'CC: ', cc
         addline;
         IF desc1 <> '' THEN
         BEGIN
            WRITE PIPELINE projectrep:$pipe1 pcol(30), desc1
            SET $LINENO TO ($LINENO+1)
         END
         IF desc2 <> '' THEN
         BEGIN
            WRITE PIPELINE projectrep:$pipe1 pcol(30), desc2
            SET $LINENO TO ($LINENO+1)
         END
         IF desc3 <> '' THEN
         BEGIN
            WRITE PIPELINE projectrep:$pipe1 pcol(30), desc3
            SET $LINENO TO ($LINENO+1)
         END
         IF desc4 <> '' THEN
         BEGIN
            WRITE PIPELINE projectrep:$pipe1 pcol(30), desc4
            SET $LINENO TO ($LINENO+1)
         END
         IF desc5 <> '' THEN
         BEGIN
            WRITE PIPELINE projectrep:$pipe1 pcol(30), desc5
            SET $LINENO TO ($LINENO+1)
         END
         SET ptotal TO UNDEFINED
         SET task_node,serial,pri_user,locat,model TO
            SELECT #no_id,#no_ser,#no_pri_user,#no_site,#no_model
            FROM node
            WHERE #no_task = taskno AND projectrep:pj_name = #no_prnum
            ORDER BY #no_id ASCENDING
         EXECUTING BEGIN
            SET is_there_a_pc TO TRUE
            WRITE PIPELINE projectrep:$pipe1 ''
            SET $LINENO TO ($LINENO+1)
            WRITE PIPELINE projectrep:$pipe1 pcol(26), get_message$(3),'Node:',
               get_message$(4), pcol(35),task_node,pcol(53),get_message$(3),'User:',
               get_message$(4), ' ',pri_user
            addline;
            WRITE PIPELINE projectrep:$pipe1 pcol(26),get_message$(3),'Model:',
               get_message$(4), pcol(35),model,pcol(53),get_message$(3),
               get_message$(7), get_message$(4),' ',locat
            addline;
            WRITE PIPELINE projectrep:$pipe1 pcol(26), get_message$(3),
               'Serial#:', get_message$(4),' ',serial
            addline;
            WRITE PIPELINE projectrep:$pipe1 '';
            SET $LINENO TO ($LINENO+1)
            /* PC Hard Stuff */
            SET ven TO space
            SET mod TO space
            SET sn TO space
            SET slot TO space
            SET amt TO 0
            SET $hardware_cost TO 0
            WRITE PIPELINE projectrep:$pipe1 pcol(26),get_message$(3),
               'Hardware Items', pcol(70),'Serial Number',pcol(92),'Slot',
               pcol(106),'Price', get_message$(4)
            addline;
            SET ven,mod,sn,slot,amt TO
               SELECT #ph_ven, #ph_mod, #ph_sn, #ph_slot, #ph_amount
               FROM pchard WHERE task_node = #ph_node
            EXECUTING BEGIN
               SET $hardware_cost TO ($hardware_cost + amt)
               WRITE PIPELINE projectrep:$pipe1 pcol(26), ven, ' ', mod,
                  pcol(70), sn, pcol(92), slot, pcol(106), '$', amt
               addline;
            END
            WRITE PIPELINE projectrep:$pipe1 pcol(106), '======'
            SET $LINENO TO ($LINENO+1)
            WRITE PIPELINE projectrep:$pipe1 pcol(95), get_message$(11),
               $hardware_cost
            addline;
            WRITE PIPELINE projectrep:$pipe1 ''
            addline;
            /* PC Software Stuff */
            SET $software_cost TO 0
            WRITE PIPELINE projectrep:$pipe1 pcol(26),get_message$(3),
               'Software Items', pcol(50),'Vendor',pcol(65),'PO',pcol(75),
               'Date',pcol(85),'SN', pcol(106),'Price',get_message$(4)
            addline;
            SET soft,ver,softsn,vend,po,softdate,amt TO
               SELECT #ps_soft,#ps_ver,#ps_sn,#ps_vend,#ps_po,#ps_date,
                  #ps_amount
               FROM pcsoft WHERE #ps_node = task_node
            EXECUTING BEGIN
               SET $software_cost TO ($software_cost + amt)
               WRITE PIPELINE projectrep:$pipe1 pcol(26), soft, ' ', ver,
                  pcol(50), vend, pcol(65), po, pcol(75), softdate, pcol(85),
                  softsn, pcol(106), '$', amt
               addline;
            END
            WRITE PIPELINE projectrep:$pipe1 pcol(106), '====='
            SET $LINENO TO ($LINENO+1)
            WRITE PIPELINE projectrep:$pipe1 pcol(95), get_message$(11),
               $software_cost
            SET $LINENO TO ($LINENO+1)
            WRITE PIPELINE projectrep:$pipe1 pcol(26), get_message$(10),
               ($hardware_cost + $software_cost)
            addline;
            SET $project_total TO ($project_total+$hardware_cost+$software_cost)
            WRITE PIPELINE projectrep:$pipe1 '';
            addline;
         END
         WRITE PIPELINE projectrep:$pipe1 ''
         WRITE PIPELINE projectrep:$pipe1 pcol(26), 'ESTIMATED HOURS: ',
            est_hours
         addline;
         WRITE PIPELINE projectrep:$pipe1 pcol(26), 'ACTUAL HOURS: ', act_hours
         addline;
         IF ($is_there_a_pc = FALSE) THEN
         BEGIN
            WRITE PIPELINE projectrep:$pipe1 pcol(26),get_message$(10),
               taskamou
            addline;
            SET $project_total TO ($project_total+taskamou)
         END
      END
      WRITE PIPELINE projectrep:$pipe1 ''
      WRITE PIPELINE projectrep:$pipe1 'TOTAL ESTIMATED HOURS: ',
         tot_est_hours
      addline;
      WRITE PIPELINE projectrep:$pipe1 'TOTAL ACTUAL HOURS: ',
         tot_act_hours
      addline;
      WRITE PIPELINE projectrep:$pipe1 get_message$(9), $project_total
      SET $LINENO TO ($LINENO+1)
      WRITE PIPELINE projectrep:$pipe1 ''
      WRITE PIPELINE projectrep:$pipe1 pcol(1), '*****************************'
      SET $LINENO TO ($LINENO+1)
      WRITE PIPELINE projectrep:$pipe1 ''
      SET $LINENO TO ($LINENO+1)
   END

AFTER FIND 
    IF sel = 1 THEN
    BEGIN
       CLOSE PIPELINE projectrep:$pipe1
       DISPLAY 'Done printing.  Press RETURN.' FOR FYI_MESSAGE WAIT;
    END

ON PREVIOUS FORM
   close_message_file$()

FIELD sel
   ON FIELD
      SET sel TO UNDEFINED
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1 :
               BEGIN
                  DISPLAY 'Printing.' FOR FYI_MESSAGE;
                  SET $PAGE TO 1
                  SET $LINENO TO 1
                  CREATE PIPELINE projectrep:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
                     projectrep:$printer
                  heading(1);
                  WRITE PIPELINE projectrep:$pipe1 pcol(1), get_message$(3), 'Project',
                     pcol(20), 'Task', pcol(125), get_message$(4);
                  addline;
                  NEXT ACTION IS FIND
               END
         DEFAULT:
                BEGIN
                   DISPLAY 'Enter either 1 or PREVIOUS-FORM.  Press RETURN.'
                      FOR FYI_MESSAGE WAIT;
                   RESTART ON FIELD
                END
      END
