/**************************************************************************
*
*	sendprob.fs     
*
*	FORM:	sendprob       
*	DESCRIPTION:	This script handles the part of the problem
*			management section of HDMS that allows users
*			to forward problems to one another.
*
*	AUTHOR:    BT  (Modified by JWS)
*	DATE:      Summer 1990
*	REVIEWER:  BT
*
****************************************************************************/

FORM sendprob        

LOCAL sp_probnum, sp_res, sp_sendto, sp_comm1, sp_comm2, sp_comm3,
      sp_comm4, comment1, comment2, comment3, comment4

BEFORE FORM
   SET sendprob: AUTO_COMMIT TO TRUE
   SET sp_probnum TO problem: pr_num
   SET sp_res TO problem: pr_next_res
   SET $sent TO 0

BEFORE UPDATE
   NEXT ACTION IS NEXT FORM
   REJECT OPERATION

ON PREVIOUS FORM
   IF $sent = 0 THEN
   BEGIN
      beep$(1)
      IF NOT (yesno$('You did NOT send this message to any user.  ENTER to exit, [no] to cont. ' ,1)) THEN
         REJECT OPERATION
   END

ON NEXT FORM
   DISPLAY 'Forwarding problem to ' + sp_sendto + ', please wait...' FOR FYI_MESSAGE
   SET net_address TO UNDEFINED
   IF sp_sendto='OUT' THEN
   BEGIN
      SET net_address TO 'Bruce=Yearsley%NetOps%DataCenter@dewey.delmarva.COM '+
         'Richard=Derby%CompOps%DataCenter@dewey.delmarva.COM ' +
         'Duane=Taylor%IS%DataCenter@dewey.delmarva.COM '
   END
   ELSE
      SET net_address TO
         SELECT #em_net_address FROM employee WHERE sp_sendto = #em_init
   IF net_address <> UNDEFINED THEN
   BEGIN
      SET address TO 'mail -s Forwarded_Problem ' + net_address
      SET header1 TO 'Problem number:    ' + val_to_str$(sp_probnum)
      SET header2 TO '# of Resolutions:  ' + val_to_str$(sp_res)
      SET header3 TO 'Node Id:           ' + problem: pr_node
      SET header4 TO 'Location:          ' + problem:pr_loc+', '+problem:pr_site
      SET header5 TO 'Contact:           ' + problem: pr_contact +
					     ' (' + problem: pr_phone + ')'
      SET header6 TO 'Opened On:         ' + val_to_str$(problem: pr_open_date)+
				       ' ' + val_to_str$(problem: pr_open_time)
      CREATE PIPELINE sendprob:$pipe1 address
      WRITE PIPELINE sendprob:$pipe1 sp_comm1
      WRITE PIPELINE sendprob:$pipe1 sp_comm2
      WRITE PIPELINE sendprob:$pipe1 sp_comm3
      WRITE PIPELINE sendprob:$pipe1 sp_comm4
      WRITE PIPELINE sendprob:$pipe1 '\n--\n'
      WRITE PIPELINE sendprob:$pipe1 header1
      WRITE PIPELINE sendprob:$pipe1 header2
      WRITE PIPELINE sendprob:$pipe1 header3
      WRITE PIPELINE sendprob:$pipe1 header4
      WRITE PIPELINE sendprob:$pipe1 header5
      WRITE PIPELINE sendprob:$pipe1 header6
      WRITE PIPELINE sendprob:$pipe1 '\nDescription of Problem:'
      WRITE PIPELINE sendprob:$pipe1 '-----------------------'
      WRITE PIPELINE sendprob:$pipe1 problem: pr_pc1
      WRITE PIPELINE sendprob:$pipe1 problem: pr_pc2
      WRITE PIPELINE sendprob:$pipe1 problem: pr_pc3
      WRITE PIPELINE sendprob:$pipe1 problem: pr_pc4
      WRITE PIPELINE sendprob:$pipe1 '\nProblem History:'
      WRITE PIPELINE sendprob:$pipe1 '----------------'
      SET sp_ticket, sp_tech, sp_date, sp_time, sp_pc1, sp_pc2,sp_pc3,sp_pc4 TO
         SELECT #pt_trob_tick, #pt_tech, #pt_date, #pt_time, #pt_pc1,
            #pt_pc2, #pt_pc3, #pt_pc4
         FROM probres WHERE #pt_num = problem: pr_num
         ORDER BY #pt_date ASCENDING
      EXECUTING BEGIN
         SET sp_ticket TO pad_str_right$(sp_ticket, ' ', 20)
         SET sp_tech TO pad_str_right$(sp_tech, ' ', 20)
         SET line1 TO 'Ticket: ' + sp_ticket + ' Tech: ' + sp_tech + ' ' +
            val_to_str$(sp_date)+' '+val_to_str$(sp_time)
         WRITE PIPELINE sendprob:$pipe1 line1
         WRITE PIPELINE sendprob:$pipe1 '    ' + sendprob: sp_pc1
         WRITE PIPELINE sendprob:$pipe1 '    ' + sendprob: sp_pc2
         WRITE PIPELINE sendprob:$pipe1 '    ' + sendprob: sp_pc3
         WRITE PIPELINE sendprob:$pipe1 '    ' + sendprob: sp_pc4
      END
      INSERT INTO sendprob #sp_prnum, #sp_from, #sp_to, #sp_date,
         #sp_time: problem:pr_num, user_name$(), sp_sendto, current_date$(),
         current_time$();
      CLOSE PIPELINE sendprob:$pipe1
      SET $sent TO 1
   END
   ELSE
   BEGIN
      beep$(1)
      DISPLAY 'Cannot find the e-mail address for the person.  RETURN to continue.'
         FOR FYI_MESSAGE WAIT;
   END
   IF $sent=1 THEN
   BEGIN
      DISPLAY 'Message sent to user(s).  RETURN to continue.'
         FOR FYI_MESSAGE WAIT;
   END
   REJECT OPERATION

FIELD sp_sendto
   BEFORE FIELD
      ENABLE ZOOM TO employee RETURN KEY
