/**************************************************************************
*
*	siterep.fs      
*
*	FORM:	siterep        
*	DESCRIPTION:	This script generates reports from the Site
*			Information database in HDMS.
*
*	AUTHOR:    DWM
*	DATE:      01/16/90
*	REVIEWER:  DWM
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM siterep         

TARGET_TABLE site

LOCAL sel,printer

BEFORE FORM
   SET siterep:sel:STOP_FOR_INPUT TO TRUE
   SET siterep:FIRST_FIELD TO 'sel'
   SET siterep:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer to getenv$('SPOOLER')

BEFORE FIND
   set_select(site,siterep,si_id)
   set_select(site,siterep,si_address1)
   set_select(site,siterep,si_city_state)
   set_select(site,siterep,si_comment1)
   set_select(site,siterep,si_comment2)
   set_select(site,siterep,si_comment3)
   set_select(site,siterep,si_comment4)
   IF sel = 2 THEN
   BEGIN
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
      CREATE PIPELINE siterep:pipe1 'RPT /usr/db/ACL4/rptdir/site.r -', printer
   END

ON FIND
   IF sel = 2 THEN
   BEGIN
      WRITE PIPELINE siterep:pipe1 si_id,si_address1,si_city_state,
         si_comment1,si_comment2,si_comment3,si_comment4
   END

AFTER FIND
   IF sel = 2 THEN
   BEGIN
      CLOSE PIPELINE siterep:pipe1;
      DISPLAY 'Done printing selected records.  Press RETURN.' FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               CREATE PIPELINE siterep:pipe1 'RPT /usr/db/ACL4/rptdir/site.r -',
                  printer;
               WRITE PIPELINE siterep:pipe1 si_id,si_address1,si_city_state,
                  si_comment1,si_comment2,si_comment3,si_comment4
               CLOSE PIPELINE siterep:pipe1;
               DISPLAY 'Done printing single record.  Press RETURN.' FOR FYI_MESSAGE WAIT;
            END
         CASE 2:
            BEGIN
               DISPLAY 'Printing Report on selected records' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'EITHER 1 OR 2' FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
