/**************************************************************************
*
*	task.fs         
*
*	FORM:	task           
*	DESCRIPTION:	This script manages the Task Management form
*			that tracks projects by breaking them up into
*			smaller, more manageable units.
*
*	AUTHOR:	   DWM  (Modified by BT)
*	DATE:      2/15/90
*	REVIEWER:  DWM
*
****************************************************************************/

FORM task            

TARGET_TABLE task

LOCAL next_line, num_of_tasks, old_complete, group_code, old_code

BEFORE FORM
   SET task:AUTO_COMMIT TO TRUE
   SET task:FIRST_FIELD TO 'tk_proj'
   SET old_complete TO tk_complete
   IF PREV_FORM='project' THEN	/* if didn't get from main menu */
   BEGIN
      SET task:tk_proj:CLEAR_FIND_EXP TO project:pj_name
      SET task:tk_proj:CLEAR_ADD_EXP TO project:pj_name
      SET next_line:CLEAR_ADD_EXP TO project:pj_next_task 
      SET prev_line:CLEAR_ADD_EXP TO project:pj_next_task 
      IF  project:pj_next_task > 1 THEN
         SET task:AUTO_FIND TO TRUE
      ELSE
         SET task:AUD_ON_ENTRY TO TRUE		/* go into add mode */
   END

ON NEXT FORM
   UPDATE CURRENT RECORD
   
ON CLEAR TO ADD
   IF PREV_FORM <> 'project' THEN
   BEGIN
      beep$(1);
      DISPLAY 'You must add projects from the Project screen, ' +
	      'not here.  Press RETURN to continue.' FOR FYI_MESSAGE WAIT;
   END
   ELSE
   BEGIN
      SET task:tk_proj:STOP_FOR_INPUT TO FALSE
      SET task:tk_taskno TO next_line			/* inherit some */
      SET task:tk_due TO project:pj_due			/* fields from proj */
      SET task:tk_cc TO project:pj_cc
      SET task:tk_site TO project:pj_site
      SET task:tk_start TO project:pj_start
      SET task:tk_desc1 TO project:pj_desc
      SET task:tk_north TO project:pj_north
      SET task:tk_south TO project:pj_south
      SET task:tk_us TO project:pj_us
      SET task:tk_north TO ' '
      SET task:tk_south TO ' '
      SET task:tk_us TO ' '
   END

ON CLEAR TO FIND
   SET task: tk_taskno : STOP_FOR_INPUT TO TRUE

AFTER FIND
   SET task: tk_taskno : STOP_FOR_INPUT TO FALSE

BEFORE ADD
   SET next_line TO next_line+1

AFTER ADD
   SET task:tk_proj:STOP_FOR_INPUT TO TRUE
   SET num_of_tasks TO project:pj_tasks+1
   SET project:pj_tasks TO num_of_tasks  
   SET project:pj_next_task TO next_line 
   UPDATE proj
      SET #pj_next_task,#pj_tasks TO next_line, num_of_tasks
      WHERE #pj_name=project:pj_name
   IF ((old_complete <> tk_complete) AND (tk_complete <> UNDEFINED) AND
      (tk_complete <> str_to_date$(''))) THEN
      BEGIN
        SET net_address TO UNDEFINED
        SET net_address TO
           SELECT #em_net_address FROM employee WHERE task:tk_notify = #em_init
        IF (net_address <> UNDEFINED) THEN
        BEGIN
           SET address TO 'mail -s TASK_CLOSED ' + net_address 
           SET message0 TO '\nREPORT ON PROJECT: ' + tk_proj
           SET message1 TO 'Task ' + val_to_str$(tk_taskno) + ' of project ' +
              tk_proj + ' is completed.'
           CREATE PIPELINE task:pipe1 address
           WRITE PIPELINE task:pipe1 message0
           WRITE PIPELINE task:pipe1 message1
           CLOSE PIPELINE task:pipe1;
        END
        ELSE
        BEGIN
	   DISPLAY 'WARNING:  No one was notified of task completion. RETURN to continue.' FOR FYI_MESSAGE WAIT;
        END
        SET old_complete TO tk_complete
      END

AFTER UPDATE
   IF ((old_complete <> tk_complete) AND (tk_complete <> UNDEFINED) AND
      (tk_complete <> str_to_date$(''))) THEN
      BEGIN
        SET net_address TO UNDEFINED
        SET net_address TO
           SELECT #em_net_address FROM employee WHERE task:tk_notify = #em_init
        IF (net_address <> UNDEFINED) THEN
        BEGIN
           SET address TO 'mail -s TASK_CLOSED ' + net_address 
           SET message0 TO '\nREPORT ON PROJECT: ' + tk_proj
           SET message1 TO 'Task ' + val_to_str$(tk_taskno) + ' of project ' +
              tk_proj + ' is completed.'
           CREATE PIPELINE task:pipe1 address
           WRITE PIPELINE task:pipe1 message0
           WRITE PIPELINE task:pipe1 message1
           CLOSE PIPELINE task:pipe1;
        END
        ELSE
        BEGIN
	   DISPLAY 'WARNING:  No one was notified of task completion.  RETURN to continue.' FOR FYI_MESSAGE WAIT;
        END
        SET old_complete TO tk_complete
      END

FIELD tk_taskno
   WHEN FIELD CHANGES 
      SET old_complete TO tk_complete

FIELD tk_site
   BEFORE FIELD
      ENABLE ZOOM TO site RETURN KEY;
      SET task:old_site TO task:tk_site
   ON FIELD
      INPUT
      IF task:old_site <> task:tk_site THEN
      BEGIN
         SET task:old_site TO task:tk_site
         SET task:tk_site TO
            SELECT #si_id FROM site WHERE #si_id = task:tk_site
         IF status$() < 0 THEN
         BEGIN 
            DISPLAY task:old_site + ' was not found. Press ZOOM to see '+
               'list of sites.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD tk_notify
   BEFORE FIELD
      ENABLE ZOOM TO employee RETURN KEY;
      SET task:old_notify TO task:tk_notify
   ON FIELD
      INPUT
      IF task:old_notify <> task:tk_notify THEN
      BEGIN
         SET task:old_notify TO task:tk_notify
         SET task:tk_notify TO
            SELECT #em_initial FROM employee WHERE #em_initial = task:tk_notify
         IF status$() < 0 THEN
         BEGIN 
            DISPLAY task:old_notify + ' was not found. Press ZOOM to see ' +
               'list of employees.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD tk_resp
   BEFORE FIELD
      ENABLE ZOOM TO employee RETURN KEY;
      SET task:old_resp TO task:tk_resp
   ON FIELD
      INPUT
      IF task:old_resp <> task:tk_resp THEN
      BEGIN
         SET task:old_resp TO task:tk_resp
         SET task:tk_resp TO
            SELECT #em_initial FROM employee WHERE #em_initial = task:tk_resp
         IF status$() < 0 THEN
         BEGIN 
            DISPLAY task:old_resp + ' was not found. Press ZOOM to see ' +
               'list of employees.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD tk_complete
   BEFORE FIELD 
      SET old_complete TO tk_complete
   AFTER DELETE
      IF project:pj_tasks > 1 THEN
      BEGIN
         SET prev_line TO project:pj_tasks
         SET prev_line TO prev_line-1
         SET project:pj_tasks TO prev_line
         UPDATE proj SET #pj_tasks TO prev_line WHERE #pj_name=project:pj_name
      END

FIELD tk_north
   ON FIELD
      INPUT
      IF tk_north <> ' ' AND tk_north <> '' THEN
	 SET tk_north TO 'X'
      ELSE
	 SET tk_north TO ' '

FIELD tk_south
   ON FIELD
      INPUT
      IF tk_south <> ' ' AND tk_south <> '' THEN
	 SET tk_south TO 'X'
      ELSE
	 SET tk_south TO ' '

FIELD tk_us
   ON FIELD
      INPUT
      IF tk_us <> ' ' AND tk_us <> '' THEN
	 SET tk_us TO 'X'
      ELSE
	 SET tk_us TO ' '

FIELD tk_amou
   ON FIELD
      INPUT

FIELD tk_budgt
   ON FIELD
      INPUT
      IF ((tk_budgt = UNDEFINED) OR (tk_budgt = '')) THEN
         SET tk_budgt TO 'Y'
      IF ((tk_budgt <> 'Y') AND (tk_budgt <> 'N')) THEN
      BEGIN
         beep$(1)
         DISPLAY 'Please enter only Y or N.  Press ENTER to try again.'
            FOR FYI_MESSAGE WAIT;
         RESTART ON FIELD
      END

FIELD tk_or
   BEFORE FIELD
      IF ((task:tk_or <> 'Y') AND (task:tk_or <> 'N')) THEN
         SET task:tk_or TO UNDEFINED
   ON FIELD
      INPUT
      IF ((task:tk_or <> '') AND (task:tk_or <> UNDEFINED) AND
         (task:tk_or <> 'Y') AND (task:tk_or <> 'N')) THEN
      BEGIN
         beep$(1)
         DISPLAY 'Enter Y or N only.  Press RETURN to try again.' FOR FYI_MESSAGE WAIT;
         SET task:tk_or TO 'N'
         RESTART ON FIELD
      END
