/**************************************************************************
*
*	taskrep.fs      
*
*	FORM:		taskrep        
*	DESCRIPTION:	This script generates reports from the Task
*			Information database in HDMS.  There are two
*			types of reports (1) regular [sorted by
*			project number, site, etc.] and (2) time to
*			complete.
*
*	AUTHOR:	   BT  (Modified by JWS)
*	DATE:      Unknown
*	REVIEWER:  BT
*
****************************************************************************/

#define ESC char_code_to_str$(27)

#define MAXLINES 80

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define pcol(X) '&a',X,'C'

#define FormFeed char_code_to_str$(12)

#define mtstring ''

#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'

#define heading(pageno) \
   WRITE PIPELINE taskrep:$pipe1 regset ,pcol(1), \
   current_date$(),'   ',\
   current_time$(), \
   '                                          Task Report                                    Page: ', pageno,'\n', \
   regset;

#define setund ESC,'&dD'

#define unsetund ESC,'&d@'

#define addline \
   IF $LINENO > 55 THEN \
   BEGIN \
      WRITE PIPELINE taskrep:$pipe1 FormFeed ; \
      SET PAGE TO PAGE + 1 ;\
      heading(PAGE);  \
      SET $LINENO TO 0; \
   END \
   ELSE \
      SET $LINENO TO $LINENO + 1

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM taskrep      

TARGET_TABLE task 

LOCAL sel, printer

BEFORE FORM
   SET sel TO UNDEFINED
   SET taskrep:AUTO_FIND TO TRUE
   SET $printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(task, taskrep, tk_proj)
   set_select(task, taskrep, tk_taskno)
   set_select(task, taskrep, tk_desc1)
   set_select(task, taskrep, tk_desc2)
   set_select(task, taskrep, tk_desc3)
   set_select(task, taskrep, tk_desc4)
   set_select(task, taskrep, tk_desc5)
   set_select(task, taskrep, tk_resp)
   set_select(task, taskrep, tk_notify)
   set_select(task, taskrep, tk_due)
   set_select(task, taskrep, tk_complete)
   set_select(task, taskrep, tk_start)
   set_select(task, taskrep, tk_bsr)
   set_select(task, taskrep, tk_site)
   set_select(task, taskrep, tk_cc)
   set_select(task, taskrep, tk_north)
   set_select(task, taskrep, tk_south)
   set_select(task, taskrep, tk_us)
   set_select(task, taskrep, tk_or)
   set_select(task, taskrep, tk_amou)
   set_select(task, taskrep, tk_achrs)
   set_select(task, taskrep, tk_budgt)
   set_select(task, taskrep, tk_eshrs)
   set_select(task, taskrep, tk_achrs)
   IF sel = 1 THEN
   BEGIN
      SET $PAGE TO 1
      SET LINENO TO 0
      CREATE PIPELINE taskrep:pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         $printer;
      heading(1)
      WRITE PIPELINE taskrep:pipe1 pcol(1), setund, 'Project', pcol(20),
         'Task', pcol(125), unsetund
   END
   IF sel = 2 THEN
   BEGIN
      CREATE PIPELINE taskrep:pipe1 'RPT /usr/db/ACL4/rptdir/tasktime.r -',
         $printer;
   END
   IF sel = 3 THEN
   BEGIN
      CREATE PIPELINE taskrep:pipe1 'RPT /usr/db/ACL4/rptdir/taskbudg.r -',
         $printer;
   END
   IF sel = 4 THEN
   BEGIN
      CREATE PIPELINE taskrep:pipe1 'RPT /usr/db/ACL4/rptdir/taskbudg2.r -',
         $printer;
   END

ON FIND
   IF sel = 1 THEN
   BEGIN
	IF $LINENO > 48 THEN
	BEGIN
	   SET PAGE TO PAGE+1
	   WRITE PIPELINE taskrep: $pipe1 FormFeed
	   heading($PAGE)
	   SET $LINENO TO 0
	END
	SET $pj__name, $pj__desc, $pj__desc2, $pj__desc3, $pj__due,
           $pj__start, $pj__site, $pj__reqby TO
           SELECT #pj_name, #pj_desc, #pj_desc2, #pj_desc3, #pj_due,
              #pj_start, #pj_site, #pj_reqby FROM proj
           WHERE taskrep:tk_proj = #pj_name
	DISPLAY 'Project: ' + $pj__name + ' Task: ' +
           val_to_str$(tk_taskno) FOR FYI_MESSAGE;
	WRITE PIPELINE taskrep:$pipe1 pcol(1), $pj__name, pcol(20),
           'Description: ', pcol(37), $pj__desc, pcol(107),'  Due: ', $pj__due
	addline
	WRITE PIPELINE taskrep:$pipe1 pcol(37), $pj__desc2, pcol(107),
           'Start: ', $pj__start
	addline
	IF $pj__desc3<>mtstring THEN
	BEGIN
	   WRITE PIPELINE taskrep:$pipe1 pcol(37), $pj__desc3
	   addline
	END
	WRITE PIPELINE taskrep:$pipe1 ' '
	addline
	WRITE PIPELINE taskrep:$pipe1 pcol(20), 'Site: ', $pj__site, pcol(42),
           'Request by: ', $pj__reqby
	addline
	WRITE PIPELINE taskrep:$pipe1 '  '
	addline
	DISPLAY 'Project: ' + $pj__name + ' Task: ' + val_to_str$(tk_taskno)
           FOR FYI_MESSAGE;
	WRITE PIPELINE taskrep:$pipe1 pcol(20), tk_taskno, pcol(26), 'Resp: ',
           tk_resp, pcol(40), 'Due: ', tk_due, pcol(57), 'Start: ', tk_start,
           pcol(76), 'Complete: ', tk_complete, pcol(107), ' Site: ', tk_site
	addline
        WRITE PIPELINE taskrep:$pipe1 pcol(26), 'Description:', pcol(107),
           '   CC: ', tk_cc
	addline
	IF tk_desc1 <> mtstring THEN
	BEGIN
           WRITE PIPELINE taskrep:$pipe1 pcol(26), tk_desc1
	   addline
	END
	IF tk_desc2 <> mtstring THEN
	BEGIN
           WRITE PIPELINE taskrep:$pipe1 pcol(26), tk_desc2
	   addline
	END
	IF tk_desc3 <> mtstring THEN
	BEGIN
           WRITE PIPELINE taskrep:$pipe1 pcol(26), tk_desc3
	   addline
	END
	IF tk_desc4 <> mtstring THEN
	BEGIN
           WRITE PIPELINE taskrep:$pipe1 pcol(26), tk_desc4
	   addline
	END
	IF tk_desc5 <> mtstring THEN
	BEGIN
           WRITE PIPELINE taskrep:$pipe1 pcol(26), tk_desc5
	   addline
	END
        WRITE PIPELINE taskrep:$pipe1 ' '
	addline
	SET task_node,serial,pri_user,locat,model TO 
	   SELECT #no_id,#no_ser,#no_pri_user,#no_site,#no_model FROM node
	   WHERE #no_task = tk_taskno AND $pj__name = #no_prnum
	   ORDER BY #no_id ASCENDING
        EXECUTING BEGIN
	    WRITE PIPELINE taskrep:$pipe1 pcol(26), setund,'Node:', unsetund,
            '    ', task_node, pcol(53),setund,'User:', unsetund, ' ', pri_user
	    addline
            WRITE PIPELINE taskrep:$pipe1 pcol(26),setund,'Model: ', unsetund,
               '  ', model, pcol(53),setund,'Site:', unsetund, ' ', locat
	    addline
	    WRITE PIPELINE taskrep:$pipe1 pcol(26), setund, 'Serial#:',
               unsetund, ' ', serial
	    addline
            WRITE PIPELINE taskrep:$pipe1 ' ';
	    addline
	 /*  PC HARD STUFF  */
            WRITE PIPELINE taskrep:$pipe1 pcol(26),setund,'Hardware Items',
               pcol(70),'Serial Number',pcol(92),'Slot',pcol(106),'Price',
               unsetund
	    addline
            SET ven TO ' '
	    SET mod TO ' '
	    SET sn TO ' '
	    SET slot TO ' '
            SET amt TO 0
            SET ven,mod,sn,slot,amt TO
               SELECT #ph_ven,#ph_mod,#ph_sn,#ph_slot,#ph_amoun
               FROM pchard WHERE task_node = #ph_node
	    EXECUTING BEGIN
	       WRITE PIPELINE taskrep:$pipe1 pcol(26),ven, ' ',mod,pcol(70),
                  sn,pcol(92), slot, pcol(106), '$', amt
               addline
            END
	    WRITE PIPELINE taskrep:$pipe1 ' '
            addline
	    /*   PC Soft Stuff   */
            WRITE PIPELINE taskrep:$pipe1 pcol(26),setund,'Software Items',
               pcol(50),'Vendor',pcol(65),'PO',pcol(75),'Date',pcol(85),'SN',
               pcol(106),'Price',unsetund
	    SET soft,ver,softsn,vend,po,softdate,amt TO
               SELECT #ps_soft,#ps_ver,#ps_sn,#ps_vend,#ps_po,#ps_date,
                  #ps_amoun
               FROM pcsoft WHERE #ps_node = task_node
	    EXECUTING BEGIN
	       WRITE PIPELINE taskrep:$pipe1 pcol(26),soft, ' ', ver,
                  pcol(50), vend,pcol(65), po, pcol(75), softdate, pcol(85),
                  softsn, pcol(106), '$', amt
   	       addline
	    END
            WRITE PIPELINE taskrep:$pipe1 ' ' ;
	    addline
         END
         WRITE PIPELINE taskrep:$pipe1 '\n'
         addline
         WRITE PIPELINE taskrep:$pipe1 pcol(1), '-------------------------------------------------------------------------------------------------------------------------'
         addline
      END
      IF sel = 2 THEN
      BEGIN
      DISPLAY 'Project: ' + tk_proj + '  Task: ' + val_to_str$(tk_taskno)
         FOR FYI_MESSAGE
      WRITE PIPELINE taskrep:pipe1 tk_proj, tk_taskno, tk_start, tk_complete,
         tk_due, tk_desc1
   END
   IF ((sel = 3) or (sel = 4)) THEN
   BEGIN
      WRITE PIPELINE taskrep:pipe1 tk_cc, tk_proj, tk_taskno, tk_amou, tk_achrs, tk_desc1
   END

AFTER FIND
   IF sel = 1 THEN
   BEGIN
      CLOSE PIPELINE taskrep:pipe1

      DISPLAY 'Done printing all records. Hit ENTER to continue.'
      FOR FYI_MESSAGE WAIT;
   END
   IF ((sel = 2) OR (sel = 3) OR (sel = 4)) THEN
   BEGIN
      CLOSE PIPELINE taskrep:pipe1;  
      DISPLAY 'Done printing all records. Hit ENTER to continue.' FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   ON FIELD
		SET sel TO UNDEFINED
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               DISPLAY 'Printing Report on selected records.  Please wait...'
                  FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE 2:
            BEGIN
               DISPLAY 'Print Report on Problem Opened Time.  Please wait...'
                  FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE 3:
            BEGIN
               DISPLAY 'Printing Report on selected records.  Please wait...'
                  FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE 4:
            BEGIN
               DISPLAY 'Printing Report on selected records.  Please wait...'
                  FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'Invalid response.  Hit RETURN to try again.'
                  FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
