/**************************************************************************
*
*	tcpipudt.fs     
*
*	FORM:	tcpipudt       
*	DESCRIPTION:
*
*	AUTHOR:    JWS
*	DATE:      8/1/91
*	REVIEWER:  JWS
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

#define pcol(X) '&a',X,'C'

#define setund '&dD'

#define unsetund '&d@'

#define FormFeed char_code_to_str$(12)

#define regset '(8U(s0p16.67h8.5v0s0b0T&l0o'

#define heading(pageno) \
   WRITE PIPELINE tcpipudt:pipe1 '(8U(s1p12.0v0s0b5T&l0o',pcol(1), \
   current_date$(),'   ',\
   current_time$(), \
   '                                 Assigned IP Addresses        ', \
   '                                          ', pageno,'\n\n', \
   pcol(24), setund, 'Node ID', pcol(60), 'IP Address', \
   pcol(96), 'Primary User', pcol(126), 'Phone Number', unsetund, \
   regset

#define addline \
   IF $LINENO > 60 THEN \
   BEGIN \
      WRITE PIPELINE tcpipudt:pipe1 FormFeed; \
      SET $PAGE TO ($PAGE+1) \
      heading(PAGE)  \
      SET $LINENO TO 0 \
   END \
   ELSE \
      SET $LINENO TO ($LINENO+1)

/***********************************************************************/

FORM tcpipudt

TARGET_TABLE lancard

LOCAL printer, user, number

BEFORE FORM
   SET tcpipudt:$sel TO UNDEFINED
   SET tcpipudt:$sel:STOP_FOR_INPUT TO TRUE
   SET tcpipudt:AUTO_FIND TO TRUE
   SET tcpipudt:FIRST_FIELD TO 'sel'
   SET tcpipudt:$printer TO getenv$('SPOOLER')

BEFORE FIND
   IF PREV_FORM = 'lancard' THEN
   BEGIN
      set_select(lancard,tcpipudt,ln_8023)
      set_select(lancard,tcpipudt,ln_tcpip)
      set_select(lancard,tcpipudt,ln_sbnet)
      set_select(lancard,tcpipudt,ln_node)
      set_select(lancard,tcpipudt,ln_mmac)
   END
   IF sel = '2' THEN
   BEGIN
      DISPLAY 'Creating PIPELINE.' FOR FYI_MESSAGE;
      CREATE PIPELINE tcpipudt:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep',
         tcpipudt:$printer;
      SET PAGE TO 1
      heading(PAGE)
      SET LINENO TO 4
      DISPLAY 'Printing report.' FOR FYI_MESSAGE;
   END

ON FIND
   IF sel = '2' THEN
   BEGIN
      IF ((ln_tcpip <> '') AND (ln_tcpip <> UNDEFINED)) THEN
      BEGIN
         SET tcpipudt:$user TO ' '
         SET tcpipudt:$number TO ' '
         SET tcpipudt:$user, tcpipudt:$number TO
            SELECT #no_pri_user, #no_phone
            FROM node
            WHERE #no_id=ln_node
         WRITE PIPELINE tcpipudt:$pipe1 pcol(20), ln_node, pcol(50),
            ln_tcpip, pcol(80), tcpipudt:$user, pcol(105),
            tcpipudt:$number
         addline
      END
   END

AFTER FIND
   IF sel = '2' THEN
   BEGIN
      CLOSE PIPELINE tcpipudt:$pipe1;
      DISPLAY 'Done printing report on selected record(s).  Hit RETURN to continue.'
         FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   ON FIELD
      SET sel TO UNDEFINED
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE '1':
            BEGIN
               IF ((ln_tcpip <> '') AND (ln_tcpip <> UNDEFINED)) THEN
               BEGIN
                  CREATE PIPELINE tcpipudt:$pipe1 '/usr/db/ACL4/aclenv/netops/cprobrep', printer;
                  heading(1)
                  SET tcpipudt:$user TO ' '
                  SET tcpipudt:$number TO ' '
                  SET user, number TO
                     SELECT #no_pri_user, #no_phone
                     FROM node
                     WHERE #no_id=ln_node
                  WRITE PIPELINE tcpipudt:$pipe1 pcol(20), ln_node,
                     pcol(50), ln_tcpip, pcol(80), user, pcol(105),
                     number
                  CLOSE PIPELINE tcpipudt:$pipe1;
               END
            END
         CASE '2':
            BEGIN
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN
               DISPLAY 'Enter only 1 or 2.  Press RETURN to try again.'
                  FOR FYI_MESSAGE WAIT;
            END
      END
