/*************************************************************************
*
*	updprices.fs    
*
*	FORM:	updprices      
*	DESCRIPTION:	This script was written for specifically one
*			purpose and does not represent a good use
*			for HDMS.  A department in DP&L did not do a
*			good job in keeping up with data entry, and
*			as a result, all of the prices were wrong in
*			one part of the database.  This script was
*			written to update all of these records.  Note
*			that it can only be run by one person (the
*			administrator for the application) so that it
*			does not get abused by others.  (It also
*			takes about 45 minutes to run with a very
*			large databse like ours.)
*
*	AUTHOR:    JWS
*	DATE:      Spring 1991
*	REVIEWER:  JWS
*
****************************************************************************/

FORM updprices       

LOCAL name, softname, softversion, hardname, price, allowed;

BEFORE FORM
   SET name TO user_name$()
   SET allowed TO FALSE
   SET updprices: AUTO_COMMIT TO TRUE
   SET updprices:sel:STOP_FOR_INPUT TO TRUE
   SET updprices:FIRST_FIELD TO 'sel'
   SET updprices:sel TO UNDEFINED
   IF name = 'john' THEN   /* Only authorized people can run script */
   BEGIN
      SET allowed TO TRUE
      DISPLAY 'Hi John, how are you?' FOR FYI_MESSAGE WAIT;
   END
   ELSE
   BEGIN
      SET allowed TO FALSE
      DISPLAY 'This script makes major changes to the database.  Press RETURN.'
         FOR FYI_MESSAGE WAIT;
      DISPLAY 'Talk to John Stewart in NetOps about running it.'
         FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   BEFORE FIELD
      SET sel TO UNDEFINED
   ON FIELD
      INPUT
      IF ((updprices:sel='1') AND (allowed=TRUE)) THEN
      BEGIN
         DISPLAY 'Doing Hardware ... Please Hold' FOR FYI_MESSAGE WAIT;
         SET hardname, price TO
            SELECT #pa_name, #pa_amount
            FROM parts
         EXECUTING BEGIN
            UPDATE pchard
               SET #ph_amount TO price
               WHERE #ph_mod=hardname
         END
         DISPLAY 'Doing Software ... Please Hold' FOR FYI_MESSAGE WAIT;
         SET softname, softversion, price TO
            SELECT #sv_sname, #sv_ver, #sv_price
            FROM softvend
         EXECUTING BEGIN
            UPDATE pcsoft
               SET #ps_amount TO price
               WHERE #ps_soft=softname AND #ps_ver=softversion
         END
      END
      ELSE IF ((sel='1') AND (allowed=FALSE)) THEN
      BEGIN
         DISPLAY 'You do not have permission for this action.'
            FOR FYI_MESSAGE WAIT;
         RESTART ON FIELD;
      END
      ELSE
      BEGIN
         beep$(3)
         DISPLAY 'Invalid choice.  Press RETURN to try again.'
            FOR FYI_MESSAGE WAIT;
      END
      RESTART ON FIELD
