/**************************************************************************
*
*	vencoderep.fs   
*
*	FORM:	vencoderep     
*	DESCRIPTION:	This script generates reports from the
*			vendor code database in HDMS.
*
*	AUTHOR:    DWM
*	DATE:      01/31/90
*	REVIEWER:  DWM
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM vencoderep      

TARGET_TABLE vcode

LOCAL sel,printer

BEFORE FORM
   SET vencoderep:sel:STOP_FOR_INPUT TO TRUE
   SET vencoderep:FIRST_FIELD TO 'sel'
   SET vencoderep:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer TO getenv$('SPOOLER')

BEFORE FIND
   set_select(vendorcode,vencoderep,vc_num)
   set_select(vendorcode,vencoderep,vc_site)
   set_select(vendorcode,vencoderep,vc_vendor)
   IF sel = 2 THEN
   BEGIN
      CREATE PIPELINE vencoderep:pipe1 'RPT /usr/db/ACL4/rptdir/vs1.r -',
         printer;
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE ;
   END
   IF sel = 3 THEN
   BEGIN
      CREATE PIPELINE vencoderep:pipe1 'RPT /usr/db/ACL4/rptdir/vs2.r -',
         printer;
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
   END

ON FIND
   IF sel = 2  OR sel = 3 THEN
      WRITE PIPELINE vencoderep:pipe1 vc_num,vc_site,vc_vendor

AFTER FIND
   IF sel = 2 OR sel = 3 THEN
   BEGIN
      CLOSE PIPELINE vencoderep:pipe1;
      DISPLAY 'Finished printing Selected records. Hit return to continue.'
        FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1: 
            BEGIN
               CREATE PIPELINE vencoderep:pipe1 'RPT /usr/db/ACL4/rptdir/vs1.r -',
                  printer;
               WRITE PIPELINE vencoderep:pipe1 vc_num,vc_site,vc_vendor
               CLOSE PIPELINE vencoderep:pipe1;
               DISPLAY 'Done printing Single record. Hit return to continue.'
                  FOR FYI_MESSAGE WAIT;
            END
         CASE 2:
            BEGIN
               DISPLAY 'Printing Report on selected records' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
            END
         CASE 3:
            BEGIN
               DISPLAY 'Printing Report on selected records' FOR FYI_MESSAGE;
               NEXT ACTION IS FIND
               DISPLAY 'Report finished.' FOR FYI_MESSAGE WAIT;
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'EITHER 1,2 or 3' FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
