/**************************************************************************
*
*	vendorcode.fs   
*
*	FORM:	vendorcode     
*	DESCRIPTION:	This script handles the form that tracks the
*			codes used for various vendors that are used
*			as abbreviations in other parts of the
*			application.
*
*	AUTHOR:    BSY
*	DATE:      8/9/89
*	REVIEWER:  BSY
*
****************************************************************************/

FORM vendorcode      

TARGET_TABLE vcode

BEFORE FORM
   SET vendorcode:AUTO_COMMIT TO TRUE

FIELD vc_site
   BEFORE FIELD
      ENABLE ZOOM to site RETURN KEY
      SET vendorcode:old_site TO vendorcode:vc_site
   ON FIELD
      INPUT
      IF vendorcode:old_site <> vendorcode:vc_site THEN
      BEGIN
         SET vendorcode:old_site TO vendorcode:vc_site
         SET vendorcode:vc_site TO
            SELECT #si_id FROM site WHERE #si_id = vendorcode:vc_site
         IF status$() < 0 THEN
         BEGIN
            DISPLAY vendorcode:old_site + ' was not found.  RETURN to continue.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END

FIELD vc_vendor
   BEFORE FIELD
      ENABLE ZOOM to vendor RETURN KEY
      SET vendorcode:old_vendor TO vendorcode:vc_vendor
   ON FIELD
      INPUT
      IF vendorcode:old_vendor <> vendorcode:vc_vendor THEN
      BEGIN
         SET vendorcode:old_vendor TO vendorcode:vc_vendor
         SET vendorcode:vc_vendor TO
            SELECT #ve_id FROM vendor WHERE #ve_id = vendorcode:vc_vendor
         IF status$() < 0 THEN
         BEGIN
            DISPLAY vendorcode:old_vendor + ' was not found.  RETURN to continue.' FOR FYI_MESSAGE WAIT
            RESTART ON FIELD
         END
      END
