/**************************************************************************
*
*	vendorrep.fs    
*
*	FORM:	vendorrep      
*	DESCRIPTION:  Vendor Report. 
*
*	AUTHOR:    DWM
*	DATE:      01/15/90
*	REVIEWER:
*
****************************************************************************/

#define set_select(prevf,curf,fieldname) \
   SET curf:fieldname:SEARCH_RANGES TO prevf:fieldname:SEARCH_RANGES

FORM vendorrep       

TARGET_TABLE vendor
 
LOCAL sel,printer

BEFORE FORM
   SET vendorrep:sel:STOP_FOR_INPUT TO TRUE
   SET vendorrep:FIRST_FIELD TO 'sel'
   SET vendorrep:AUTO_FIND TO TRUE   
   SET sel TO UNDEFINED
   SET printer to getenv$('SPOOLER')

BEFORE FIND
   set_select(vendor,vendorrep,ve_id)
   set_select(vendor,vendorrep,ve_phone) 
   set_select(vendor,vendorrep,ve_name) 
   set_select(vendor,vendorrep,ve_address1) 
   set_select(vendor,vendorrep,ve_address2) 
   set_select(vendor,vendorrep,ve_city_state) 
   set_select(vendor,vendorrep,ve_salesman) 
   set_select(vendor,vendorrep,ve_sales_phone) 
   set_select(vendor,vendorrep,ve_open_po) 
   set_select(vendor,vendorrep,ve_vc1) 
   set_select(vendor,vendorrep,ve_vc2) 
   set_select(vendor,vendorrep,ve_vc3) 
   set_select(vendor,vendorrep,ve_vc4) 
   set_select(vendor,vendorrep,ve_vc5) 
   set_select(vendor,vendorrep,ve_vc6) 
   set_select(vendor,vendorrep,ve_vc7) 
   set_select(vendor,vendorrep,ve_vc8) 
   set_select(vendor,vendorrep,ve_vc9) 
   set_select(vendor,vendorrep,ve_vc10) 
   set_select(vendor,vendorrep,ve_vc11) 
   set_select(vendor,vendorrep,ve_vc12) 
   IF sel = 2 THEN
   BEGIN
      CREATE PIPELINE vendorrep:pipe1 'RPT /usr/db/ACL4/rptdir/vendor.r -',
         printer;
      DISPLAY 'Creating Pipeline' FOR FYI_MESSAGE;
   END

ON FIND
   IF sel = 2 THEN
   BEGIN
      WRITE PIPELINE vendorrep:pipe1 ve_id,ve_address1,ve_address2,
         ve_salesman,ve_sales_phone 
   END

AFTER FIND
   IF sel = 2 THEN
   BEGIN
      CLOSE PIPELINE vendorrep:pipe1;
      DISPLAY 'Printing Report on selected records'
      FOR FYI_MESSAGE WAIT;
   END

FIELD sel
   ON FIELD
      REFRESH SCREEN
      INPUT
      SWITCH sel
      BEGIN
         CASE 1:
            BEGIN
               CREATE PIPELINE vendorrep:pipe1 'RPT /usr/db/ACL4/rptdir/vendor.r -',
                  printer;
               WRITE PIPELINE vendorrep:pipe1 ve_id,ve_address1,ve_address2,
                  ve_salesman,ve_sales_phone 
               CLOSE PIPELINE vendorrep:pipe1;
               DISPLAY 'Done printing single record.  RETURN to continue.' FOR FYI_MESSAGE WAIT;
            END
         CASE 2:
            BEGIN
               DISPLAY 'Printing report on selected records' FOR FYI_MESSAGE ;
               NEXT ACTION IS FIND
            END
         DEFAULT:
            BEGIN 
               DISPLAY 'Enter either 1 or 2 only.  Press RETURN to try again.' FOR FYI_MESSAGE WAIT;
               RESTART ON FIELD
            END
      END
