#############################################################################
proc DateTime {} {
   global irc
   if $irc(TIMESTAMP) {
      return [clock format [clock seconds] -format "%x %X"]
   } else {
      return ""
   }
}
#############################################################################
proc MODE_CHNL {ch who mode} {
   global irc
   CheckWindow $ch
   set ch [string tolower $ch]
   OutMsg $ch "\t\t\t" {} MODE sys " : Nick "
   InsertNick $ch $who
   OutMsg $ch " set mode: $mode\n"
   puts $irc($ch,LOG) "[DateTime] ---------------MODE $who set mode: $mode"
   puts $irc(SOCK) "NAMES $ch"
}
#############################################################################
proc MODE_USER {who mode} {
   puts "MODE: User $who sets mode : $mode"
}
#############################################################################
proc KICK {ch nick victim reason} {
   global irc
   set ch [string tolower $ch]
   if {[string compare [string toupper $victim] [string toupper $irc(ME)]]==0} {
      bell
      puts $irc(SOCK) "JOIN $ch"; # ReJOIN after KICK
   } else {
      LeaveChannel $ch $victim
      CheckWindow $ch
      UpdateNickList $ch
   }
   OutMsg $ch "\t\t\t" {} KICK {FG8 BG12} " : "
   InsertNick $ch $nick
   OutMsg $ch " kill -> " {} $victim nick "\n"
   puts $irc($ch,LOG) "[DateTime] ---------------KICK $nick kill him:  $victim"
}
#############################################################################
proc NICK {old new} {
   global irc env
   foreach i [array names irc *,WIN] {
      regexp {^(.*),} $i full ch
      if $irc($ch,IS_CHNL) {
         if [LeaveChannel $ch $old] {
            lappend irc($ch,NICKS) $new
            UpdateNickList $ch
            OutMsg $ch "\t\t\t" {} NICK sys " : "
            InsertNick $ch $old
            OutMsg $ch " -> "
            InsertNick $ch $new
            OutMsg $ch "\n"
            puts $irc($ch,LOG) "[DateTime] ---------------NICK $old now is $new"
         }
      }
   }
   if {[string compare $old $irc(ME)]==0} {set irc(ME) $new}
}
#############################################################################
proc CODE_332 {ch topic} {
   global irc env
   CheckWindow $ch
   set channel [string tolower $ch]
   if [string compare "$irc($channel,CPAGE)" "$env(PLATFORM)"] {
      set topic [$irc($channel,CPAGE)_$env(PLATFORM) $topic]
   }
   wm title $irc([string tolower $ch],WIN) "$ch : $topic"
}
#############################################################################
proc CODE_366 {ch list} {
   global irc env
   CheckWindow $ch
   set ch [string tolower $ch]
   set irc($ch,NICKS) [split [string trim $list]]
   UpdateNickList $ch
}
#############################################################################
proc MakeNickBtn {win nick {who ordinary}} {
   global irc
   button $win._$nick -text $nick -cursor hand2
   if {[string compare $who "friend"]==0} {
      $win._$nick configure -background blue -foreground white
   }
   return $win._$nick
}
#############################################################################
proc UpdateNickList {ch} {
   global irc env
   $irc($ch,LIST) delete 1.0 end
   set irc($ch,NICKS) [lsort $irc($ch,NICKS)]
   set friends {}; set others {};
   foreach nick $irc($ch,NICKS) {
      if {[string compare $nick ""]==0} continue
      set unknown 1
      set clean_nick [string trim $nick {+@_-^`'|[]}]
      foreach friend $irc(FRIENDS) {
         if {[string first [string tolower $friend] [string tolower $clean_nick]]==0} {
            lappend friends $nick
            set unknown 0; break
         }
      }
      if $unknown { lappend others $nick }
   }
   foreach nick $friends {
      $irc($ch,LIST) window create end -create "MakeNickBtn $irc($ch,LIST) $nick friend" -align center
      $irc($ch,LIST) insert end "\n"
   }
   foreach nick $others {
      $irc($ch,LIST) window create end -create "MakeNickBtn $irc($ch,LIST) $nick" -align center
      $irc($ch,LIST) insert end "\n"
   }
}
#############################################################################
proc OutMsg {w args} {
   global irc
   eval {$irc($w,OUT) insert end} $args
   if {[$irc($w,OUT) index insert]==[$irc($w,OUT) index {end -1 lines}]} { $irc($w,OUT) see end }
}
#############################################################################
proc OutRichMsg {w text} {
    global irc env
    set t $irc($w,OUT)
    set BoldOn 0; set UnderlineOn 0; set ReverseOn 0; set ColorOn 0; set CatchMode 0
    set fg $env(DEFAULT_FG); set bg $env(DEFAULT_BG);
    foreach c [split $text {}] {
       switch -- $c {
       "\026" {
          if $ReverseOn {
             set ind [$t index {end -1 chars}]
             $t tag add REVERSE ReverseMark $ind
             set ReverseOn 0; $t mark unset ReverseMark;
          } else {
             set ind [$t index {end -1 chars}]
             $t mark set ReverseMark $ind
             $t mark gravity ReverseMark left
             set ReverseOn 1
          }
       }
       "\037" {
          if $UnderlineOn {
             set ind [$t index {end -1 chars}]
             $t tag add UNDERLINE UnderlineMark $ind
             set UnderlineOn 0; $t mark unset UnderlineMark;
          } else {
             set ind [$t index {end -1 chars}]
             $t mark set UnderlineMark $ind
             $t mark gravity UnderlineMark left
             set UnderlineOn 1
          }
       }
       "\2" {
          if $BoldOn {
             set ind [$t index {end -1 chars}]
             $t tag add BOLD BoldMark $ind
             set BoldOn 0; $t mark unset BoldMark;
          } else {
             set ind [$t index {end -1 chars}]
             $t mark set BoldMark $ind
             $t mark gravity BoldMark left
             set BoldOn 1
          }
       }
       "\3" {
          set CatchMode 1; set step 1; set ind [$t index {end -1 chars}]
          if $ColorOn {
             $t tag add "FG[expr $fg]" ColorMark $ind
             $t tag add "BG[expr $bg]" ColorMark $ind
          } else {
             set ColorOn 1
          }
          $t mark set ColorMark $ind
          $t mark gravity ColorMark left
       }
       default {
          if $CatchMode {
             if [regexp {[0-9,]} $c] {
                switch -- $step {
                1 {
                     if {"$c"==","} {
                        $t insert end $c; set CatchMode 0
                     } else {
                        set fg $c; set step 2;
                     }
                }
                2 {
                   if {"$c"==","} {set step 4; continue}
                   if {"$fg$c" <= 15} {
                      set fg "$fg$c"; set step 3
                   } else {
                      $t insert end $c; set CatchMode 0
                   }
                }
                3 {
                     if {"$c"==","} {
                        set step 4; continue
                     } else {
                        $t insert end $c; set CatchMode 0
                     }
                }
                4 {
                     if {"$c"==","} {
                        $t insert end {,,}; set CatchMode 0
                     } else {
                        set bg $c; set step 5;
                     }
                }
                5 {
                   if {"$c"==","} {
                        $t insert end $c; set CatchMode 0
                   } else {
                      if {"$bg$c" <= 15} {
                         set bg "$bg$c"; set CatchMode 0
                      } else {
                         $t insert end $c; set CatchMode 0
                      }
                   }
                }
                }
             } else {
                $t insert end $c; set CatchMode 0
             }
          } else {
             $t insert end $c
          }
       }
       }
    }
    if $BoldOn {
         set ind [$t index {end -1 chars}]
         $t tag add BOLD BoldMark $ind
         $t mark unset BoldMark;
    }
    if $ReverseOn {
         set ind [$t index {end -1 chars}]
         $t tag add REVERSE ReverseMark $ind
         $t mark unset ReverseMark;
    }
    if $UnderlineOn {
         set ind [$t index {end -1 chars}]
         $t tag add UNDERLINE UnderlineMark $ind
         $t mark unset UnderlineMark;
    }
    if $ColorOn {
        if {$step > 1} {
            set ind [$t index {end -1 chars}]
            $t tag add "FG[expr $fg]" ColorMark $ind
            $t tag add "BG[expr $bg]" ColorMark $ind
        }
    }
}
#############################################################################
proc ShowColorHelp {} {
   global env
   toplevel .color_help
   pack [text .color_help.txt1] -fill both -expand 1
   foreach i $env(ATTR) {
      eval ".color_help.txt1 tag configure $i"
   }
   for {set i 0} {$i < 16} {incr i} {
      .color_help.txt1 insert end "  $i  " BG$i
   }
}
#############################################################################
proc HandleReturn {ch say} {
   global irc env
   if [string compare "$irc($ch,CPAGE)" "$env(PLATFORM)"] {
      set say [$env(PLATFORM)_$irc($ch,CPAGE) $say]
   }
   if {[string index $say 0] == {/}} {
      regexp {^/([^ ]+) ?(.*)$} $say full cmd rest
      switch -- [string toupper $cmd] {
      DO {
         set say "\1ACTION $rest\1"
      }
      }
   }
   puts $irc(SOCK) "PRIVMSG $ch :$say";
   PRIVMSG $irc(ME) $ch $say
   $irc($ch,IN) selection range 0 end
}
#############################################################################
proc CheckWindow {win} {
   global irc env
   set ch [string tolower $win]
   if [catch {set irc($ch,WIN)}] {
      if [catch {set irc($ch,LOG)}] {
         set irc($ch,LOG) [open "$irc(LOGPLACE)/$ch" a+]
         fconfigure $irc($ch,LOG) -buffering line
         puts $irc($ch,LOG) [clock format [clock seconds] -format "\n\n======================     %x  %X ===============\n"]
      }
      set irc($ch,WIN) ._[incr irc(NEXT)]
      toplevel $irc($ch,WIN)
      wm title $irc($ch,WIN) $win
      set irc($ch,IS_CHNL) [regexp {^[#&]} $ch]
      set irc($ch,OUT) [text $irc($ch,WIN).text1 -font $env(FONT) -foreground {#000000} -background {#D9D9D9} -yscrollcommand "$irc($ch,WIN).sb1 set"]
      if [catch {set irc($ch,CPAGE)}] {set irc($ch,CPAGE) $env(DEFAULT_CPAGE)};# default charset
      foreach i $env(ATTR) {
         eval "$irc($ch,OUT) tag configure $i"
      }
      scrollbar $irc($ch,WIN).sb1 -command "$irc($ch,OUT) yview" -orient vertical
      set irc($ch,IN) [entry $irc($ch,WIN).entry1 -font $env(FONT)]
      bind $irc($ch,IN) <KeyPress-Return> "HandleReturn $ch \[$irc($ch,IN) get]";
      if {[string compare "$env(PLATFORM)" "unix"]==0} {
         bind $irc($ch,IN) <KeyPress-F8> { set env(RUSSIAN) [expr 1-$env(RUSSIAN)]; }
      }
      bind $irc($ch,IN) <KeyPress-F7> {set env(TRANSLIT) [expr 1-$env(TRANSLIT)]; }
      bind $irc($ch,IN) <KeyPress-F1> {%W insert insert "\2"}
      bind $irc($ch,IN) <KeyPress-F2> {
         %W insert insert "\3"
         if [catch {set state [wm state .color_help]}] {
            ShowColorHelp
         }
      }
      bind $irc($ch,IN) <KeyPress-F3> {%W insert insert "\026"}
      bind $irc($ch,IN) <KeyPress-F4> {%W insert insert "\037"}
      bind $irc($ch,IN) <KeyPress-F6> {%W insert insert "\1"}
      bind $irc($ch,IN) <KeyPress> {
         if {$env(RUSSIAN) && [string compare "$env(PLATFORM)" "unix"]==0} {
            if {[catch {set Russian(%K)}]==0} {%W insert insert $Russian(%K);break}
         }
         if $env(TRANSLIT) {
            if {[catch {set Eng2Trans(%A)}]==0} {%W insert insert $Eng2Trans(%A); break}
         }
      }
      bind $irc($ch,IN) <Destroy> " \
         unset irc($ch,WIN);        \
         if $irc($ch,IS_CHNL) {puts \$irc(SOCK) \"PART $ch\"}; \
      ";
      if $irc($ch,IS_CHNL) {
         set irc($ch,LIST) [text $irc($ch,WIN).text2 -width 12 -yscrollcommand "$irc($ch,WIN).sb2 set"]
         scrollbar $irc($ch,WIN).sb2 -command "$irc($ch,LIST) yview" -orient vertical
         grid $irc($ch,OUT)  $irc($ch,WIN).sb1 $irc($ch,LIST) $irc($ch,WIN).sb2 -sticky news
         grid $irc($ch,IN) -        -                 -        -sticky news
      } else {
         grid $irc($ch,OUT)  $irc($ch,WIN).sb1 -sticky news
         grid $irc($ch,IN) -        -sticky news
      }
      grid rowconfigure $irc($ch,WIN) 0 -weight 1
      grid columnconfigure $irc($ch,WIN) 0 -weight 1
   }
}
#############################################################################
proc InsertNick {ch nick} {
   global irc
   $irc($ch,OUT) tag configure $nick
   $irc($ch,OUT) tag bind $nick <ButtonRelease-1> "$irc($ch,IN) insert insert \"$nick: \"; \
                                    focus $irc($ch,IN); %W mark set insert end;break"
   $irc($ch,OUT) tag bind $nick <Enter> "$irc($ch,OUT) configure -cursor hand2"
   $irc($ch,OUT) tag bind $nick <Leave> "$irc($ch,OUT) configure -cursor arrow"
   $irc($ch,OUT) insert end $nick "nick $nick"
}
#############################################################################
proc PRIVMSG {src target msg} {
   global irc env
   if {[regexp -nocase "^$target$" $irc(ME)]} {
      set ch $src
      bell
   } else {
      set ch $target
   }
   set ch [string tolower $ch]
   if [regexp "^\1(\[^ ]+) *(\[^\1]*)" $msg full cmd args] {
      catch {CTCP_[string toupper $cmd] $ch $src $args}; return;
   }
   CheckWindow $ch
   if [string compare "$irc($ch,CPAGE)" "$env(PLATFORM)"] {
      set msg [$irc($ch,CPAGE)_$env(PLATFORM) $msg]
   }
   InsertNick $ch $src
   OutMsg $ch " - "
   OutRichMsg $ch $msg
   OutMsg $ch "\n"
   puts $irc($ch,LOG) [format "[DateTime] %9s - %s" $src $msg]
}
#############################################################################
proc JOIN {w src} {
   global irc env
   regexp {^([^!]+)!([^@]+)@(.*)$} $src full nick user host
   if {[string compare "$irc(ME)" "$nick"]==0} return
   CheckWindow $w
   set w [string tolower $w]
   lappend irc($w,NICKS) $nick
   UpdateNickList $w
   OutMsg $w "\t\t\t" {} JOIN {FG1 BG8} " : "
   InsertNick $w $nick
   OutMsg $w " $user \[$host]\n"
   puts $irc($w,LOG) "[DateTime] ---------------JOIN $nick"
}
#############################################################################
proc PART {w nick} {
   global irc env
   if {[string compare $irc(ME) $nick]==0} return
   LeaveChannel $w $nick
   CheckWindow $w
   set w [string tolower $w]
   UpdateNickList $w
   OutMsg $w "\t\t\t" {} PART sys " : " {} $nick nick "\n"
   puts $irc($w,LOG) "[DateTime] ---------------PART $nick"
}
#############################################################################
proc LeaveChannel {w nick} {
   global irc env
   set w [string tolower $w]; set nick [string tolower $nick]
   set ind [UserOnChannel $w $nick]
   if {$ind != -1} {
      set irc($w,NICKS) [lreplace $irc($w,NICKS) $ind $ind]
      return 1
   }
   return 0
}
#############################################################################
proc UserOnChannel {w nick} {
   global irc env
   set w [string tolower $w]; set nick [string tolower $nick]
   foreach i $irc($w,NICKS) {
      regexp {^[+@]?(.*)$} [string tolower $i] full clear_nick
      if {[string compare $clear_nick $nick]==0} {
         return [lsearch -exact $irc($w,NICKS) $i]
      }
   }
   return -1
}
#############################################################################
proc QUIT {nick reason} {
   global irc env
   foreach i [array names irc *,WIN] {
      regexp {^(.*),} $i full ch
      if $irc($ch,IS_CHNL) {
         if [LeaveChannel $ch $nick] {
            if [string compare "$irc($ch,CPAGE)" "$env(PLATFORM)"] {
               set reason [$irc($ch,CPAGE)_$env(PLATFORM) $reason]
            }
            OutMsg $ch "\t\t\t" {} QUIT sys " : " {} $nick nick " Reason : $reason\n"
            puts $irc($ch,LOG) "[DateTime] ---------------QUIT $nick by reason: $reason"
            UpdateNickList $ch
         }
      }
   }
}
#############################################################################
proc INVITE {} {
}
#############################################################################
proc CTCP_VERSION {ch src args} {
   puts "User $src want to know your version."
}
#############################################################################
proc CTCP_ACTION {ch src action} {
   global irc env
   CheckWindow $ch
   set ch [string tolower $ch]
   if [string compare "$irc($ch,CPAGE)" "$env(PLATFORM)"] {
      set action [$irc($ch,CPAGE)_$env(PLATFORM) $action]
   }
   InsertNick $ch $src
   OutRichMsg $ch " $action"
   OutMsg $ch "\n" act_text
   puts $irc($ch,LOG) [format "[DateTime] %9s %s" $src $action]
}
#############################################################################
proc Cleanup {in out bytes {error {}}} {
   global irc
   incr irc(RECEIVED) $bytes
   if {[string length $error] != 0 || [eof $in]} {
      close $in; close $out;
      puts -nonewline "---------DCC transfer completed. Result: ";
      if {$irc(RECEIVED)==$irc(TOTAL)} {
         puts "Ok"
      } else {
         puts "Error: Received only $irc(RECEIVED) bytes"
      }
   } else {
      puts -nonewline $in [binary format I $irc(RECEIVED)]
      fcopy $in $out -command [list Cleanup $in $out] -size 256
   }
}
#############################################################################
proc DecodeIP {ip} {
   set ip [binary format I $ip]
   binary scan $ip cccc d1 d2 d3 d4
   foreach i {1 2 3 4} {
      set d$i [expr ([set d$i] + 0x100) % 0x100]
   }
   return "$d1.$d2.$d3.$d4"
}
#############################################################################
proc CTCP_DCC {ch src arg} {
   global irc
   regexp {^([^ ]+) +(.*)$} $arg full dcc_type arg
   switch -- [string toupper $dcc_type] {
   SEND {
      regexp {^([^ ]+) +([^ ]+) +([^ ]+) +([^ ]+)} $arg full fname raw_ip port size
      set local_file [tk_getSaveFile -initialfile $fname -title "DCC SEND from $src"]
      if {$local_file != ""} {
         set file [open $local_file w]
         set sock [socket [DecodeIP $raw_ip] $port]
         fconfigure $file -buffering none -translation binary
         fconfigure $sock -buffering none -translation binary
         puts "----Receiving file $local_file (size=${size})from [DecodeIP $raw_ip]"
         set irc(TOTAL) $size
         set irc(RECEIVED) 0
         fcopy $sock $file -size 256 -command [list Cleanup $sock $file]
      }
   }
   CHAT {
      regexp {^[^ ]+ +([^ ]+) +([^ ]+)} $arg full raw_ip port
      tk_messageBox -icon warning -message "You're invited to DCC CHAT at [DecodeIP $raw_ip] on port $port\n" -title "CTCP DCC" -type ok
   }
   default {puts "Unknown DCC type : $dcc_type"; return; }
   }
}
#############################################################################
#############################################################################
#############################################################################
#############################################################################
