#ifndef __TDISKVIEW_H
//	Avoid include redundancy
#define __TDISKVIEW_H

//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Include File:	tdiskvie.h
//	Purpose:	Provide a view of free disk space in the temporary
//			directory.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-18-94	created

//	Constant defines
#define Uses_TView
#define Uses_TRect

//	Required includes
#include<tv.h>

//	Class declarations
class TDiskView : public TView	{
public:
	TDiskView(TRect& TR_dimensions);
	virtual void update();
	virtual void draw();
	virtual unsigned long int GetDiskFree();
private:
	unsigned long int uli_past, uli_pres;
	char DiskInAscii[16];
};

//	Global variable declarations

//	Macros

#endif // __TDISKVIEW_H
