//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TSockView
//	Include File:	tsockvie.h
//	Purpose:	Display total amount of current network activity
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-31-94	created
//		02-10-94	Split all members into seperate files.
#include"tsockvie.h"

extern "C"	{
#include"msdostcp.h"
};

unsigned long int TSockView::GetSockSize()	{
//	Purpose:	Return the current socket activity
//	Arguments:	void
//	Return Value:	unsigned long int	the current socket activity.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-31-94	created

	//	Count the total number of bytes read in written in sockets.
	unsigned long int uli = 0UL;
	for(int i_counter = 0; i_counter < MAXSOCKETS; i_counter++)	{
		if(sock_table[i_counter].vp_sockfd != NULL)	{
			uli += sock_table[i_counter].uli_read +
				sock_table[i_counter].uli_written;
		}
	}

	return(uli);
}