//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"

char *TURLView::getChild()	{
//	Purpose:	Returns the URL of the child anchor currently
//			selected.
//	Arguments:	void
//	Return Value:	char *	Pointer to the name.  Receiver of this info
//				should release memory returned by this since
//				no attempt will be made to do so otherwise.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-31-94	created

	//	is there an anchor selected?
	if(TAp_selected == NULL)
		return(NULL);

	//	get appropriate information
	auto HTAnchor *HTAp_linkdest = HTAnchor_followMainLink((HTAnchor *)
		(TAp_selected->HTCAp_anchor));

	//	return the anchor url
	return(HTAnchor_address(HTAp_linkdest));
}
