//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#define Uses_TProgram
#define Uses_TDeskTop
#include"turlwind.h"
#include"trace.h"

void TURLWindow::handleEvent(TEvent& TE_event)	{
//	Purpose:	Handle any events for the window.
//	Arguments:	TE_event	The event occuring
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-21-94	created

	//	Command handler
	if(TE_event.what & evMessage)	{
		switch(TE_event.message.command)	{
		case cmResize:
		case cmZoom:
		case cmTile:
		case cmCascade:	{
			//	Need to reload the URL if window chaned size.
			TRect oldTR = getExtent();

			//	Have the base resize.
			TWindow::handleEvent(TE_event);
			clearEvent(TE_event);

			TRect TR = getExtent();

			//	Reload the url only if the view changed size.
			if(TR.b.x != oldTR.b.x)	{
				//	First take out the last item in the
				//	history.  There will always be atleast
				//	one entry.  Assume the reload always
				//	works.
				auto char *cp_oldURL = (char *)
					(TNSCp_visited->at(TNSCp_visited->
					getCount() - 1));
				TNSCp_visited->remove(cp_oldURL);
				TNSCp_visited->pack();
				delete(cp_oldURL);

				//	Reload.
				URLoader(TURLV->getURL());
			}
			break;
		}
		case cmLoadChild:	{
#ifndef RELEASE
			trace("loading child anchor.");
#endif // RELEASE
			clearEvent(TE_event);

			//	Get the child's name.
			auto char *cp_childURL = TURLV->getChild();
			if(cp_childURL == NULL)	{
				//	a valid child anchor not selected.
				doslynxmessage("Invalid selection.");
				delete(cp_childURL);
				break;
			}

			//	Attempt the load.
			URLoader(cp_childURL);
			delete(cp_childURL);
			break;
		}
		case cmClose:	{
#ifndef RELEASE
			trace("closing window.");
#endif // RELEASE
			destroy(TURLV);
			TURLV = NULL;
			break;
		}
		case cmLoadParent:	{
#ifndef RELEASE
			trace("loading previous document.");
#endif // RELEASE
			clearEvent(TE_event);

			//	Make sure there is a previous entry.
			if(TNSCp_visited->getCount() <= 1)	{
				doslynxmessage("There are no previous "
					"documents.");
				break;
			}

			//	Remove the last two names from the collection.
			//	URLoader will replace the appropriate names.
			auto char *cp_remove1, *cp_remove2;
			cp_remove1 = (char *)(TNSCp_visited->at(
				TNSCp_visited->getCount() - 1));
			TNSCp_visited->remove((void *)cp_remove1);
			TNSCp_visited->pack();
			cp_remove2 = (char *)(TNSCp_visited->at(
				TNSCp_visited->getCount() - 1));
			TNSCp_visited->remove((void *)cp_remove2);
			TNSCp_visited->pack();

			URLoader(cp_remove2);
			delete(cp_remove1);
			delete(cp_remove2);

			break;
		}
		case cmCloneWindow:	{
			//	Get the name of the current url from our
			//	history list.
			auto char *cp_clone;
			cp_clone = (char *)(TNSCp_visited->at(TNSCp_visited->
				getCount() - 1));

			//	Create our new valid window with our history.
			TView *TV_new = TProgram::application->validView(
				(TView *)new TURLWindow(TNSCp_visited, cp_clone));

			//	If not created, don't insert onto the desktop.
			//	Assume WWW produced appropriate error message.
			if(TV_new != NULL)	{
				TProgram::deskTop->insert(TV_new);
			}
			break;
		}
		case cmSearchIndex:	{
			//	Clear the event.
			clearEvent(TE_event);

			//	First check to see if the current loaded view
			//	is searchable.
			if(B_isIndex == False)	{
				doslynxmessage("Not a searchable index.");
				break;
			}

			//	Otherwise, do an index search.
			IndexQuery();
		}
		case cmReceivedFocus:	{
			//	See if we should enable the search index.
			if(B_isIndex == True)	{
				enableCommand(cmSearchIndex);
			}
			break;
		}
		case cmAddToHist:	{
			//	We should add the following to our visited
			//	History.  This message used by view that
			//	really doesn't want to reload but to go to
			//	a tagged anchor within that document.
			auto char *cp_toAdd = newStr((char *)TE_event.
				message.infoPtr);
			TNSCp_visited->insert(cp_toAdd);
			clearEvent(TE_event);
			break;
		}
		}
	}
	else if(TE_event.what & evMouse)	{
		//	A right button down will cause a copy of the current
		//	window with the current document to be loaded.
		if(TE_event.what == evMouseDown && TE_event.mouse.buttons ==
			mbRightButton)	{
			clearEvent(TE_event);
			TEvent TE_clone;
			TE_clone.what = evMessage;
			TE_clone.message.command = cmCloneWindow;
			TProgram::application->putEvent(TE_clone);
		}
	}

	//	Call the base event handler.
	TWindow::handleEvent(TE_event);
}
