.\"(c) Copyright 1993 by Panagiotis Tsirigotis
.\"All rights reserved.  The file named COPYRIGHT specifies the terms 
.\"and conditions for redistribution.
.\"
.\" $Id: pstext.man,v 1.3 1993/02/19 21:58:46 panos Exp $
.TH PSTEXT 1L "4 February 1993"
.SH NAME
pstext \- extract the text of a postscript file
.SH SYNOPSIS
.B pstext
[\fB-l\fP]
[\fB-v\fP]
[\fB-d\fP]
[\fB-e\fP]
[\fB-n\fP]
[\fB-p process\fP]
.IR "file"
.SH DESCRIPTION
This program extracts the text contained in the specified postscript
.I file.
Such files are normally produced by other programs.
.I pstext
needs to identify how the file was produced in order to successfully
extract the text from it.
It currently understands files generated by the following programs:
.RS
.IP dvips
.IP "ditroff through psdit"
.IP WordPerfect
.IP idraw
.RE
.LP
If
.I file
is missing, the standard input is used.
.SH OPTIONS
.TP 12
.SB "-v"
Print to standard error how the postscript file was derived
.TP
.SB "-n"
Do nothing
.TP
.SB "-d"
Enable debugging. Currently this option has no effect.
.TP
.SB "-p process"
This option directs
.I pstext 
to use the specified
.I process
to parse the file.
Available processes include:
.RS
.RS
.TP 10
.SB dvi
.TP
.SB psdit
ditroff through psdit
.TP
.SB dit
ditroff
.TP
.SB troff
.TP
.SB wp
wordperfect
.RE
.RE
.TP
.SB "-e"
Determines if it can automatically determine the file's type.
Returns an exit code of 0 if it can; otherwise it returns 1.
.SB "-l"
Lists the name of available processes (those are the names that can be used
as arguments to the
.I "-p"
option).
.SH AUTHOR
Panos Tsirigotis, CS dept, University of Colorado, Boulder
.SH BUGS
.I pstext
will extract nothing if it can't determine how the file was generated.
