########################## -*- Mode: Perl -*- ##########################
##
## File             : CITATION.pm
##
## Description      : converts tagged format (journals)
##
#
# Copyright (C) 1996 Ulrich Pfeifer, Norbert Goevert
#
# This file is part of SFgate.
#
# SFgate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# SFgate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SFgate; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
##
## Author           : Norbert Goevert
## Created On       : 
##
## Last Modified By : Norbert Goevert
## Last Modified On : Fri Dec 13 19:22:52 1996
##
## $State: Exp $
##
## $Id: CITATION.pm,v 5.1.1.1 1996/12/23 12:49:25 goevert Exp goevert $
##
## $Log: CITATION.pm,v $
## Revision 5.1.1.1  1996/12/23 12:49:25  goevert
## patch6: introduced new order orl
##
## Revision 5.1  1996/11/05 16:54:58  goevert
## *** empty log message ***
##
## Revision 5.0.1.2  1996/05/23 17:07:08  goevert
## patch13: removed no strict 'vars';
##
## Revision 5.0.1.1  1996/05/13 11:27:08  goevert
## patch1:
##
########################################################################


package SFgate::Converter::CITATION;


use strict;


## #####################################################################
## convert
## #####################################################################
## interface for SFgate to convert one document
##
## (string) $text:     document to convert
## (string) $headline: headline of document to convert
##
## By default every document is printed with its corresponding wais
## headline. If you want to derive another headline just change
## the $headline variable according to your needs.
##
## HTML special characters (&, <, >) should be encoded in text not
## being HTML code. To do this you can use the function
## &::encode_entities, e.g. $ntext = &::encode_entities($ntext)
## encodes the special chars in $ntext.
##
## returns:
## - string: the converted document ($ntext)
## - string: headline of converted document ($headline)
##
sub convert
{
    my($text, $headline) = @_;
    ## local variables
    my($au, $ti, $ab, $jt, $vo, $no, $pp, $py);
    ## return value
    my($ntext);
    
    ($au) = $text =~ /\nAU: ((.*\n )*.*)/;
    $au   =~ s/\s+/ /g;
    $au   = &::encode_entities($au);
    ($ti) = $text =~ /\nTI: ((.*\n )*.*)/;
    $ti   =~ s/\s+/ /g;
    $ti   =~ s/\.$//;
    $ti   = &::encode_entities($ti);
    ($ab) = $text =~ /\nAB: ((.*\n )*.*)/;
    $ab   =~ s/\s+/ /g;
    $ab   = &::encode_entities($ab);
    ($jt) = $text =~ /\nJT: ((.*\n )*.*)/;
    $jt   =~ s/\s+/ /g;
    ($vo) = $text =~ /\nVO: (.*)/;
    ($no) = $text =~ /\nNO: (.*)/;
    ($pp) = $text =~ /\nPP: (.*)/;
    ($py) = $text =~ /\nPY: (.*)/;
        
    my $order = &get_orderurl($text);
    $ntext = '<A HREF="http://bib.informatik.uni-dortmund.de/journals/htbin/orderform?' . $order . '">';
    $ntext .= "<B>$ti</B></A>";
    $ntext .= " by $au"                  if $au;
    $ntext .= "<BR>\nIn: <EM>$jt</EM>";
    $ntext .= ", $vo"                    if $vo;
    $ntext .= " ($no)"                   if $no;
    $ntext .= ", page $pp"               if $pp;
    $ntext .= " ($py)"                   if $py;
    $ntext .= ".\n";
    $ntext .= " <P>\n$ab\n"              if $ab;

    return($ntext, '');
}

## #####################################################################
## helper subroutines
## #####################################################################

sub get_orderurl
{
    local($_) = shift;
    my($urlprefix) = @_;

    my(%parms, $tmp);
    

    ($parms{CK}) = /^CK: (.*)/m;
    ($parms{AU}) = /^AU: ((.*\n )*.*)/m;
    $parms{AU}   =~ s/\s+/ /g;
    ($parms{TI}) = /\nTI: ((.*\n )*.*)/m;
    $parms{TI}   =~ s/\s+/ /g;
    $parms{TI}   =~ s/\.$//;
    ($parms{JT}) = /^JT: (.*)/m;
    ($parms{PY}) = /^PY: (.*)/m;
    ($parms{VO}) = /^VO: (.*)/m;
    if (/^NO: (.*)\nNO: (.*)/m) {
        $parms{NO} = "$1/$2";
    }
    else {
        ($parms{NO}) = /^NO: (.*)/m;
    }
    ($parms{PP}) = /^PP: (.*)/m;
    ($parms{SC}) = /^SC: (.*)/m;
    ($parms{DT}) = /^DT: (.*)/m;
    ($parms{ED}) = /^ED: (.*)/m;

    my $request;
    foreach (keys %parms) {
        $request .= "&$_=" . &::encode($parms{$_});
    }
    $request =~ s/^&//;
    $request;
}


1;
