/*
 * Copyright (c) 1990, 1991, 1996, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: util.c,v 1.22 97/06/19 20:11:49 leres Exp $ (LBL)";
#endif

/*
 * util - random utility routines
 */

#include <sys/types.h>
#include <sys/time.h>

#include <ctype.h>
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#ifdef TIME_WITH_SYS_TIME
#include <time.h>
#endif

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include <err.h>

#include "util.h"

/* Globals */
extern char *__progname;

#define STRSIZE 8192		/* size to malloc when more space is needed */

/* Return a malloc()ed copy of the passed string */
char *
savestr(register char *str)
{
        register int i;
	static char *strptr = NULL;
	static u_int strsize = 0;

        i = strlen(str) + 1;
        if (i > strsize) {
                strsize = STRSIZE;
                strptr = mymalloc(strsize, "savestr");
        }
        (void)strcpy(strptr, str);
        str = strptr;
        strptr += i;
        strsize -= i;
        return (str);
}

/* Failsafe version malloc() */
char *
mymalloc(register u_int size, register char *what)
{
	register char *cp;

	if ((cp = malloc(size)) == 0)
		err(1, "Geordie: \"Damn! %s malloc() failed!\"", what);
	return (cp);
}

/* Convert a long to a string */
char *
long2str(register long n)
{
	register int minus = 0;
	register char *cp;
	static char buf[32];

	if (n < 0) {
		n = -n;
		++minus;
	}

	cp = buf + sizeof(buf) - 1;
	*cp = '\0';
	do {
		*--cp = n % 10 + '0';
		n /= 10;
	} while (n > 0);

	if (minus)
		*--cp = '-';
	return (cp);
}

/* Convert from history newsgroup to article pathname */
char *
artpath(register char *spool_dir, register char *art)
{
	register char *cp;
	static char path[512];

	cp = path;
	(void) strcpy(cp, spool_dir);
	cp += strlen(cp);
	*cp++ = '/';

	while (*art != '/' && *art != '\0') {
		if (*art == '.')
			*cp++ = '/';
		else
			*cp++ = *art;
		++art;
	}
	if (*art == '/') {
		++art;
		*cp++ = '/';
	}
	while (isdigit(*art))
		*cp++ = *art++;
	*cp = '\0';

	return (path);
}

/* Format a delta time */
char *
fmtdelta(register time_t t)
{
	register char *cp;
	register int d, h, m, s;
	int minus = 0;
	static char buf[132];

	d = h = m = s = 0;
	if (t < 0) {
		t = -t;
		++minus;
	}

	d = t / (24 * 60 * 60);
	t = t % (24 * 60 * 60);

	h = t / (60 * 60);
	t = t % (60 * 60);

	m = t / 60;
	s = t % 60;

	cp = buf + 1;
	(void)sprintf(cp, "%d %d:%02d:%02d", d, h, m, s);
	if (cp[0] == '0' && cp[1] == ' ') {
		cp += 2;
		if (cp[0] == '0' && cp[1] == ':') {
			cp += 2;
			if (cp[0] == '0')
				++cp;
		}
	}
	if (minus)
		*--cp = '-';
	return (cp);
}

static char *dow[7] = {
	"Sun",
	"Mon",
	"Tue",
	"Wed",
	"Thu",
	"Fri",
	"Sat"
};

static char *moy[12] = {
	"Jan",
	"Feb",
	"Mar",
	"Apr",
	"May",
	"Jun",
	"Jul",
	"Aug",
	"Sep",
	"Oct",
	"Nov",
	"Dec"
};

#define DOW(d) ((d) < 0 || (d) >= 7 ? "?" : dow[d])
#define MOY(m) ((m) < 0 || (m) >= 12 ? "?" : moy[(m)])

/* Format date and time */
char *
fmtdate(time_t t)
{
	static char buf[132];
	register struct tm *tm;

	if (t == 0)
		return ("<no date>");

	tm = localtime(&t);

	(void)sprintf(buf, "%s, %2d-%s-%d %2d:%02d:%02d",
	    DOW(tm->tm_wday),
	    tm->tm_mday,
	    MOY(tm->tm_mon),
	    tm->tm_year + 1900,
	    tm->tm_hour,
	    tm->tm_min,
	    tm->tm_sec);
	return (buf);
}

void
msg(const char *fmt, ...)
{
	va_list ap;

	(void)printf("%s: ", __progname);
#if __STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	if (fmt != NULL)
		(void)vprintf(fmt, ap);
	va_end(ap);
	putchar('\n');
}
