/*
 * Copyright (c) 1996, 1997, 1998
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char copyright[] =
    "@(#) Copyright (c) 1996, 1997, 1998\n\
The Regents of the University of California.  All rights reserved.\n";
static const char rcsid[] =
    "@(#) $Header: diskfree.c,v 1.6 98/01/16 19:17:41 leres Exp $ (LBL)";
#endif

/*
 * diskfree - report free disk space and inodes
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include <err.h>

#include "disk.h"
#include "util.h"

/* Forwards */
int main(int, char **);
__dead void usage(void) __attribute__((volatile));

/* Public data */
int noheader;

#ifdef HAVE__PROGNAME
extern char *__progname;
#else
char *__progname;
#endif

/* External data */
extern char *optarg;
extern int optind;
extern int opterr;

int
main(int argc, char **argv)
{
	register int op;
	register char **p;
#ifndef HAVE__PROGNAME
	register char *cp;
#endif
	long total, used_kb, free_kb, inodes, ifree;

#ifndef HAVE__PROGNAME
	if ((cp = strrchr(argv[0], '/')) != NULL)
		__progname = cp + 1;
	else
		__progname = argv[0];
#endif

	while ((op = getopt(argc, argv, "h")) != EOF)
		switch (op) {

		case 'h':
			++noheader;
			break;

		default:
			usage();
		}

	if (optind == argc)
		usage();
	if (!noheader)
		printf("%-20s %7s %7s %7s %7s %7s\n",
		    "filesystem", "Kbytes", "used", "avail", "inodes", "ifree");
	for (p = argv + optind; *p != NULL; ++p) {
		if (disk_usage(*p, &used_kb, &free_kb, &inodes, &ifree) < 0)
			err(1, "disk_usage(): %s", *p);
		total = used_kb + free_kb;
		printf("%-20s %7ld %7ld %7ld %7ld %7ld\n",
		    *p, total, used_kb, free_kb, inodes, ifree);
	}

	exit(0);
	/* NOTREACHED */
}

__dead void
usage(void)
{

	(void)fprintf(stderr, "usage: %s [-h] filesystem ...\n", __progname);
	exit(1);
}
