/*
 * Copyright (c) 1991, 1992, 1996, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static const char copyright[] =
    "@(#) Copyright (c) 1991, 1992, 1996, 1997\n\
The Regents of the University of California.  All rights reserved.\n";
static const char rcsid[] =
    "@(#) $Header: blocktest.c,v 1.10 97/07/04 02:17:42 leres Exp $ (LBL)";
#endif

/*
 * blocktest - test filesystem blocksize assumptions
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>

#include <errno.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include <err.h>

#include "util.h"

#ifdef HAVE__PROGNAME
extern char *__progname;
#else
char *__progname;
#endif

int main(int, char **);

int
main(int argc, char **argv)
{
	register int i, fd, b, c, frag;
#ifndef HAVE__PROGNAME
	register char *cp;
#endif
	char file[132];
	struct stat sbuf;
	char ch;

#ifndef HAVE__PROGNAME
	if ((cp = strrchr(argv[0], '/')) != NULL)
		__progname = cp + 1;
	else
		__progname = argv[0];
#endif

	/* Need a temporary file */
	(void)mktemp(strcpy(file, "/tmp/blocktest.XXXXX"));

	/* Better not already exist */
	if (unlink(file) >= 0)
		errx(1, "%s already existed!", file);
	if (errno != ENOENT)
		err(1, "unlink(): %s", file);

	/* Create the file */
	fd = creat(file, 0644);
	if (fd < 0)
		err(1, "creat(): %s", file);

	/* Remove now so we don't have to later */
	(void)unlink(file);

	/* Slowly ramp up the size and see if anything unexpected happens */
	frag = 0;
	for (i = 0; i <= 10 * 1024; ++i) {
#ifdef __MACH__
		if (fsync(fd) < 0)
			err(1, "fsync(): %s", file);
#endif
		if (fstat(fd, &sbuf) < 0)
			err(1, "fstat(): %s", file);

		/* Size better agree */
		if (sbuf.st_size != i)
			errx(1, "Size wrong (%d != %d)", (int)sbuf.st_size, i);

		/* Calculate number of 512 byte blocks */
		b = (i + 511) / 512;

		/* Try to determine file system frag size */
		if (i == 1)
			frag = sbuf.st_blocks;

		/* Calculate number of frag blocks */
		if (frag)
			c = ((b + frag - 1) / frag) * frag;
		else
			c = -1;

		if (b != sbuf.st_blocks && c != sbuf.st_blocks)
			errx(1, "Not 512 byte blocks!");

		/* Write one byte of random data */
		ch = i % 0xff;
		if (write(fd, &ch, 1) != 1)
			err(1, "write(): %s", file);
	}

	msg("Success: This machine appears to use 512 byte blocks");
	(void)close(fd);
	exit(0);
	/* NOTREACHED */
}
