/*
 * Copyright (c) 1990, 1991, 1992, 1996, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: file.c,v 1.20 97/06/19 20:11:54 leres Exp $ (LBL)";
#endif

/*
 * file - file parsing routines
 */

#include <sys/types.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include <err.h>

#include "file.h"

extern char *__progname;

/* Read and parse the active file */
int
readactive(register FILE *f, int (*fn)(char *, u_long, u_long, char))
{
	register int n;
	register char *cp;
	char line[1024];
	char *group;
	char mod;
	int nn, on;
	char *p = "active file";

	n = 0;
	while (fgets(line, sizeof(line), f)) {
		++n;
		cp = line;
		group = cp;
		if ((cp = strchr(cp, ' ')) == NULL) {
			warnx("%s missing first blank on line %d", p, n);
			return (0);
		}
		*cp++ = '\0';
		nn = atoi(cp);
		if ((cp = strchr(cp, ' ')) == NULL) {
			warnx("%s missing 2nd blank on line %d", p, n);
			return (0);
		}
		++cp;
		on = atoi(cp);
		if ((cp = strchr(cp, ' ')) == NULL) {
			warnx("%s missing 3rd blank on line %d", p, n);
			return (0);
		}
		++cp;
		mod = *cp;

		/* Convert dots in group to slashes */
		for (cp = group; *cp != '\0'; ++cp)
			if (*cp == '.')
				*cp = '/';

		if (!(*fn)(group, nn, on, mod))
			return (0);
	}

	/* Paranoid safety check */
	if (ferror(f)) {
		warn("readactive()");
		return (0);
	}

	return (1);
}

/* Read and parse the expire list */
int
readexplist(register FILE *f, int (*fn)(char *, char, int, int))
{
	register int n;
	register char *cp, *cp2;
	char line[1024];
	char *group, mod;
	int pri, days;
	char *p = "explist file";

	n = 0;
	while (fgets(line, sizeof(line), f)) {
		++n;
		cp = line;
		cp2 = cp + strlen(cp) - 1;
		if (cp2 >= cp && *cp2 == '\n')
			*cp2++ = '\0';
		if (*cp == '\0' || *cp == '#')
			continue;

		group = cp;
		while (!isspace(*cp))
			++cp;
		if (!isspace(*cp)) {
			warnx("%s missing whitespace after group on line %d",
			    p, n);
			return (0);
		}
		*cp++ = '\0';
		while (isspace(*cp))
			++cp;
		if (!isalpha(*cp)) {
			warnx("%s missing moderation flag on line %d", p, n);
			return (0);
		}
		mod = *cp++;
		while (isspace(*cp))
			++cp;
		if (!isdigit(*cp)) {
			warnx("%s missing priority on line %d", p, n);
			return (0);
		}
		pri = atoi(cp);

		/* Days field is optional */
		while (isdigit(*cp))
			++cp;
		while (isspace(*cp))
			++cp;
		days = atoi(cp);

		/* Convert dots in group to slashes */
		for (cp = group; *cp != '\0'; ++cp)
			if (*cp == '.')
				*cp = '/';

		/* Make multiple calls for combined groups */
		do {
			if ((cp = strchr(group, ',')) != NULL)
				*cp++ = '\0';
			if (!(*fn)(group, mod, pri, days))
				return (0);
			group = cp;
		} while (group);
	}

	/* Paranoid safety check */
	if (ferror(f)) {
		warn("readexplist()");
		return (0);
	}

	return (1);
}
