/*
 * Copyright (c) 1991, 1996, 1997, 1998
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: hash.c,v 1.11 98/05/16 12:20:14 leres Exp $ (LBL)";
#endif

/*
 * hash - hash utilities
 */

#include <sys/types.h>

#include <ctype.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#include <string.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "hash.h"
#include "util.h"

static struct hash htable[NGROUP];

/* Updates ngnp as a side effect */
int
hashgroup(register char **ngnp)
{
	register int h;

	h = 0;
	for (; **ngnp != '\0' && **ngnp != '/'; ++*ngnp)
		h = (h * 31 + (int)**ngnp) % NGROUP;
	return (h);
}

int
hashadd(register char *ngn, register time_t t)
{
	register int h, len;
	register struct hash *hp;
	register char *cp;
	char *cp2;

	len = strlen(ngn) + 1;				/* includes '/' */
	cp = (char *)mymalloc(len + 1, "hash string");	/* includes eos */
	strcpy(cp, ngn);
	strcat(cp, "/");
	cp2 = cp;
	h = hashgroup(&cp2);
	hp = &htable[h];

	if (hp->ngn == NULL) {
		hp->ngn = cp;
		hp->to = t;
		hp->len = len;
		return (1);
	} else {
		hp = (struct hash *)mymalloc(sizeof(struct hash), "hash");
		memset((char *)hp, 0, sizeof(*hp));
		hp->ngn = cp;
		hp->to = t;
		hp->len = len;
		hp->next = htable[h].next;
		htable[h].next = hp;
		return (0);
	}
}

time_t
hashfind(register int h, register char *ngn)
{
	register struct hash *hp;

	if (h < 0 || h > NGROUP)
		return (-1);

	for (hp = &htable[h]; hp; hp = hp->next)
		if (hp->ngn != NULL && strncmp(hp->ngn, ngn, hp->len) == 0)
			return (hp->to);
	return (-1);
}

void
hashdump(void)
{
	register int h;
	register struct hash *hp;
	int col, maxcol;
	int i;

	col = 0;
	maxcol = 0;
	(void)printf("------\nDiagnostic hash dump:\n");
	for (h = 0; h < NGROUP; ++h) {
		i = 0;
		for (hp = &htable[h]; hp; hp = hp->next) {
			if (hp->ngn)
				(void)printf("%4d: %d\t%s (%d)\n",
				    h, (int)hp->to, hp->ngn, hp->len);
			if (hp->next) {
				++col;
				++i;
			}
		}
		if (i > maxcol)
			maxcol = i;
	}
	(void)printf("\n------\nHash stats:\n");
	printf("%d collisions (%d max)\n", col, maxcol);
}
