
# PREFIX is inserted above this line during Make

trap : 2 3

PATH=/bin:$PATH
export PATH

# Paramaters transferred from nn via .param file:
#	ART_ID		Article id to cancel
#	GROUP		Group of article to cancel
#	WORK		Temporary file for response (w initial contents)
#	FIRST_ACTION	First action to perform
#	EMPTY_CHECK	[empty-response-check]
#	EDITOR		[editor]
#	ED_LINE		First line of body in WORK file
#	SPELL_CHECKER	[spell-checker]
#	PAGER		[pager]
#	APPEND_SIG	[append-signature]
#	QUERY_SIG	[query-signature]
#	NOVICE		[expert]
#	WAIT_PERIOD 	[response-check-pause]
#	RECORD		[mail/news-record]
#	MAILER		[mailer]
#	MAILER_PIPE	[mailer-pipe-input]
#	DFLT_ANSW	[response-default-answer]

. ${HOME}/.nn/.param

# first argument is operation to be performed:

OPERATION=$1

# first we handle 'cancel'

if [ "$OPERATION" = "cancel" ] ; then

  $INEWS -h  << EOF > /tmp/nn$$c 2>&1
Newsgroups: $GROUP
Subject: cancel $ART_ID
Control: cancel $ART_ID

cancel $ART_ID in newsgroup $GROUP
EOF

  x=$?
  case $x in
    0) ;;
    *) echo '' ; cat /tmp/nn$$c ; sleep 2 ;;
  esac
  rm -f /tmp/nn$$c
  exit $x
fi


TRACE=${WORK}T
FINAL=${WORK}F
COPY=""

if [ "${FIRST_ACTION}" != "send" ] ; then
  COPY=${WORK}C
  cp $WORK $COPY
fi

# loop until sent or aborted.

loop=true
prompt=false
pr="Action: a)bort e)dit"
if [ -n "$(SPELL_CHECKER)" ] ; then
  pr="$pr i)spell"
fi
pr="$pr r)eedit s)end v)iew w)rite: "
if [ -n "${DFLT_ANSW}" ] ; then
  pr="$pr (${DFLT_ANSW}) "
fi

while $loop ; do
  if [ -n "${FIRST_ACTION}" ] ; then
    act="${FIRST_ACTION}"
    FIRST_ACTION=""
  elif $prompt ; then
    echo ''
    ${AWK} 'END{printf "'"${pr}"'"}' < /dev/null
    read act
    if [ -z "$act" ] ; then
      act="${DFLT_ANSW}"
    fi
  fi
  prompt=true

  case $act in
  a*)
    ${AWK} 'END{printf "Confirm abort: (y) "}' < /dev/null
    read act
    case "$act" in
    ""|"y*") rm -f $WORK $COPY ;
	     exit 22 ;;
    esac
    ;;
  e*)
    # call editor to enter at line $ED_LINE of work file

    case `basename "${EDITOR-vi}"` in
    vi|emacs|emacsclient )
      # Berkeley vi display editor
      # GNU emacs disply editor
      ${EDITOR-vi} +${ED_LINE} $WORK
      ;;
    ded )
      # QMC ded display editor
      $EDITOR -l${ED_LINE} $WORK
      ;;
    uemacs )
      # micro emacs
      $EDITOR -g${ED_LINE} $WORK
      ;;
    * )
      # Unknown editor
      $EDITOR $WORK
      ;;
    esac

    if [ ! -s $WORK ] ; then
      rm -f $WORK $COPY
      exit 22
    fi

    if ${EMPTY_CHECK} ; then
      if cmp -s $WORK $COPY ; then
        rm -f $WORK $COPY
        exit 22
      fi
    fi
    ;;

  i*)
    if [ -n "${SPELL_CHECKER}" ] ; then
      ${SPELL_CHECKER} ${WORK}
    else
      echo "spell-checker not defined"
    fi
    ;;

  r*)
    ${AWK} 'END{printf "Edit original file: (y) "}' < /dev/null
    read act
    case "$act" in
    ""|"y*") cp $COPY $WORK ;;
    esac
    FIRST_ACTION=edit
    ;;

  s*)
    loop=false
    ;;

  v*)
    ${PAGER-cat} $WORK
    ;;

  w*)
    echo "Append article to file:"
    read FNAME
    if [ -n "$FNAME" ] ; then
      { cat $WORK ; echo ; } >> $FNAME
    fi
    ;;
  esac
done

case "$OPERATION" in

  reply|forward|mail)
    if [ ${APPEND_SIG} = "true" -a -f $HOME/.signature ] ; then
      if ${QUERY_SIG} ; then
          ${AWK} 'END{printf "Append .signature? (y) "}' < /dev/null
          read ans
      else
          ans=y
      fi
      case $ans in
      ''|y*|Y*)
        echo "--" >> $WORK
        cat $HOME/.signature >> $WORK
        ;;
      esac
    fi
    ;;
  follow|post)
    if ${NOVICE} ; then
      echo "Be patient! Your new article will not show up immediately."
      case ${WAIT_PERIOD-0} in
	0|1) WAIT_PERIOD=2 ;;
      esac
    fi
    ;;
esac

{
  trap 'echo SIGNAL' 1 2 3

  grep -v "^Orig-To: " $WORK > $FINAL

  LOGNAME="${LOGNAME-$USER}"
  if [ -z "${LOGNAME}" ] ; then
    set `who am i`
    LOGNAME="$1"
  fi

  if [ -n "${RECORD}" ] ; then
  {
    # keep a copy of message in $RECORD (in mail format)
    set `date`
    if [ $3 -gt 9 ] ; then
      echo From ${LOGNAME} $1 $2 $3 $4 $6 $7
    else
      echo From ${LOGNAME} $1 $2 " $3" $4 $6 $7
    fi
    echo "From: ${LOGNAME}"
    cat $FINAL
    echo ''
  } >> "$RECORD"
  fi

  case "$OPERATION" in

    reply|forward|mail)
      if ${MAILER_PIPE} ; then
        $MAILER < $FINAL
        x=$?
      else
        $MAILER $FINAL
        x=$?
      fi
      case $x in
	0) ;;
	*) echo $MAILER failed ;;
      esac
      ;;

    follow|post)
      $INEWS -h < $FINAL
      case $? in
	0) sleep 60 ;;
	*) echo $INEWS failed ;;
      esac
      ;;

    *)
      echo "Invalid operation: $OPERATION -- help"
      OPERATION="nn response operation"
      ;;
  esac > $TRACE 2>&1

  if [ -s $TRACE ] ; then
    if [ -s $HOME/dead.letter ] ; then
      cat $HOME/dead.letter >> $HOME/dead.letters
      echo '' >> $HOME/dead.letters
    fi
    cat $WORK > $HOME/dead.letter

    # Gripe: Error-report is lost if REC_MAIL was the problem
    {
      echo "To: ${LOGNAME}"
      echo "Subject: $OPERATION failed"
      echo ''
      cat $TRACE
      echo ''
      echo 'Your response has been saved in ~/dead.letter'
      echo ''
      echo 'Your article/letter follows:'
      cat $WORK
    } > $FINAL
    if ${MAILER_PIPE} ; then
      $MAILER < $FINAL
    else
      $MAILER $FINAL
    fi
  else
    # keep TRACE file a little while for test at end of script
    sleep 3
  fi
  rm -f $WORK $COPY $TRACE $FINAL

} > /dev/null 2>&1 &

case ${WAIT_PERIOD-0} in
  0) ;;
  *) sleep ${WAIT_PERIOD} ;;
esac

if [ -s "$TRACE" ] ; then
  exit 1
fi

exit 0
