/*
 *	(c) Copyright 1990, Kim Fabricius Storm.  All rights reserved.
 *
 *	Global declarations and definitions.
 */

/*
 *	Marks for global/external variables
 */

#define	export			/* export variable from module */
#define import	extern		/* import variable into module */

/*
 *	Various constants and types
 */

typedef int8  	attr_type;
typedef int32 	flag_type;

#ifdef I286_BUG
#	define FLAG(n)	(1L<<(n-1))
#else
#	define FLAG(n)	(((flag_type)1)<<(n-1))
#endif

typedef int32	article_number;
typedef int16	group_number;
typedef uint32	time_stamp;

typedef int	(* fct_type )();
#define CALL(fct)  (* (fct))
#define NULL_FCT  (fct_type)NULL

/* frequently used characters */

#define NUL	'\0'
#define TAB	'\t'
#define NL	'\n'
#define CR	'\r'
#define BS	'\b'
#define SP	' '

/* misc macros */

#define fl fflush(stdout)

#ifdef CONTROL_
#undef CONTROL_
#endif
#define CONTROL_(c)	(c&037)

#ifndef HAVE_STRCHR
#define	strrchr		rindex
#define strchr		index
#endif

#ifdef SIGNAL_HANDLERS_ARE_VOID
#define sig_type void
#else
#define sig_type int
#endif

#ifndef NNTP
#undef NNTP_POST
#endif

/*
 *	Some systems don't define these in <sys/stat.h>
 */

#ifndef S_IFMT
#define	S_IFMT	0170000			/* type of file */
#define S_IFDIR	0040000			/* directory */
#define S_IFREG	0100000			/* regular */
#endif

#ifndef O_RDONLY
#define	O_RDONLY	0
#define	O_WRONLY	1
#define	O_RDWR		2
#endif

/* define types of library functions */

char 	*getenv(), *ctime();
char 	*strchr(), *strrchr();
off_t 	lseek(), ftell(), tell();
int	atoi();
long	atol();


/* define types of own functions */

char *mk_file_name(), *home_relative();
char *date_time(), *user_name(), *plural();
char *copy_str();

time_t	file_exist(), m_time(), cur_time();

extern FILE *open_file();
char *relative();

#define	OPEN_READ	0	/* open for reading */
#define	OPEN_UPDATE	1	/* open/create for update */
#define	OPEN_CREATE	2	/* create/truncate for write */
#define	OPEN_APPEND	3	/* open for append */
#define OPEN_CREATE_RW	4	/* create for read/write */

#define	DONT_CREATE	0x40	/* return if file does not exist */
#define	MUST_EXIST	0x80	/* fatal error if cannot open */
#define	OPEN_UNLINK	0x100	/* unlink after open (not OPEN_UPDATE) */


/*
 *	Other external definitions
 *
 *	NOTICE: the distinction between pointers and arrays is important
 *		here (they are global variables - not function arguments)
 */

extern char

    *nn_directory,
    *lib_directory,
    version_id[];

#ifdef NNTP
extern int  use_nntp;   /* 1 iff we are using nntp */
#else
#define use_nntp 0	/* for optimizers */
#endif

extern int
    s_hangup,	/* hangup signal */
    s_keyboard,	/* keyboard signal */
    s_pipe,	/* broken pipe */
    s_redraw;	/* continue signal after stop */

extern int who_am_i;

#define I_AM_MASTER	0
#define I_AM_NN		1
#define I_AM_ADMIN	2
#define I_AM_CHECK	3
#define I_AM_TIDY	4
#define I_AM_EMACS	5
#define I_AM_GOBACK	6
#define I_AM_POST	7
#define I_AM_GREP	8
#define	I_AM_DAILY	9
#define	I_AM_SPEW	10
#define I_AM_EXPIRE	11
#define	I_AM_ACCT	12

extern unsigned short		/* as they are on most systems... */
    user_id,
    group_id;

extern int
    process_id;

extern int errno;

/*
 *	Storage management
 */

extern char *mem_obj(), *mem_resize(), *mem_str();

#define	newobj(type, nelt) \
    (type *)mem_obj(sizeof(type), (int32)(nelt))

#define	newstr(nelt) \
    mem_str((int32)(nelt))

#define	resizeobj(obj, type, nelt) \
    (type *)mem_resize((char *)(obj), sizeof(type), (int32)(nelt))

#define	freeobj(obj) mem_free((char *)(obj))

#define quicksort(a,n,t,f) qsort((char *)(a), (unsigned)(n), sizeof(t), f)

#include "vararg.h"
#include "data.h"

/*
 *	db external data
 */

extern master_header master;

/* group headers */

extern group_header *active_groups, **sorted_groups;

/* current group information */

extern char 	group_path_name[];
extern char	*group_file_name;

extern group_header *current_group, *group_sequence, *rc_sequence;

extern group_header *lookup();


int l_g_index, s_g_first;

#define	Loop_Groups_Number(num) \
    for (num = 0; num < master.number_of_groups; num++)

#define Loop_Groups_Header(gh) \
    for (l_g_index = 0, gh=active_groups; \
	 l_g_index < master.number_of_groups; \
	 l_g_index++, gh++)

#define Loop_Groups_Sorted(gh) \
    for (l_g_index = s_g_first; \
	 (l_g_index < master.number_of_groups) && \
	 (gh = sorted_groups[l_g_index]) ;\
	 l_g_index++)

#define	Loop_Groups_Sequence(gh) \
    for (gh = group_sequence; gh; gh = gh->next_group)

#define	Loop_Groups_Newsrc(gh) \
    for (gh = rc_sequence; gh; gh = gh->newsrc_seq)
