/*
 *	(c) Copyright 1990, Kim Fabricius Storm.  All rights reserved.
 *
 *	Terminal interface definitions.
 */



extern init_term();
extern home();
extern gotoxy();
extern clrdisp(), clrpage();
extern clrline();

extern so_gotoxy(), so_printf(), so_end();

extern no_raw(), raw(), unset_raw();

extern int Lines, Columns;
extern int cookie_size;
extern int WRAP, STANDOUT;

extern char *get_s();

#define	NONE		(char *)NULL /* no default string etc. */

#define	GET_S_BUFFER	256 	/* if caller want to reuse get_s buffer */

extern get_c();

/* special keys returned by get_c() */

#define	K_interrupt	CONTROL_('G')

#define	K_up_arrow	0x0081
#define	K_down_arrow	0x0082
#define K_left_arrow	0x0083
#define K_right_arrow	0x0084

#define	K_function(n)	(0x0085 + n)


#define	GETC_COMMAND	0x4000	/* bit set by get_c to return a command */


/*
 *	prompt_line = ...
 *	prompt( [P_COMMAND], ] [ format [, arg1 ... , arg4] ] );
 *
 *	P_MOVE:		just move to prompt line
 *	P_REDRAW:	redraw prompt
 *      P_VERSION:	print version on prompt line
 */


extern prompt();

int prompt_line;	/* prompt line */

#define	P_MOVE		(char *)1
#define P_REDRAW	(char *)5
#define	P_VERSION	(char *)9
#define P_SAVE		(char *)13
#define P_RESTORE	(char *)17

extern display_file();

#define	CLEAR_DISPLAY	0x01
#define	CONFIRMATION	0x02
