/*
 *	support.c	1.0	18-Mar-91	EHK
 *	support.c	1.1	16-Apr-91	EHK
 *	support.c	1.2	23-May-91	EHK
 *	support.c	1.3	03-Jan-92	EHK
 */

#include "nestor.h"

/*
 *---------------------------------------------------------------------------
 *	hhmmss		- convert time in seconds to HH:MM:SS
 *---------------------------------------------------------------------------
 */
char	*
HHMMSS(secs)
	float	secs;
{
	register char	*hhmmss_buf;		/* "HHH:MM:SS\0"	*/
	register int	hours, mins, isecs;

	if ( (hhmmss_buf = (char *) malloc(10)) == NIL_CHAR )
		perror("malloc_hhmmss"), exit(-1);

	isecs = (int) secs;

	hours	= isecs / 3600;
	isecs	%= 3600;
	mins	= isecs / 60;
	isecs	%= 60;

	sprintf(hhmmss_buf, "%3d:%02d:%02d", hours, mins, isecs);

	return( hhmmss_buf );
}

/*
 *---------------------------------------------------------------------------
 *	LookUp		- find hostname statistics entry in linked list
 *---------------------------------------------------------------------------
 */
nntp_t	*
LookUp(host)
	char	*host;
{
	register nntp_t	*np;

	for ( np = nntps ; np < nntps + num_nntp_hosts ; np++ )
	{
		if ( !strcmp(np->nntp_host, host) )
			return( np );
	}

	return( NIL_NNTP );
}

/*
 *---------------------------------------------------------------------------
 *	Insert		- insert statistics entry at first free slot in
 *			  the array and increment number of hosts seen.
 *---------------------------------------------------------------------------
 */
nntp_t	*
Insert(host)
	char	*host;
{
	register nntp_t	*np;

	if ( num_nntp_hosts >= NUM_NNTP_HOSTS - 1)
		fprintf(stderr, "\n\
Overflow Warning: Recompile with bigger value for ``NUM_NNTP_HOSTS''.\n\n"),
			exit(-9);

	np = &nntps[num_nntp_hosts++];

	bzero((char *) np, sizeof(nntp_t));
	strcpy(np->nntp_host, host);

	return( np );
}

/*
 *---------------------------------------------------------------------------
 *	NntpCompar	- comparison routine for alpha sort
 *---------------------------------------------------------------------------
 */
int
NntpCompar(np1, np2)
	nntp_t	*np1,
		*np2;
{
	return( strcmp(np1->nntp_host, np2->nntp_host) );
}

/*
 *---------------------------------------------------------------------------
 *	SortNntps	- sort statistics alphabetically on hostname
 *---------------------------------------------------------------------------
 */
int
SortNntps(np)
	nntp_t	*np;
{
	qsort(np, (size_t) num_nntp_hosts, (size_t) sizeof(nntp_t), NntpCompar);
}

/*
 *---------------------------------------------------------------------------
 *	FindKey		- lookup a keyword and return its mnemonic
 *---------------------------------------------------------------------------
 */
int
FindKey(keyword)
	char	*keyword;
{
	register keytab_t	*kp;

	for ( kp = keytable ; kp->k_key != NIL_CHAR ; kp++ )
		if ( !strcmp(kp->k_key, keyword) )
			return( kp->k_mne );

	return( -1 );
}

/*
 *---------------------------------------------------------------------------
 *	StrSave		- malloc/save a string
 *---------------------------------------------------------------------------
 */
char	*
StrSave(str)
	char	*str;
{
	register char	*tmp;

	if ( (tmp = (char *) malloc(strlen(str) + 1)) == NIL_CHAR )
		perror("malloc_strsave"), exit(-1);
	
	strcpy(tmp, str);

	return( tmp );
}

#ifndef HAVE_STRSTR
/*
 *---------------------------------------------------------------------------
 *	strstr		- find first occurence of string s2 in string s1
 *---------------------------------------------------------------------------
 */
char	*
strstr(s1, s2)
	char	*s1,
		*s2;
{
	register char	*cp;

	cp = s1;
	while ( (cp = index(cp, *s2)) != NIL_CHAR )
		if ( !strncmp(cp, s2, strlen(s2)) )
			return( cp );
		else
			++cp;
	
	return( NIL_CHAR );
}
#endif /* HAVE_STRSTR */
