#include <errno.h>
#include <fcntl.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/stat.h>
#include <sys/time.h>
#include "readline.h"
#include "nntplink.h"
#include "strfuns.h"

extern char *E_fcntl;
extern char *E_fopen;
extern char *E_fseek;
extern char *E_fstat;
extern char *E_open;
extern char *E_read;
extern char *E_rename;
extern char *E_unlink;
extern char *E_write;

extern Boolean Abort_signaled;
extern Boolean Debug;
extern int Dtablesize;
extern long Idle_time;
extern int Input_from;
extern Boolean One_shot;
extern Boolean Reset_signaled;

extern void close_article();
extern void check_sleep();
extern Boolean parse_entry();
extern void fail();
extern void log();

int No_articles = 0;

void
  check_batchfile()
{
    static char *fname = "check_batchfile: ";
    struct stat statb;
    int fd;

    Batchfile.use = FALSE;

    if (!One_shot) {

	if (stat(Batchfile.nname, &statb) != FAIL) {

	    dlog(LOG_DEBUG, fname, "%sFound batchfile.nntp\n");

	    if (statb.st_size == 0) {

		dlog(LOG_DEBUG, fname, "%sbatchfile.nntp is empty\n");

		if (unlink(Batchfile.nname) < 0)
		  fail(fname, E_unlink, Host.name, Batchfile.nname,
		       errmsg(errno));
	    } else {

		if ((fd = open(Batchfile.nname, O_RDONLY)) == FAIL)
		  fail(fname, E_open, Host.name, Batchfile.nname, "r",
		       errmsg(errno));

		Batchfile.use = TRUE;
		Batchfile.nntp_in_use = TRUE;
		Batchfile.fbp = fb_fdopen(fd);
		if ((statb.st_ino == Batchfile.inode) &&
		    (Batchfile.offset != 0) &&
		    (fb_seek(Batchfile.fbp, Batchfile.offset, 0) == FAIL))
		  log(LOG_WARNING, fname, E_fseek, Host.name, Batchfile.nname,
		      errmsg(errno));
		else
		  Batchfile.inode = statb.st_ino;
		return;
	    }
	}

	if (Input_from & FLG_BATCHFILE) {

	    dlog(LOG_DEBUG, fname, "%swaiting for batchfile: ");

	    while (stat(Batchfile.name, &statb) == FAIL)
	      check_sleep(Batchfile.nap_time, CREATE_BATCH);

	    dlog(LOG_DEBUG, "", "%sGot it\n");
	}
    }

    if ((stat(Batchfile.name, &statb) != FAIL) &&
	((Input_from & FLG_BATCHFILE) || !One_shot)) {

	dlog(LOG_DEBUG, fname, "%sFound batchfile\n");

	if (Input_from & FLG_BATCHFILE) {

	    if ((fd = open(Batchfile.name, O_RDONLY)) == FAIL)
	      fail(fname, E_open, Host.name, Batchfile.name, "r",
		   errmsg(errno));

	    Batchfile.fbp = fb_fdopen(fd);
	    Batchfile.use = TRUE;
	    if ((statb.st_ino == Batchfile.inode) &&
		(Batchfile.offset != 0) &&
		(fb_seek(Batchfile.fbp, Batchfile.offset, 0) == FAIL))
	      log(LOG_WARNING, fname, E_fseek, Host.name, Batchfile.name,
		  errmsg(errno));
	    else
	      Batchfile.inode = statb.st_ino;
	    return;

	} else {
	    if (statb.st_size == 0) {

		dlog(LOG_DEBUG, fname, "%sbatchfile is empty - removing\n");

		if (unlink(Batchfile.name) < 0)
		  dlog(LOG_WARNING, fname, E_unlink, Host.name, Batchfile.name,
		       errmsg(errno));

	    } else {

		dlog(LOG_DEBUG, fname,
		     "%srenaming batchfile to batchfile.nntp\n");

		if (rename(Batchfile.name, Batchfile.nname) == FAIL)
		  fail(fname, E_rename, Host.name, Batchfile.name,
		       Batchfile.nname, errmsg(errno));

		check_batchfile();
		return;
	    }
	}
    }
    if (One_shot && (Input_from & FLG_BATCHFILE))
      fail(fname, "%s%s: %s not found on a One-shot\n", Host.name,
	   Batchfile.name);

    return;
}


void
  update_batchfile()
{
    static char *fname = "update_batchfile: ";
    char *entry, *filename = NULL, *mesgid = NULL;
    struct stat batch_stat, log_stat;
    FILE *tfp;
    int fd, bytes_read = 0;
#ifdef HAVE_SELECT
    fd_set readfds;
    static struct timeval timeout = {0, 0};
#endif

    No_articles = 0;

    if (Reset_signaled && (Input_from & FLG_LOGFILE))
      log(LOG_INFO, fname, "%s%s: Resetting to use new logfile\n", Host.name);

    if (Debug)
      if (Input_from & FLG_LOGFILE)
	log(LOG_DEBUG, fname, "%sUpdating Batchfile from Logfile\n");
      else
	log(LOG_DEBUG, fname, "%sUpdating Batchfile from <stdin>\n");

    /* First we want to clean up the old batchfile */
    if ((Batchfile.fbp != NULL) && (Reset_signaled || Abort_signaled)) {

	if ((tfp = fopen(Batchfile.tmp, "w")) == NULL)
	  fail(fname, E_fopen, Host.name, Batchfile.tmp, "w", errmsg(errno));

	fd = fb_fileno(Batchfile.fbp);

	if (Article.filename != NULL) {
	    No_articles++;
#ifdef BNEWS
	    fprintf(tfp, "%s\t%s\t%d\n", Article.filename, Article.mesgid,
		    Article.count);
#else
	    fprintf(tfp, "%s %s %d\n", Article.filename, Article.mesgid,
		    Article.count);
#endif
	    close_article();
	}

	while ((entry = fb_readline(Batchfile.fbp, NULL)) != NULL) {
	    No_articles++;
	    if (fprintf(tfp, "%s\n", entry) == FAIL)
	      fail(fname, E_write, Host.name, Batchfile.tmp, errmsg(errno));
	}

	FCLOSE(tfp);
	close(fb_fileno(Batchfile.fbp));
	fb_close(Batchfile.fbp);
	Batchfile.fbp = NULL;
	Batchfile.offset = Batchfile.inode = 0;

	if (rename(Batchfile.tmp, Batchfile.nname) == FAIL)
	  fail(fname, E_rename, Host.name, Batchfile.tmp, Batchfile.nname,
	       errmsg(errno));
    }

    if ((tfp = fopen(Batchfile.nname, "a")) == NULL)
      fail(fname, E_fopen, Host.name, Batchfile.nname, "a", errmsg(errno));

    if (Article.filename != NULL) {
	No_articles++;
#ifdef BNEWS
	fprintf(tfp, "%s\t%s\t%d\n", Article.filename, Article.mesgid,
		Article.count);
#else
	fprintf(tfp, "%s %s %d\n", Article.filename, Article.mesgid,
		Article.count);
#endif
	close_article();
    }

    if (Input_from & FLG_LOGFILE) {

	if (Logfile.fbp != NULL) {
#ifdef LOOKUP_ARTICLE
	    Article.filename = strsave("/");
#endif
	    while ((entry = fb_readline(Logfile.fbp, NULL)) != NULL)
	      if (parse_entry(entry)) {
		  No_articles++;
#ifdef BNEWS
		  fprintf(tfp, "%s\t%s\n", Article.filename, Article.mesgid);
#else
		  fprintf(tfp, "%s %s\n", Article.filename, Article.mesgid);
#endif
	      }

	    if (fb_error(Logfile.fbp))
	      log(LOG_INFO, fname, E_read, Host.name,
		  Logfile.name, errmsg(errno));

#ifdef LOOKUP_ARTICLE
	    free(Article.filename);
#endif

	    Article.filename = Article.mesgid = NULL;

	    Logfile.offset = fb_tell(Logfile.fbp);
	    close(fb_fileno(Logfile.fbp));
	    fb_close(Logfile.fbp);
	    Logfile.fbp = NULL;
	}

	(void) fflush(tfp);

	if (ferror(tfp))
	  fail(fname, "%s%s: copy to batchfile.nntp failed: %s\n", Host.name,
	       errmsg(errno));

	FCLOSE(tfp);

	while ((fd = open(Logfile.name, O_RDONLY)) == FAIL)
	  check_sleep(Logfile.nap_time, CREATE_BATCH);

	Logfile.fbp = fb_fdopen(fd);

	if (fstat(fd, &log_stat) == FAIL)
	  fail(fname, E_fstat, Host.name, Logfile.name, errmsg(errno));
	else
	  if (Logfile.inode == log_stat.st_ino) {
	      if (fb_seek(Logfile.fbp, Logfile.offset, 0) == FAIL)
		log(LOG_WARNING, fname, E_fseek, Host.name, Logfile.name,
		    errmsg(errno));
	  } else
	    Logfile.inode = log_stat.st_ino;

    } else {				/* Input_from & FLG_STDIN */
      
      if ((Article.filename != NULL) && Abort_signaled) {
#ifdef BNEWS
	fprintf(tfp, "%s\t%s\n", Article.filename, Article.mesgid);
#else
	fprintf(tfp, "%s %s\n", Article.filename, Article.mesgid);
#endif
      } else {

	filename = Article.filename;
	mesgid = Article.mesgid;
      }

      while((entry = fb_readline(Stdin, NULL)) != NULL)
	if (parse_entry(entry)) {
	  No_articles++;
#ifdef BNEWS
	  fprintf(tfp, "%s\t%s\n", Article.filename, Article.mesgid);
#else
	  fprintf(tfp, "%s %s\n", Article.filename, Article.mesgid);
#endif
	}

      Article.filename = filename;
      Article.mesgid = mesgid;

      if (fb_error(Stdin) && (errno != READ_ERROR))
	log(LOG_INFO, fname, "%s%s: error reading stdin: %s\n", Host.name,
	    errmsg(errno));

      (void) fflush(tfp);

      if (ferror(tfp))
	fail(fname, "%s%s: copy to batchfile.nntp failed: %s\n", Host.name,
	     errmsg(errno));

      FCLOSE(tfp);

    }

    Batchfile.use = Batchfile.nntp_in_use = FALSE;

    if (stat(Batchfile.nname, &batch_stat) != FAIL)
      if (batch_stat.st_size == 0) {
	if (unlink(Batchfile.nname) == FAIL)
	  log(LOG_WARNING, fname, E_unlink, Host.name, Batchfile.nname,
	      errmsg(errno));
      } else {
	if (Batchfile.fbp == NULL) {
	  if ((fd = open(Batchfile.nname, O_RDONLY)) == FAIL)
	    fail(fname, E_fopen, Host.name, Batchfile.nname, "r",
		 errmsg(errno));

	  if (Debug && !Abort_signaled)
	    log(LOG_DEBUG, fname, "%s%s: Switching to Batchfile.nntp\n",
		Host.name);

	  Batchfile.fbp = fb_fdopen(fd);
	}
	Batchfile.use = Batchfile.nntp_in_use = TRUE;
      }

    if ((Input_from & FLG_STDIN) && fb_eof(Stdin) && !Abort_signaled) {
      log(LOG_INFO, fname, "%s%s: EOF on stdin, exiting\n", Host.name);
      Abort_signaled = TRUE;
    } else if (Reset_signaled || Abort_signaled)
      if (No_articles > 1)
	log(LOG_INFO, fname, "%s%s: Batchfile Updated, %d articles queued\n",
	    Host.name, No_articles);
      else
	log(LOG_INFO, fname, "%s%s: Batchfile Updated, No articles queued\n",
	    Host.name);

    Reset_signaled = FALSE;
    return;
}
