#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#ifdef HAVE_GETRUSAGE
#include <sys/time.h>
#include <sys/resource.h>
#else
#include <sys/param.h>
#include <sys/times.h>
#endif
#include "readline.h"
#include "nntplink.h"

extern Boolean Abort_signaled;
extern Boolean Debug;
extern int Input_from;
extern Boolean One_shot;
extern int Prog_pid;

extern char *E_rename;

extern void fail();
extern void log();
extern void write_link_datafile();

static int logged_stats = 0;

int Clear_batchfile = CLEAR_BATCHFILE;
Boolean Report_stats = TRUE;


void
  log_stats()
{
    static char *fname = "log_stats: ";
    float temp;
    long elapsed;

#ifdef HAVE_GETRUSAGE
    struct rusage self, kids;

    (void) getrusage(RUSAGE_SELF, &self);
    (void) getrusage(RUSAGE_CHILDREN, &kids);

    Time.end_user = (double)(self.ru_utime.tv_sec + kids.ru_utime.tv_sec +
			     self.ru_utime.tv_usec/1000000. +
			     kids.ru_utime.tv_usec/1000000.);

    Time.end_sys = (double)(self.ru_stime.tv_sec + kids.ru_stime.tv_sec +
			    self.ru_stime.tv_usec/1000000. +
			    kids.ru_stime.tv_usec/1000000.);
#else /* !HAVE_GETRUSAGE */
    struct tms cpu;

    (void) times(&cpu);

    Time.end_user = (double)(cpu.tms_utime + cpu.tms_cutime) / HZ;
    Time.end_sys  = (double)(cpu.tms_stime + cpu.tms_cstime) / HZ;
#endif	/* HAVE_GETRUSAGE */

    Time.end_real = time(NULL);

    if (Report_stats) {

	log(LOG_INFO, fname,
 "%s%s stats %lu offered %lu accepted %lu rejected %lu failed %lu connects\n",
	    Host.name, Stats.offered, Stats.accepted, Stats.rejected,
	    Stats.failed, Stats.connects);

	elapsed = Time.elapsed;
	Time.elapsed = 0;
	/* Only update Time.begin_real if connection is currently open */
	if (Time.begin_real) {
	  elapsed += Time.end_real - Time.begin_real;
	  Time.begin_real = Time.end_real;
	}

	log(LOG_INFO, fname,
	    "%s%s xmit user %.1f system %.1f elapsed %ld\n",
	    Host.name, (Time.end_user - Time.begin_user),
	    (Time.end_sys - Time.begin_sys), elapsed);

	Time.begin_user = Time.end_user;
	Time.begin_sys = Time.end_sys;
	Stats.offered = Stats.accepted = Stats.rejected =
	  Stats.failed = Stats.connects = 0;
    }

    if (!One_shot) {
	if (Abort_signaled)
	  write_link_datafile(-999);
	else
	  write_link_datafile(Prog_pid);

	if ((Input_from & FLG_BATCHFILE) &&
	    (++logged_stats >= Clear_batchfile)) {

	    logged_stats = 0;

	    if (!Batchfile.nntp_in_use && (Batchfile.fbp != NULL)) {
		Batchfile.nntp_in_use = TRUE;

		dlog(LOG_DEBUG, fname,
		     "%srenaming batchfile to batchfile.nntp\n");

		if (rename(Batchfile.name, Batchfile.nname) == FAIL)
		  fail(fname, E_rename, Host.name, Batchfile.name,
		       Batchfile.nname, errmsg(errno));
	    }
	}
    }
}
