#include "conf.h"
#include <fcntl.h>
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <errno.h>
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#ifdef USE_VARARGS
#include <varargs.h>
#endif
#include <values.h>
#include "readline.h"
#include "nntplink.h"


extern Boolean Debug;
extern FILE *Debugfp;
extern long Entry_sleep;
extern long Idle_time;
extern int Input_from;
extern Boolean Log_close;
extern Boolean One_shot;
extern int Prog_pid;
extern int Stdin_fd_flags;

extern void close_connection();
extern char *emalloc();
extern void log();
extern void log_stats();
extern void update_batchfile();
extern void write_link_datafile();

extern void exit();

void my_exit();

#ifdef USE_VARARGS
void
  log(va_alist)
va_dcl
{
    va_list ap;
    char *fname, *format;
    char *buf;
    int priority;

    va_start(ap);
    priority = va_arg(ap, int);
    fname = va_arg(ap, char *);
    format = va_arg(ap, char *);
    format += 2;

    if (Debug) {
	if (fputs(fname, Debugfp) == EOF) {
	    fprintf(stderr, "log: fputs failed - %s\n", errmsg(errno));
	    my_exit(FAIL);
	}
	if (vfprintf(Debugfp, format, ap) == EOF) {
	    fprintf(stderr, "log: vfprintf failed - %s\n", errmsg(errno));
	    my_exit(FAIL);
	}
	fflush(Debugfp);
    } else {
	buf = emalloc(1024);
	vsprintf(buf, format, ap);
	syslog(priority, "%s", buf);
	free(buf);
    }

    va_end(ap);
    return;
}

void
  fail(va_alist)
va_dcl
{
    va_list ap;
    char *fname, *format;
    char *buf;

    va_start(ap);
    fname = va_arg(ap, char *);
    format = va_arg(ap, char *);
    format += 2;

    if (Debug) {
	if (fputs(fname, Debugfp) == EOF) {
	    fprintf(stderr, "fail: fputs failed - %s\n", errmsg(errno));
	    my_exit(FAIL);
	}
	if (vfprintf(Debugfp, format, ap) == EOF) {
	    fprintf(stderr, "fail: vfprintf failed - %s\n", errmsg(errno));
	    my_exit(FAIL);
	}
	fflush(Debugfp);
    } else {
	buf = emalloc(1024);
	vsprintf(buf, format, ap);
	syslog(LOG_ERR, "%s", buf);
	free(buf);
    }
    va_end(ap);
    my_exit(FAIL);
}

#else /* !USE_VARARGS */

/*VARARGS*/
void
  log(priority, fname, format, x1, x2, x3, x4, x5, x6, x7, x8)
int priority;
char *fname;
char *format, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{
    if (Debug) {

	if (fprintf(Debugfp, format, fname, x1, x2, x3, x4, x5, x6, x7, x8) == EOF) {
	    fprintf(stderr, "log: fprintf failed - %s\n", errmsg(errno));
	    my_exit(FAIL);
	}
	fflush(Debugfp);

    } else
      syslog(priority, format, "", x1, x2, x3, x4, x5, x6, x7, x8);

    return;
}


/*VARARGS*/
void
  fail(fname, format, x1, x2, x3, x4, x5, x6, x7, x8)
char *fname;
char *format, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{

    log(LOG_ERR, fname, format, x1, x2, x3, x4, x5, x6, x7, x8);

    my_exit(FAIL);
}
#endif /* !USE_VARARGS */


void
  abort_nntplink()
{
    static char *fname = "abort_nntplink: ";

    dlog(LOG_DEBUG, fname, "%sexiting\n");

    if (!(Input_from & FLG_BATCHFILE) && !One_shot)
      update_batchfile();

    if (Host.connected)
      close_connection(!SEND_QUIT_MSG);
    else if (!One_shot)
      write_link_datafile(-999);

    if (!Log_close)
      log_stats();

    my_exit(0);
}


void
my_exit(status)
int status;
{
  if (Input_from & FLG_STDIN)
    fcntl(fb_fileno(Stdin), F_SETFL, Stdin_fd_flags);
  exit(status);
}


char *
itoa(num)
     int num;
{
    static char *numbers = "0123456789";
    static char *neg = "-";
    register char *bp, *negative = neg + 1;
    char *buf = emalloc(MAXDIGS);

    if (num == 0)
      return "0";
    else if (num > MAXINT)
      return NULL;
    
    *(bp = buf + MAXDIGS) = '\0';

    if ((long)num < 0) {
	negative--;
	num = -num;
    }

    do {
	*--bp = *(numbers + (num % 10));
	num /= 10;
    } while (num);

    if (*negative)
      *--bp = *negative;

    return bp;
}
