/*LINTLIBRARY*/

#include "conf.h"
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include "strfuns.h"

#undef str2save
extern char *str2save();

extern void fail();
extern char *itoa();

char *
  errmsg(code)
int code;
{
    extern int sys_nerr;
    extern char *sys_errlist[];
    static char *e;

    if (code > sys_nerr || code < 0) {
	e = str2save("Error ", itoa(code));
	return e;
    } else
      return sys_errlist[code];
}


/* malloc that doesn't return NULL */
char *
  emalloc(n)
unsigned n;
{
    static char *fname = "emalloc: ";
    char *cp = (char *)malloc(n);

    if (n == NULL)
	fail(fname, "%smalloc(%d) failed: %s", n, errmsg(errno));

    return cp;
}


/*
 * These are macros found in strfuns.h
 */

#undef strsave
#undef str2save
#undef str3save

/*
 * !! saving the lengths and using memcpy may be somewhat faster in the
 * following.
 *
 * Makes a copy of a string in malloc'ed storage and return a pointer to it.
 */
char *
  strsave(s)
char *s;
{
    return strcpy(emalloc((unsigned)(strlen(s) + 1)), s);
}
					

/*
 * Concatenate the two strings in malloc'ed storage and return a
 * pointer to the result.
 */
char *
  str2save(s1, s2)
char *s1, *s2;
{
    int len = strlen(s1) + strlen(s2) + 1;

    return strcat(strcpy(emalloc((unsigned)len), s1), s2);
}

/*
 * Concatenate the three strings in malloc'ed storage and return a
 * pointer to the result.
 */
char *
  str3save(s1, s2, s3)
char *s1, *s2, *s3;
{
    int len = strlen(s1) + strlen(s2) + strlen(s3) + 1;

    return strcat(strcat(strcpy(emalloc((unsigned)len), s1), s2), s3);
}


/*
 * Copyright (c) 1987 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific written prior permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

#ifdef NEED_STRCASECMP

#ifndef u_char
#define u_char  unsigned char
#endif

/*
 * This array is designed for mapping upper and lower case letter
 * together for a case independent comparison.  The mappings are
 * based upon ascii character sequences.
 */
static u_char charmap[] = {
	'\000', '\001', '\002', '\003', '\004', '\005', '\006', '\007',
	'\010', '\011', '\012', '\013', '\014', '\015', '\016', '\017',
	'\020', '\021', '\022', '\023', '\024', '\025', '\026', '\027',
	'\030', '\031', '\032', '\033', '\034', '\035', '\036', '\037',
	'\040', '\041', '\042', '\043', '\044', '\045', '\046', '\047',
	'\050', '\051', '\052', '\053', '\054', '\055', '\056', '\057',
	'\060', '\061', '\062', '\063', '\064', '\065', '\066', '\067',
	'\070', '\071', '\072', '\073', '\074', '\075', '\076', '\077',
	'\100', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
	'\150', '\151', '\152', '\153', '\154', '\155', '\156', '\157',
	'\160', '\161', '\162', '\163', '\164', '\165', '\166', '\167',
	'\170', '\171', '\172', '\133', '\134', '\135', '\136', '\137',
	'\140', '\141', '\142', '\143', '\144', '\145', '\146', '\147',
	'\150', '\151', '\152', '\153', '\154', '\155', '\156', '\157',
	'\160', '\161', '\162', '\163', '\164', '\165', '\166', '\167',
	'\170', '\171', '\172', '\173', '\174', '\175', '\176', '\177',
	'\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
	'\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
	'\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
	'\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
	'\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
	'\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
	'\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
	'\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
	'\300', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
	'\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
	'\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
	'\370', '\371', '\372', '\333', '\334', '\335', '\336', '\337',
	'\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
	'\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
	'\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
	'\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};

strcasecmp(s1, s2)
	char *s1, *s2;
{
	register u_char	*cm = charmap,
			*us1 = (u_char *)s1,
			*us2 = (u_char *)s2;

	while (cm[*us1] == cm[*us2++])
		if (*us1++ == '\0')
			return 0;
	return(cm[*us1] - cm[*--us2]);
}

strncasecmp(s1, s2, n)
	char *s1, *s2;
	register int n;
{
	register u_char	*cm = charmap,
			*us1 = (u_char *)s1,
			*us2 = (u_char *)s2;

	while (--n >= 0 && cm[*us1] == cm[*us2++])
		if (*us1++ == '\0')
			return 0;
	return(n < 0 ? 0 : cm[*us1] - cm[*--us2]);
}
#endif /* NEED_STRCASECMP */
