/* $Id: dfile.c,v 1.1 1993/03/28 21:42:52 alden Exp $ */

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include "conf.h"
#include "readline.h"

char *sys_errlist[];
extern char *optarg;
extern int optind, opterr;

  main(argc,argv)
int argc;
char **argv;
{
    static char *fname = "main: ";
    char *progname = argv[0];
    char *line[10], *datafile;
    FileBuf *link_fbp;
    FILE *link_fp;
    int progpid,
        link_fd,
        i=0,
        override=0,
        errflg=0,
        c;
    double old_version, new_version = 3.0;
    double atof();
    long success_time, report_time;
    off_t batch_offset, log_offset;
    ino_t long batch_inode, log_inode;

    progpid = -999;
    batch_offset = (off_t)0;
    batch_inode = (ino_t)0;
    log_offset = (off_t)0;
    log_inode = (ino_t)0;
    success_time = 0L;
    report_time = 0L;

    opterr = 0;
    while ((c = getopt(argc, argv, "on:")) != EOF)
      switch(c) {
	case 'o':
	  override = 1;
	  break;
	case 'n':
	  new_version = (double)(((int)(atof(optarg) * 10)) / 10.0);
	  break;
	default:
	  errflg++;
      }

    if (optind < argc)
      datafile = argv[optind];
    else
      errflg++;

    if (new_version != 2.2 && new_version != 2.9 && new_version != 3.0)
      errflg++;

    if (errflg) {
	fprintf(stderr, "usage: %s [-o] [-n new_version] datafile\n",
		progname);
	fprintf(stderr,
		"%s: acceptable new_version values are: 2.2 2.9 3.0\n",
		progname);
	exit(-1);
    }

    if ((link_fd = open(datafile, O_RDONLY)) == FAIL) {
	fprintf("%sopen(%s, \"r\"): %s\n", fname, datafile,
		sys_errlist[errno]);
	exit(-1);
    }

    link_fbp = fb_fdopen(link_fd);

    while (((line[i] = fb_readline(link_fbp)) != NULL) && (++i < 10))
      ;

    switch(i) {
      case 5:
	if (new_version == 2.2) {
	    fprintf(stderr, "%s: old version and new version are the same\n",
		    progname);
	    exit(-1);
	}

	old_version = 2.2;
	log_inode = (ino_t)atol(line[0]);
	log_offset = (off_t)atol(line[1]);
	success_time = atol(line[2]);
	report_time = atol(line[3]);
	progpid = atoi(line[4]);

	printf("Datafile version: %.1f\n", old_version);
	printf("     program pid: %d\n", progpid);
	printf("   logfile inode: %lu\n", (unsigned long)log_inode);
	printf("  logfile offset: %ld\n", (long)log_offset);
	printf("    last success: %ld\n", success_time);
	printf("     last report: %ld\n", report_time);
	break;


      case 7:
	if (new_version == 2.9) {
	    fprintf(stderr, "%s: old version and new version are the same\n",
		    progname);
	    exit(-1);
	}
	old_version = 2.9;

	if ((progpid = atoi(line[0])) != -999)
	  if (!override) {
	      fprintf(stderr,
		      "%s: nntplink is running - cannot update datafile\n",
		      progname);
	      exit(-1);
	  } else
	    fprintf(stderr,
		    "%s: nntplink running - overriding datafile (dangerous)\n",
		    progname);

	batch_inode = (ino_t)atol(line[1]);
	batch_offset = (off_t)atol(line[2]);
	log_inode = (ino_t)atol(line[3]);
	log_offset = (off_t)atol(line[4]);
	success_time = atol(line[5]);
	report_time = atol(line[6]);

	printf("Datafile version: %.1f\n", old_version);
	printf("     program pid: %d\n", progpid);
	printf(" batchfile inode: %lu\n", (unsigned long)batch_inode);
	printf("batchfile offset: %ld\n", (long)batch_offset);
	printf("   logfile inode: %lu\n", (unsigned long)log_inode);
	printf("  logfile offset: %ld\n", (long)log_offset);
	printf("    last success: %ld\n", success_time);
	printf("     last report: %ld\n", report_time);
	break;


      case 8:
	if ((progpid = atoi(line[0])) != -999)
	  if (!override) {
	      fprintf(stderr,
		      "%s: nntplink is running - cannot update datafile\n",
		      progname);
	      exit(-1);
	  } else
	    fprintf(stderr,
		    "%s: nntplink running - overriding datafile (dangerous)\n",
		    progname);

	old_version = (double)(((int)(atof(line[1]) * 10)) / 10.0);
	if (new_version == old_version) {
	    fprintf(stderr, "%s: old version and new version are the same\n",
		    progname);
	    exit(-1);
	}

	batch_inode = (ino_t)atol(line[2]);
	batch_offset = (off_t)atol(line[3]);
	log_inode = (ino_t)atol(line[4]);
	log_offset = (off_t)atol(line[5]);
	success_time = atol(line[6]);
	report_time = atol(line[7]);

	printf("Datafile version: %.1f\n", old_version);
	printf("     program pid: %d\n", progpid);
	printf(" batchfile inode: %lu\n", (unsigned long)batch_inode);
	printf("batchfile offset: %ld\n", (long)batch_offset);
	printf("   logfile inode: %lu\n", (unsigned long)log_inode);
	printf("  logfile offset: %ld\n", (long)log_offset);
	printf("    last success: %ld\n", success_time);
	printf("     last report: %ld\n", report_time);
	break;

      default:
	fprintf(stderr, "%s: invalid data file format\n", progname);
	exit(-1);
    }

    close(link_fd);
    fb_close(link_fbp);

    printf("\n");
    printf("Hit return to continue or <break> to abort\n");
    (void) getchar();

    if ((link_fp = fopen(datafile, "w")) == NULL) {
	fprintf("%sfopen(%s, \"w\"): %s\n", fname, datafile,
		sys_errlist[errno]);
	exit(-1);
    }

    if (new_version == 2.2) {

	fprintf(link_fp, "%lu\n", (unsigned long)log_inode);
	fprintf(link_fp, "%ld\n", (long)log_offset);
	fprintf(link_fp, "%ld\n", success_time);
	fprintf(link_fp, "%ld\n", report_time);
	fprintf(link_fp, "%d\n", progpid);

    } else if (new_version == 2.9) {

	fprintf(link_fp, "%d\n", progpid);
	fprintf(link_fp, "%lu\n", batch_inode);
	fprintf(link_fp, "%ld\n", batch_offset);
	fprintf(link_fp, "%lu\n", log_inode);
	fprintf(link_fp, "%ld\n", log_offset);
	fprintf(link_fp, "%ld\n", success_time);
	fprintf(link_fp, "%ld\n", report_time);

    } else if (new_version = 3.0) {

	fprintf(link_fp, "%d\n", progpid);
	fprintf(link_fp, "%.1f\n", new_version);
	fprintf(link_fp, "%lu\n", batch_inode);
	fprintf(link_fp, "%ld\n", batch_offset);
	fprintf(link_fp, "%lu\n", log_inode);
	fprintf(link_fp, "%ld\n", log_offset);
	fprintf(link_fp, "%ld\n", success_time);
	fprintf(link_fp, "%ld\n", report_time);

    }
    fclose(link_fp);

    printf("%s: Done converting %s from version %.1f to version %.1f\n",
	   progname, datafile, old_version, new_version);

    exit(0);
}
