/**
 ** $Id: nntplink.h,v 1.3 1993/04/17 23:06:44 alden Exp $
 **
 ** $Log: nntplink.h,v $
 ** Revision 1.3  1993/04/17  23:06:44  alden
 ** Added Spool Directory to Batchfile struct
 **
 ** Revision 1.2  1993/04/16  12:52:57  alden
 ** Fixed headers
 **
 ** Revision 1.1  1993/03/28  19:37:46  alden
 ** Initial revision
 **
 **
 **/
typedef struct {
    char *name;			/* batchfile name for this host */
    char *nname;		/* batchfile.nntp for this host */
    char *tmp;			/* batchfile.tmp for this host */
    char *dir;			/* Spool directory for batchfile */
    ino_t inode;		/* inode of the current batchfile */
    off_t offset;		/* offset into current batchfile */
    FileBuf *fbp;		/* storage for readline() */
    long nap_time;		/* time to sleep between batchfile checks */
    Boolean use;		/* should we use batchfile? */
    Boolean nntp_in_use;	/* are we using batchfile.nntp? */
} Bfile_struct;

extern Bfile_struct Batchfile;

typedef struct {
    char *name;			/* current logfile */
    ino_t inode;		/* inode of the current logfile */
    off_t offset;		/* offset into current logfile */
    FileBuf *fbp;		/* storage for readline() */
    long nap_time;		/* time to sleep between logfile checks */
} Lfile_struct;

extern Lfile_struct Logfile;

extern FileBuf *Stdin;		/* fbp used by readline() */

typedef struct {
    char *name;			/* FQDN of remote host */
    char *sysname;		/* sysname of remote host */
    char *datafile;		/* datafile for remote host */
    char *failfile;		/* file which we store failed articles in */
    char *filename;		/* current file (batchfile or logfile) */
    int transport;		/* transport method for remote host */
    Boolean connected;		/* true iff connection open to remote host */
} Host_struct;

extern Host_struct Host;

typedef struct {
    char *filename;		/* filename for this article */
    char *mesgid;		/* mesgid for this argicle */
    FileBuf *fbp;		/* storage for readline() */
    long timeid;		/* timeid for this article */
    int count;			/* # of times current article has failed */
    char *err;			/* last err we got after attempting to send */
} Art_struct;

extern Art_struct Article;

typedef struct {
    unsigned long connects;
    unsigned long offered;
    unsigned long accepted;
    unsigned long rejected;
    unsigned long failed;
    unsigned long since_close;
} Stats_struct;

extern Stats_struct Stats;

typedef struct {
    long end_real;
    double end_user;
    double end_sys;
    long begin_real;
    long elapsed;
    double begin_user;
    double begin_sys;
} Time_struct;

extern Time_struct Time;
