/**
 ** $Id: postconf.h,v 1.4 1993/05/17 15:07:14 root Exp $
 **
 ** This file also contains a lot of assumptions about what features
 ** are available on the local system - if something is not working
 ** to your liking, look them over carefully.
 **
 **
 ** $Log: postconf.h,v $
 ** Revision 1.4  1993/05/17  15:07:14  root
 ** Added values for entry_type (in parse_entry() )
 **
 ** Revision 1.3  1993/05/12  14:40:42  alden
 ** If we don't have <values.h>, then try to fake it
 **
 ** Revision 1.2  1993/05/12  12:52:55  alden
 ** Added missing end-of-comment string
 **
 ** Revision 1.1  1993/05/05  00:05:13  alden
 ** Initial revision
 **
 **
 **/

#define Boolean	char

#ifndef HAVE_STRCHR
#define strchr		index
#define strrchr		rindex
#endif

#ifndef HAVE_MEMCPY
#define memcpy(a,b,c)    bcopy(b,a,c)
#endif

#define	MAXDIGS		11

#define USE_KEEPALIVES

#define fb_error(a)	fb_err(a)

#define READ_TIMEOUT	300	/** seconds to read timeout in read_reply() **/

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

#define CREATE_BATCH	TRUE
#define DONT_CREATE_BATCH	FALSE

#define DO_LOG_ERROR	TRUE
#define DONT_LOG_ERROR	FALSE

#define SEND_QUIT_MSG	TRUE
#define DONT_SEND_QUIT_MSG	FALSE

#define WANT_FILENAME	FALSE

#define FAIL		(-1)
#define MATCH		0

#define NOHOST		(FAIL-1)
#define NOSERVICE	(FAIL-2)

#ifndef NULL
#define NULL		0
#endif

#define NEVER		(-1)

#define Batchfile_entry	0
#define Logfile_entry	1
#define Stdin_entry	2

#define FCLOSE(fp)	{ (void) fclose(fp); (fp) = NULL; }
#define CLOSE(fd)	{ (void) close(fd); (fd) = FAIL; }

#define FREE(mp)	{ (void) free(mp); (mp) = NULL; }

#ifdef DBZ		/** If you use DBZ, then you need DBM as well. **/
#ifndef DBM
#define DBM
#endif /** DBM **/
#endif /** DBZ **/

/**
 ** <dbm.h> stupidly defines NULL, which is why the following
 ** brain death is necessary.
 **/

#ifdef DBM
# ifdef DBZ
#  include <dbz.h>
# else /** DBZ **/
#  undef NULL
#  include <dbm.h>
#  undef NULL
#  define NULL	0
# endif /** DBZ **/
#else
# ifdef NDBM
#  include <ndbm.h>
# endif /** NDBM **/
#endif /** DBM **/


#define dlog	if (!Debug) ; else log

#ifdef HAVE_SYS_TWG_CONFIG_H
#include <sys/twg_config.h>
#endif

extern char *errmsg();

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>

#if defined(HAVE_SYS_TIME_H)
#include <sys/time.h>
#else defined(HAVE_SYS_TIMES_H)
#if defined(HAVE_SYS_TIMES_H)
#include <sys/times.h>
#endif
#endif

#if defined(STDC_HEADERS) || defined(HAVE_STDLIB_H)
#include <stdlib.h>
#include <string.h>
#else
extern char **malloc();
extern int errno;
extern int exit();
#include <strings.h>
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_SYSLOG_H
#include <syslog.h>
#else
#include "fsyslog.h"
#endif

/**
 ** 4.2 BSD compatibility
 **/
#ifndef FD_SETSIZE
#define FD_SET(n, p)    ((p)->fds_bits[0] |=  (1<<(n)))
#define FD_CLR(n, p)    ((p)->fds_bits[0] &= ~(1<<(n)))
#define FD_ISSET(n, p)  ((p)->fds_bits[0] &   (1<<(n)))
#define FD_ZERO(p)      ((p)->fds_bits[0]  =  0)
#endif

#if defined(DIRENT) || defined(_POSIX_VERSION)
#include <dirent.h>
#define NLENGTH(dirent) (strlen((dirent)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define dirent direct
#define NLENGTH(dirent) ((dirent)->d_namlen)
#ifdef SYSNDIR
#include <sys/ndir.h>
#endif /* SYSNDIR */
#ifdef SYSDIR
#include <sys/dir.h>
#endif /* SYSDIR */
#ifdef NDIR
#include <ndir.h>
#endif /* NDIR */
#endif /* not (DIRENT or _POSIX_VERSION) */

#define basename(s1) \
  (strrchr(s1, '/') + 1)

/* If we don't have <values.h>, then try to fake it */

#ifndef HAVE_VALUES_H
#define BITSPERBYTE 8
#define BITS(type)	(BITSPERBYTE * (int)sizeof(type))

/* short, regular and long ints with only the high-order bit turned on */
#define HIBITS  ((short)(1 << BITS(short) - 1))
#define HIBITI  (1 << BITS(int) - 1)
#define HIBITL  (1L << BITS(long) - 1)

/* largest short, regular and long int */
#define MAXSHORT        ((short)~HIBITS)
#define MAXINT  (~HIBITI)
#define MAXLONG (~HIBITL)
#endif
