/**
 ** Routines that deal with an article.
 ** 
 ** $Id: article.c,v 1.6 1993/05/17 15:03:27 root Exp $
 **
 ** $Log: article.c,v $
 ** Revision 1.6  1993/05/17  15:03:27  root
 ** Modified parse_entry() call to include type of entry
 **
 ** Revision 1.5  1993/05/12  13:06:03  alden
 ** Added some def's to make compilers happyier
 **
 ** Revision 1.4  1993/05/10  13:48:34  alden
 ** Fixed bug in get_next_art() which ignored return status of parse_entry()
 **
 ** Revision 1.3  1993/05/05  18:39:50  root
 ** Modified get_next_art() so it NULL's Batchfile.fbp if it closes it
 **
 ** Revision 1.2  1993/05/04  23:37:00  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:12  alden
 ** Initial revision
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "strfuns.h"

#include <fcntl.h>
#include <sys/stat.h>

extern char *E_fdopen;
extern char *E_open;

extern Boolean Abort_signaled;
extern Boolean Debug;
extern long Dtablesize;
extern long Entry_sleep;
extern long Idle_time;
extern int Input_from;
extern Boolean Log_close;
extern Boolean One_shot;
extern Boolean Save_fails;

extern char *E_fopen;
extern char *E_unlink;

#ifdef LOOKUP_ARTICLE
extern void close_history();
extern char *get_history_entry();
#endif

extern void check_sleep();
extern void close_article();
extern void close_connection();
extern void fail();
extern void log();
extern void log_stats();
extern void my_exit();
extern Boolean parse_entry();

Boolean
  get_next_art()
{
  static char *fname = "get_next_art: ";
  FILE *tmpfp;
  struct stat batch_stat;
  char *entry;
  int already = 0;
  
  if (Article.count >= MAX_ART_FAILS) {
    
    if (Save_fails) {
      
#ifdef LOOKUP_ARTICLE
      Article.filename = strsave("/");
      if (Article.err != NULL)
	log(LOG_NOTICE, fname, "%s%s: article %s failed(saved): %s\n",
	    Host.name, Article.mesgid, Article.err);
      else
	log(LOG_NOTICE, fname, "%s%s: article %s failed(saved)\n",
	    Host.name, Article.mesgid);
#else
      if (Article.err != NULL)
	log(LOG_NOTICE, fname, "%s%s: article %s failed(saved): %s\n",
	    Host.name, Article.filename, Article.err);
      else
	log(LOG_NOTICE, fname, "%s%s: article %s failed(saved)\n",
	    Host.name, Article.filename);
#endif
      
      if ((tmpfp = fopen(Host.failfile, "a")) == NULL)
	log(LOG_WARNING, fname, E_fopen, Host.name, Host.failfile, "a",
	    errmsg(errno));
      else {
#ifdef BNEWS
	fprintf(tmpfp, "%s\t%s\n", Article.filename, Article.mesgid);
#else
	fprintf(tmpfp, "%s %s\n", Article.filename, Article.mesgid);
#endif
	FCLOSE(tmpfp);
      }
    } else
      if (Article.err != NULL)
	log(LOG_NOTICE, fname, "%s%s: article %s failed(junked): %s\n",
	    Host.name, Article.filename, Article.err);
      else
	log(LOG_NOTICE, fname, "%s%s: article %s failed(junked)\n",
	    Host.name, Article.filename);
    
    close_article();
  }
  
  if (Article.mesgid != NULL || Article.filename != NULL)
    return TRUE;
  
  if (Batchfile.use)
    for (;;) {
      if (Debug)
	if (Batchfile.nntp_in_use)
	  log(LOG_DEBUG, fname, "%sretrieving article from %s: ",
	      basename(Batchfile.nname));
	else
	  log(LOG_DEBUG, fname, "%sretrieving article from %s: ",
	      basename(Batchfile.name));
      
      Batchfile.offset = fb_tell(Batchfile.fbp);
      
      if (!Batchfile.nntp_in_use) {
	if (!One_shot) {
	  dlog(LOG_DEBUG, "", "%swaiting for entry: ");
	  while (((entry = fb_readline(Batchfile.fbp, NULL)) == NULL)
		 && fb_eof(Batchfile.fbp) && !Batchfile.nntp_in_use)
	    check_sleep(Entry_sleep, FALSE);
	  
	  if (entry == NULL) {
	    if (fb_error(Batchfile.fbp))
	      log(LOG_WARNING, fname,
		  "%s%s: error reading %s: %s\n", Host.name,
		  Batchfile.name, errmsg(errno));
	    return FALSE;
	  }
	} else
	  if ((entry = fb_readline(Batchfile.fbp, NULL)) == NULL) {
	    if (Debug)
	      if (fb_eof(Batchfile.fbp))
		log(LOG_DEBUG, "", "%s%s at EOF - removing and exiting\n",
		    basename(Batchfile.name));
	      else
		log(LOG_DEBUG, "", "%serror reading %s: %s\n",
		    basename(Batchfile.name), errmsg(errno));
	    close(fb_fileno(Batchfile.fbp));
	    fb_close(Batchfile.fbp);
	    Batchfile.fbp = NULL;
	    Batchfile.inode = Batchfile.offset = 0;
	    if (unlink(Batchfile.name) == FAIL)
	      log(LOG_WARNING, fname, E_unlink, Host.name,
		  Batchfile.name, errmsg(errno));
	    if (Host.connected) {
	      close_connection(DONT_SEND_QUIT_MSG, FALSE);
	      if (!Log_close)
		log_stats();
	    } else
	      log_stats();
	    
	    my_exit(0);
	  }
      } else {
	
	while(((entry = fb_readline(Batchfile.fbp, NULL)) == NULL) &&
	      fb_eof(Batchfile.fbp)) {
	  if (!(Input_from & FLG_BATCHFILE) ||
	      (stat(Batchfile.name, &batch_stat) != FAIL)) {
	    
	    dlog(LOG_DEBUG, "", "%s%s at EOF - removing\n",
		 basename(Batchfile.nname));
	    
	    close(fb_fileno(Batchfile.fbp));
	    Batchfile.inode = Batchfile.offset = 0;
	    fb_close(Batchfile.fbp);
	    Batchfile.fbp = NULL;
	    Batchfile.nntp_in_use = FALSE;
	    
	    if (unlink(Batchfile.nname) == FAIL)
	      log(LOG_WARNING, fname, E_unlink, Host.name,
		  Batchfile.nname, errmsg(errno));
	    
	    return FALSE;
	  }
	  
	  if (Debug && !already++)
	    log(LOG_DEBUG, "", "%s%s at EOF: ", basename(Batchfile.nname));
	  
	  check_sleep(Entry_sleep, FALSE);
	}
	
	if (fb_error(Batchfile.fbp))
	  fail(fname, "%s%s: error reading %s: %s\n", Host.name,
	       Batchfile.nname, errmsg(errno));
	
      }
      dlog(LOG_DEBUG, "", "%s\nGot it: %s\n", entry);
      if (parse_entry(entry, Batchfile_entry))
	return TRUE;
      else
	dlog(LOG_DEBUG, "", "%sbad entry - skipping\n");
    }
  
  if (Input_from & FLG_LOGFILE) {
    
    dlog(LOG_DEBUG, fname, "%sretrieving next article from %s\n",
	 basename(Logfile.name));
    
    if (!One_shot) {
      dlog(LOG_DEBUG, fname, "%swaiting for entry: ");
      for (;;) {
	while (((entry = fb_readline(Logfile.fbp, NULL)) == NULL) &&
	       fb_eof(Logfile.fbp))
	  if (Batchfile.nntp_in_use)
	    return FALSE;
	  else
	    check_sleep(Entry_sleep, FALSE);
	
	if (entry == NULL) {
	  log(LOG_WARNING, fname,
	      "%s%s: error reading %s: %s\n", Host.name,
	      Logfile.name, errmsg(errno));
	  return FALSE;
	} else if (parse_entry(entry, Logfile_entry)) {
	  break;
	}
      }
    } else {
      while (((entry = fb_readline(Logfile.fbp, NULL)) != NULL) &&
	     (!parse_entry(entry, Logfile_entry)))
	;
      
      if (entry == NULL) {
	if (Debug)
	  if (fb_eof(Logfile.fbp))
	    log(LOG_DEBUG, fname, "%s%s at EOF - exiting\n",
		basename(Logfile.name));
	  else
	    log(LOG_DEBUG, fname, "%serror reading %s: %s\n",
		basename(Logfile.name),	errmsg(errno));
	Abort_signaled = TRUE;
	return FALSE;
      }
    }
    
  } else if (Input_from & FLG_STDIN) {
    
    dlog(LOG_DEBUG, fname, "%swaiting for entry: ");
    for (;;) {
      while (((entry = fb_readline(Stdin, NULL)) == NULL) &&
#ifdef _POSIX_VERSION
	     (errno == EAGAIN)) {
#else
	(errno == EWOULDBLOCK)) {
#endif
	       errno = 0;
	       if (Batchfile.nntp_in_use)
		 return FALSE;
	       else
		 check_sleep(Entry_sleep, FALSE);
	     }
      
      if (entry == NULL) {
	if (fb_eof(Stdin))
	  log(LOG_DEBUG, fname, "%s%s: EOF on stdin, exiting\n", Host.name);
	else
	  log(LOG_DEBUG, fname, "%serror reading stdin: %s\n",
	      errmsg(errno));
	Abort_signaled = TRUE;
	return FALSE;
      } else if (parse_entry(entry, Stdin_entry)) {
	break;
      }
    }
  } else
    fail(fname, "%s%s: Input_from has invalid value - exiting\n",
	 Host.name);
  
  dlog(LOG_DEBUG, "", "%sGot it\n");
  return TRUE;
}


void
  close_article()
{
  Article.filename = NULL;
  Article.mesgid = NULL;
  
  if (Article.fbp != NULL) {
    close(fb_fileno(Article.fbp));
    fb_close(Article.fbp);
    Article.fbp = NULL;
  }
  
  if (Article.err != NULL)
    FREE(Article.err);
  
  Article.count = 0;
  
  return;
}


Boolean
  open_article()
{
  static char *fname = "open_article: ";
  int fd;
  
  if (Article.fbp != NULL)
    return TRUE;
  
#ifdef LOOKUP_ARTICLE
  if (Article.filename == NULL) {
    
    Article.filename = get_history_entry(Article.mesgid, WANT_FILENAME);
    
    /*
     * If we failed then we want to close the history file and retry
     * since it's possible that the history file got aged.
     */
    if (Article.filename == NULL) {
      close_history();
      Article.filename = get_history_entry(Article.mesgid,
					   WANT_FILENAME);
      if (Article.filename == NULL) {
	log(LOG_INFO, fname, "%s%s: Filename not found for %s\n",
	    Host.name, Article.mesgid);
	return FALSE;
      }
    }
    
    dlog(LOG_DEBUG, fname, "%shistory returns %s\n", Article.filename);
  }
#endif /* LOOKUP_ARTICLE */
  
  if ((fd = open(Article.filename, O_RDONLY)) == FAIL) {
    if (errno != ENOENT)
      log(LOG_WARNING, fname, E_open, Host.name, Article.filename, "r",
	  errmsg(errno));
    else
      dlog(LOG_DEBUG, fname, "%sArticle(%s) not found\n",
	   Article.filename);
    
    return FALSE;
  }
  
  Article.fbp = fb_fdopen(fd);
  
  return TRUE;
}
