/**
 ** Routine that sends "IHAVE <mesgid>" to remote host.
 **
 ** $Id: ihave.c,v 1.2 1993/05/04 23:38:16 alden Exp $
 **
 ** $Log: ihave.c,v $
 ** Revision 1.2  1993/05/04  23:38:16  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:20  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern void close_article();
extern char *converse();
extern void log();
extern Boolean open_article();
extern Boolean send_command();

extern int Xreplic;

static char *tmesgid = NULL;

extern void xmitauth();

char *
  send_ihave_msg(resp)
int *resp;
{
  static char *fname = "send_ihave_msg: ";
  
  Boolean done = FALSE;
  char *reply;
  char *line, *id, *end_id, *msgid = "message-id:";
  
  if (Article.mesgid == NULL) {
    
    if (!open_article()) {
      *resp = ERR_NOFILE_CONT;
      return NULL;
    }
    
    while(!done && ((line = fb_readline(Article.fbp, NULL)) != NULL))
      switch(*line) {
      case '\n':		/* EOH, we failed */
	done = TRUE;
	break;
      case 'M':
      case 'm':
	if ((strchr(line, ':') == NULL) ||
	    (strncasecmp(line, msgid, 11) != 0) ||
	    ((id = strchr(line, '<')) == NULL) ||
	    ((end_id = strchr(line, '>')) == NULL))
	  continue;		/* not the message-id: header */
	
	*++end_id = '\0';
	if (tmesgid != NULL)
	  FREE(tmesgid);
	tmesgid = strsave(id);
	Article.mesgid = tmesgid;
	done = TRUE;
	break;
      }
    
    if (fb_error(Article.fbp))
      log(LOG_INFO, fname, "%s%s: error reading %s: %s\n", Host.name,
	  Article.filename, errmsg(errno));
    
    (void)fb_seek(Article.fbp, 0L, 0);
    
    if (Article.mesgid == NULL) {
      log(LOG_INFO, fname, "%s%s: Message-id missing from %s!\n",
	  Host.name, Article.filename);
      close_article();
      *resp = ERR_NOMSGID;
      return NULL;
    }
  }
  
  Stats.offered++;
  Stats.since_close++;
  
  do {
    done = TRUE;
    
    line = str2save(Xreplic? "XREPLIC ": "IHAVE ", Article.mesgid);
    
    reply = converse(line, resp);
    FREE(line);
    
    if (*resp == FAIL)
      return NULL;
    
    switch(*resp) {
      
    case CONT_XFER:
      Stats.accepted++;
      
      if (!open_article())
	if (send_command(".", DO_LOG_ERROR))
	  *resp = ERR_NOFILE;
	else
	  *resp = ERR_UNKNOWN;
      
      return NULL;
      /*NOTREACHED*/
      break;
      
    case ERR_GOTIT:
      Stats.rejected++;
      break;
      
    case ERR_NOAUTH:
      xmitauth(Host.name);
      done = FALSE;
      break;
      
    default:
      break;
    }
  } while (!done);
  
  return reply;
}
