/**
 ** Miscellaneous routines.
 **
 ** $Id: misc.c,v 1.7 1993/05/12 14:16:27 alden Exp $
 **
 ** $Log: misc.c,v $
 ** Revision 1.7  1993/05/12  14:16:27  alden
 ** Added check for HAVE_VALUES_H
 **
 ** Revision 1.6  1993/05/04  23:38:24  alden
 ** Cleaned up tabs
 **
 ** Revision 1.5  1993/05/04  20:42:37  alden
 ** Modified abort_nntplink to call update_batchfile() unless you're input'ing
 **     from BATCHFILE
 **
 ** Revision 1.4  1993/04/28  22:23:33  alden
 ** Removed an (unneeded) definition for Entry_sleep
 **
 ** Revision 1.3  1993/04/20  00:32:46  alden
 ** modified close_connection() call
 **
 ** Revision 1.2  1993/04/16  13:22:49  alden
 ** Moved <varargs.h> inclusion before "conf.h" (needed on Solaris)
 **
 ** Revision 1.1  1993/03/30  13:19:22  alden
 ** Initial revision
 **
 **
 **
 **/
#ifdef HAVE_VARARGS_H
#include <varargs.h>
#endif

#include "conf.h"
#include "readline.h"
#include "nntplink.h"

#ifdef HAVE_VALUES_H
#include <values.h>
#endif

extern Boolean Debug;
extern FILE *Debugfp;
extern long Idle_time;
extern int Input_from;
extern Boolean Log_close;
extern Boolean One_shot;
extern int Stdin_fd_flags;

extern void close_connection();
extern char *emalloc();
extern void log();
extern void log_stats();
extern void update_batchfile();
extern void write_link_datafile();

void my_exit();

#ifdef HAVE_VARARGS_H
void
  log(va_alist)
va_dcl
{
  va_list ap;
  char *fname, *format;
  char *buf;
  int priority;
  
  va_start(ap);
  priority = va_arg(ap, int);
  fname = va_arg(ap, char *);
  format = va_arg(ap, char *);
  format += 2;
  
  if (Debug) {
    if (fputs(fname, Debugfp) == EOF) {
      fprintf(stderr, "log: fputs failed - %s\n", errmsg(errno));
      my_exit(FAIL);
    }
    if (vfprintf(Debugfp, format, ap) == EOF) {
      fprintf(stderr, "log: vfprintf failed - %s\n", errmsg(errno));
      my_exit(FAIL);
    }
    fflush(Debugfp);
  } else {
    buf = emalloc(1024);
    vsprintf(buf, format, ap);
    syslog(priority, "%s", buf);
    free(buf);
  }
  
  va_end(ap);
  return;
}

void
  fail(va_alist)
va_dcl
{
  va_list ap;
  char *fname, *format;
  char *buf;
  
  va_start(ap);
  fname = va_arg(ap, char *);
  format = va_arg(ap, char *);
  format += 2;
  
  if (Debug) {
    if (fputs(fname, Debugfp) == EOF) {
      fprintf(stderr, "fail: fputs failed - %s\n", errmsg(errno));
      my_exit(FAIL);
    }
    if (vfprintf(Debugfp, format, ap) == EOF) {
      fprintf(stderr, "fail: vfprintf failed - %s\n", errmsg(errno));
      my_exit(FAIL);
    }
    fflush(Debugfp);
  } else {
    buf = emalloc(1024);
    vsprintf(buf, format, ap);
    syslog(LOG_ERR, "%s", buf);
    free(buf);
  }
  va_end(ap);
  my_exit(FAIL);
}

#else /* !HAVE_VARARGS_H */

/*VARARGS*/
void
  log(priority, fname, format, x1, x2, x3, x4, x5, x6, x7, x8)
int priority;
char *fname;
char *format, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{
  if (Debug) {
    
    if (fprintf(Debugfp, format, fname, x1, x2, x3, x4, x5, x6, x7, x8) == EOF) {
      fprintf(stderr, "log: fprintf failed - %s\n", errmsg(errno));
      my_exit(FAIL);
    }
    fflush(Debugfp);
    
  } else
    syslog(priority, format, "", x1, x2, x3, x4, x5, x6, x7, x8);
  
  return;
}


/*VARARGS*/
void
  fail(fname, format, x1, x2, x3, x4, x5, x6, x7, x8)
char *fname;
char *format, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{
  
  log(LOG_ERR, fname, format, x1, x2, x3, x4, x5, x6, x7, x8);
  
  my_exit(FAIL);
}
#endif /* !HAVE_VARARGS_H */


void
  abort_nntplink()
{
  static char *fname = "abort_nntplink: ";
  
  dlog(LOG_DEBUG, fname, "%sexiting\n");
  
  if ( !(Input_from & FLG_BATCHFILE) || One_shot)
    update_batchfile();
  
  if (Host.connected) {
    close_connection(DONT_SEND_QUIT_MSG, FALSE);
    if (!Log_close)
      log_stats();
  } else
    log_stats();
  
  my_exit(0);
}


void
  my_exit(status)
int status;
{
  if (Input_from & FLG_STDIN)
    fcntl(fb_fileno(Stdin), F_SETFL, Stdin_fd_flags);
  exit(status);
}


char *
  itoa(num)
int num;
{
  static char *numbers = "0123456789";
  static char *neg = "-";
  register char *bp, *negative = neg + 1;
  char *buf = emalloc(MAXDIGS);
  
  if (num == 0)
    return "0";
  else if (num > MAXINT)
    return NULL;
  
  *(bp = buf + MAXDIGS) = '\0';
  
  if ((long)num < 0) {
    negative--;
    num = -num;
  }
  
  do {
    *--bp = *(numbers + (num % 10));
    num /= 10;
  } while (num);
  
  if (*negative)
    *--bp = *negative;
  
  return bp;
}
