/**
 ** Routine that parses the arguments.
 **
 ** $Id: parseargs.c,v 1.12 1993/05/28 12:53:21 alden Exp $
 **
 ** $Log: parseargs.c,v $
 ** Revision 1.12  1993/05/28  12:53:21  alden
 ** Fixed #ifdef
 **
 ** Revision 1.11  1993/05/17  15:04:49  root
 ** Added debug message specifying "News Type" (either BNEWS, CNEWS, or INN)
 **
 ** Revision 1.10  1993/05/11  00:06:50  alden
 ** Added '-k' option
 **
 ** Revision 1.9  1993/05/05  18:41:05  root
 ** Fixed logic error when checking for both "-A" and "-d" options
 **
 ** Revision 1.8  1993/05/05  14:18:14  root
 ** Set Batchfile.use to FALSE if Queue_backlog is TRUE
 **
 ** Revision 1.7  1993/05/04  23:38:33  alden
 ** Cleaned up tabs
 **
 ** Revision 1.6  1993/05/04  20:54:27  alden
 ** Added "-q" option
 **
 ** Revision 1.5  1993/05/04  19:44:20  alden
 ** Moved Batchfile.tmp from parse_args() to setup_proc()
 **
 ** Revision 1.4  1993/04/28  22:29:49  alden
 ** Modified so you can specify "-A" and "-D <file>"
 **
 ** Revision 1.3  1993/04/17  22:28:57  root
 ** Changed log() messages to include filename
 **
 ** Revision 1.2  1993/04/16  21:24:58  alden
 ** Move Batchfile.nname from parse_args() to setup_proc()
 **
 ** Revision 1.1  1993/03/30  13:19:24  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"
#include "patchlevel.h"
#include "strfuns.h"

#include <sys/stat.h>

extern int Clear_batchfile;
extern int Close_after;
extern long Close_timeout;
extern long Delay;
extern long Entry_sleep;
extern long Exit_timeout;
extern long Fail_minutes;
extern int Log_after;
extern Boolean Log_close;
extern Boolean Open_art_first;
extern Boolean Queue_backlog;
extern char *Prog_name;
extern long Repeat_minutes;
extern Boolean Report_stats;

extern char *E_chdir;
extern char *E_fopen;

extern char *optarg;
extern int optind, opterr;

extern void fail();
extern void log();

Boolean Autobackground = FALSE;
Boolean Debug = FALSE;
FILE *Debugfp = stderr;
char *History_file = HISTORYFILE;
int Input_from = DEF_INPUT_FROM;
Boolean Kill_oldlink = FALSE;
Boolean One_shot = FALSE;
Boolean Save_fails = TRUE;
int Nntp_port = 0;

int Xreplic = FALSE;


void
  parse_args(argc, argv)
int argc;
char *argv[];
{
  static char *fname = "parse_args: ";
  int c, errflg=0, t;
  char *batchname = NULL,
  *tfile = NULL,
  *tfile2 = NULL,
  *batchdir = BATCHDIR,
  *spooldir = SPOOLDIR;
  Boolean set_C_opt = FALSE;
  Boolean c_news_batch = FALSE;
  Boolean print_version = FALSE;
  struct stat qst;
  
  if ((Prog_name = strrchr(argv[0], '/')) != NULL)
    Prog_name++;
  else
    Prog_name = argv[0];
  
  opterr = 0;
  while ((c = getopt(argc, argv,
		     "a:Ab:B:c:C:dD:e:E:fF:H:i:kl:Lm:n:N:oOp:P:qrR:s:S:vVxy:"))
	 != EOF)
    switch (c) {
    case 'a':
      Close_after = atoi(optarg);
      break;
    case 'A':
      Autobackground = TRUE;
      break;
    case 'b':
      batchname = optarg;
      break;
    case 'B':
      batchdir = optarg;
      break;
    case 'c':
      Clear_batchfile = atoi(optarg);
      set_C_opt = TRUE;
      break;
    case 'C':
      Close_timeout = atol(optarg);
      break;
    case 'd':
      Debug = TRUE;
      break;
    case 'D':
      Debug = TRUE;
      if ((Debugfp = fopen(optarg, "a")) == NULL) {
	fprintf(stderr, E_fopen, optarg, "a", errmsg(errno));
	errflg++;
      }
      break;
    case 'e':
      Exit_timeout = atol(optarg);
      break;
    case 'E':
      Entry_sleep = atol(optarg);
      break;
    case 'f':
      Save_fails = FALSE;
      break;
    case 'F':
      Input_from = FLG_LOGFILE;
      Logfile.name = optarg;
      break;
    case 'H':
      History_file = optarg;
      break;
    case 'i':
      if (strcmp(optarg, "batchfile") == MATCH)
	Input_from = FLG_BATCHFILE;
      else if (strcmp(optarg, "logfile") == MATCH)
	Input_from = FLG_LOGFILE;
      else if (strcmp(optarg, "stdin") == MATCH)
	Input_from = FLG_STDIN;
      else
	errflg++;
      break;
    case 'k':
      Kill_oldlink = TRUE;
      break;
    case 'l':
      Log_after = atoi(optarg);
      break;
    case 'L':
      Log_close = TRUE;
      break;
    case 'm':
      Fail_minutes = atol(optarg);
      break;
    case 'n':
      Batchfile.nap_time = atol(optarg);
      break;
    case 'N':
      Logfile.nap_time = atol(optarg);
      break;
    case 'o':
      One_shot = TRUE;
      break;
    case 'O':
      Open_art_first = TRUE;
      break;
    case 'p':
      if (strcmp(optarg, "decnet") == 0)
	Host.transport = T_DECNET;
      else if (strcmp(optarg, "tcp") == 0)
	Host.transport = T_IP_TCP;
      else if (strcmp(optarg, "dkhost") == 0)
	Host.transport = T_DKHOST;
      else
	errflg++;
      break;
    case 'P':
      Nntp_port = atoi(optarg);
      break;
    case 'q':
      Queue_backlog = TRUE;
      Batchfile.use = FALSE;
      break;
    case 'r':
      Report_stats = FALSE;
      break;
    case 'R':
      Repeat_minutes = atol(optarg);
      break;
    case 's':
      Input_from = FLG_LOGFILE;
      Host.sysname = optarg;
      break;
    case 'S':
      spooldir = optarg;
      break;
    case 'v':
      fprintf (stderr, "%s %sPL%s %s\n", Prog_name, RELEASE,
	       PATCHLEVEL, DATE);
      exit(0);
      /*NOTREACHED*/
    case 'V':
      print_version = TRUE;
      Debug = TRUE;
      break;
    case 'x':
      Xreplic = TRUE;
      break;
    case 'y':
      Delay = atoi(optarg);
      if (Delay == 0)
	Delay = 120;
    default:
      errflg++;
    }
  
  if (optind < argc) {
    Host.name = argv[optind++];
  } else {
    if (print_version)
      Host.name = strsave("<none-given>");
    else
      errflg++;
  }
  
  if (Xreplic && (Input_from & FLG_LOGFILE)) {
    fprintf(stderr, "%s: Xreplic cannot be used with the LOGFILE mode\n",
	    Prog_name);
    errflg++;
  }
  
  if (Queue_backlog && !(Input_from & FLG_STDIN)) {
    fprintf(stderr, "%s: -q can only be used with -i stdin\n", Prog_name);
    errflg++;
  }
  
  if (errflg) {
    fprintf(stderr,	"usage: %s [options] hostname\n", Prog_name);
    if (!print_version)
      exit(FAIL);
  }
  
  if (Autobackground && (One_shot || (Debug && (Debugfp == stderr)))) {
    fprintf(stderr, "%s: Cannot use -A and %s\n", Prog_name,
	    Debug ? "-d" : "-o");
    exit(FAIL);
  }
  
  /*
   * If our umask is 0, set it to 2, otherwise set it back to what it was.
   */
  
  if ((t = umask(2)) != 0)
    umask(t);
  
  if ((t = Clear_batchfile / Log_after) < 1)
    t = 1;
  
  if ((Clear_batchfile != (t * Log_after)) && (set_C_opt)) {
    fprintf(stderr,
	    "%s: -c (Clear_batchfile) isn't a multiple of -l (Log_after)\n",
	    Prog_name);
    fprintf(stderr,
	    "     using %d for -c instead\n", (t * Log_after));
  }
  Clear_batchfile = t;
  
  if (chdir(spooldir) == FAIL)
    log(LOG_WARNING, fname, E_chdir, Host.name, spooldir, errmsg(errno));
  
  if (Host.sysname == NULL)
    Host.sysname = Host.name;
  
  if (batchname == NULL)
    tfile = str3save(batchdir, "/", Host.name);
  else if (*batchname == '/')
    tfile = strsave(batchname);
  else
    tfile = str3save(batchdir, "/", batchname);
  
  if (stat(tfile, &qst) == FAIL) {
    
    if (errno == ENOENT) {
      if (!print_version)
	dlog(LOG_INFO, fname,
	     "%s%s doesn't exist, assuming it's the name of a batchfile\n",
	     tfile);
    } else
      fail(fname, "%s%s: stat(%s) failed: %s\n", Host.name, tfile,
	   errmsg(errno));
  } else if ((qst.st_mode & S_IFMT) == S_IFREG) {
    dlog(LOG_DEBUG, fname, "%s%s is a batchfile\n", tfile);
  } else if ((qst.st_mode & S_IFMT) == S_IFDIR) {
    dlog(LOG_DEBUG, fname, "%s%s is a batch directory\n", tfile);
    c_news_batch = TRUE;
  } else {
    fail(fname,
	 "%s%s: %s is not a directory or a regular file, st_mode = %o",
	 Host.name, tfile, qst.st_mode);
  }
  
  if (c_news_batch) {
    Batchfile.name = str2save(tfile, "/togo");
    Host.failfile = str2save(tfile, "/togo.fail");
    Host.datafile = str2save(tfile, "/togo.link");
    Batchfile.dir = strsave(tfile);
  } else {
    Batchfile.name = strsave(tfile);
    Host.failfile = str2save(tfile, ".fail");
    Host.datafile = str2save(tfile, ".link");
    tfile2 = strrchr(tfile, '/');
    *tfile2 = NULL;
    Batchfile.dir = strsave(tfile);
  }
  
  FREE(tfile);
  
  if (Debug) {
    log(LOG_DEBUG, "",
	"%sConfiguration information:\n");
    log(LOG_DEBUG, "",
	"%s Version:                         %sPL%s %s\n", RELEASE,
	PATCHLEVEL, DATE);
    log(LOG_DEBUG, "",
	"%s News Type:                       %s\n",
#if defined(BNEWS)
	"BNEWS"
#else
#if defined(CNEWS)
	"CNEWS"
#else
	"INN"
#endif
#endif
	);
    log(LOG_DEBUG, "",
	"%s Host:                            %s\n", Host.name);
    log(LOG_DEBUG, "",
	"%s Spool directory:                 %s\n", spooldir);
    log(LOG_DEBUG, "",
	"%s Batch directory:                 %s\n", Batchfile.dir);
    log(LOG_DEBUG, "",
	"%s Batch file:                      %s\n",
	basename(Batchfile.name));
    log(LOG_DEBUG, "",
	"%s Fail file:                       %s\n",
	strrchr(Host.failfile, '/') + 1);
    if (!One_shot) {
      log(LOG_DEBUG, "",
	  "%s Link Data file:                  %s\n",
	  strrchr(Host.datafile, '/') + 1);
      if (Input_from & FLG_LOGFILE) {
	log(LOG_DEBUG, "",
	    "%s Logfile:                         %s\n", Logfile.name);
	log(LOG_DEBUG, "",
	    "%s Sysname:                         %s\n", Host.sysname);
      }
#ifdef LOOKUP_ARTICLE
      log(LOG_DEBUG, "",
	  "%s History file:                    %s\n", History_file);
#endif
    } else
      log(LOG_DEBUG, "", "%s One shot?:                       TRUE\n");
    if (Host.transport == T_IP_TCP)
      log(LOG_DEBUG, "",
	  "%s Connection Type:                 TCP/IP\n");
    else if (Host.transport == T_DECNET)
      log(LOG_DEBUG, "",
	  "%s Connection Type:                 DECNET\n");
    else
      log(LOG_DEBUG, "",
	  "%s Connection Type:                 DKHOST\n");
    if (Input_from & FLG_BATCHFILE)
      log(LOG_DEBUG, "",
	  "%s Input file type:                 Batchfile\n");
    else if (Input_from & FLG_LOGFILE)
      log(LOG_DEBUG, "",
	  "%s Input file type:                 Logfile\n");
    else {
      log(LOG_DEBUG, "",
	  "%s Input file type:                 <stdin>\n");
      log(LOG_DEBUG, "",
	  "%s Queue backlog?:                  %s\n",
	  (Queue_backlog ? "TRUE" : "FALSE"));
    }
    log(LOG_DEBUG, "",
	"%s Save fails:                      %s\n",
	(Save_fails ? "TRUE" : "FALSE"));
    log(LOG_DEBUG, "",
	"%s Fail_minutes:                    %ld\n", Fail_minutes);
    log(LOG_DEBUG, "",
	"%s Repeat_minutes:                  %ld\n", Repeat_minutes);
    if (Input_from & FLG_LOGFILE)
      log(LOG_DEBUG, "",
	  "%s Sleep between logfile checks:    %d second(s)\n",
	  Logfile.nap_time);
    else
      log(LOG_DEBUG, "",
	  "%s Sleep between batchfile checks:  %d second(s)\n",
	  Batchfile.nap_time);
    log(LOG_DEBUG, "",
	"%s Sleep between entry checks:      %d second(s)\n",
	Entry_sleep);
    if (Input_from & FLG_BATCHFILE)
      log(LOG_DEBUG, "",
	  "%s Batchfile is cleared after:      %d article(s)\n",
	  (Clear_batchfile * Log_after));
    log(LOG_DEBUG, "",
	"%s Statistics Reported:             %s\n",
	(Report_stats ? "TRUE" : "FALSE"));
    if (Report_stats) {
#ifdef HAVE_SYSLOG_H
      log(LOG_DEBUG, "",
	  "%s                 Via:             4.3BSD syslog\n");
#else
      log(LOG_DEBUG, "",
	  "%s                 Via:             %s\n", FAKESYSLOG);
#endif
      log(LOG_DEBUG, "",
	  "%s               After:             %d article(s)\n",
	  Log_after);
      if (Log_close)
	log(LOG_DEBUG, "",
	    "%s               and each time the connection is closed.\n");
    }
    log(LOG_DEBUG, "",
	"%s Connection closed after:         %d article(s)\n",
	Close_after);
    if (Close_timeout >= 0)
      log(LOG_DEBUG, "",
	  "%s Connection closed after:         %d idle second(s)\n",
	  Close_timeout);
    if (Exit_timeout >= 0)
      log(LOG_DEBUG, "",
	  "%s Exit after:                      %d idle second(s)\n",
	  Exit_timeout);
    log(LOG_DEBUG, "", "%s\n\n");
  }
  if (print_version)
    exit(0);
  return;
}
