/**
 ** Routine that checks for various timeouts and sleeps.
 **
 ** $Id: sleep.c,v 1.3 1993/05/28 12:54:24 alden Exp $
 **
 ** $Log: sleep.c,v $
 ** Revision 1.3  1993/05/28  12:54:24  alden
 ** Fixed #ifdef HAVE_SELECT problem
 **
 ** Revision 1.2  1993/05/04  23:38:52  alden
 ** Cleaned up tabs
 **
 ** Revision 1.1  1993/03/30  13:19:41  alden
 ** Initial revision
 **
 **
 **
 **/
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

#ifdef _AIX		/* AIX needs this to use native mode compiler */
#include <sys/select.h>
#endif

extern Boolean Abort_signaled;
extern long Close_timeout;
extern Boolean Debug;
extern long Dtablesize;
extern long Exit_timeout;
extern long Idle_time;
extern int Input_from;
extern Boolean Reset_signaled;

extern void abort_nntplink();
extern void close_connection();
extern void fail();
extern void log();
extern void reset_logfile();
extern void update_batchfile();

#ifdef HAVE_WORKING_SELECT
struct timeval timeout = {0, 0};
#endif

void
  check_sleep(sleep_time, create_batch)
long sleep_time;
Boolean create_batch;
{
  static char *fname = "check_sleep: ";
#ifdef HAVE_WORKING_SELECT
  fd_set readfds;
  long start_time;
  int cnt;
#endif
  
  Idle_time += sleep_time;
  
  if ((Idle_time > Close_timeout) && (Host.connected) && 
      (Close_timeout != NEVER)) {
    
    dlog(LOG_DEBUG, fname, "%sreached close timeout\n");
    close_connection(SEND_QUIT_MSG);
  }
  
  if (Abort_signaled ||
      ((Exit_timeout != NEVER) && (Idle_time > Exit_timeout))) {
    
    if (Debug && !Abort_signaled)
      dlog(LOG_DEBUG, fname, "%sreached exit timeout\n");
    
    abort_nntplink();
  }
  
  if (Reset_signaled)
    update_batchfile();
  
#ifdef HAVE_WORKING_SELECT
  timeout.tv_sec = sleep_time;
  
  while (timeout.tv_sec > 0 && !Abort_signaled) {
    start_time = time(NULL);
    FD_ZERO(&readfds);
    if (Input_from & FLG_STDIN)
      FD_SET(fb_fileno(Stdin), &readfds);
    
    if ((cnt = select((int)Dtablesize,&readfds,0,0,&timeout)) == 0)
      break;
    
    if ((cnt == FAIL) && (errno != EINTR))
      fail(fname,
	   "%s%s: select() failed (try undefining HAVE_WORKING_SELECT): %s",
	   Host.name, errmsg(errno));
    
    if (cnt > 0) {
      if (create_batch)
	update_batchfile();
      else if (fb_eof(Stdin)) {
	log(LOG_INFO, fname, "%s%s: EOF on stdin, exiting\n",
	    Host.name);
	Abort_signaled = TRUE;
      } else
	break;
    }
    timeout.tv_sec -= (time(NULL) - start_time);
  }
  
#else
  (void) sleep((unsigned)sleep_time);
#endif
  
  dlog(LOG_DEBUG, "", "%s.");
  
  return;
}
