/**
 ** Main configuration file for NNTPlink.  Edit appropriately.
 **
 ** $Id: dist_conf.h,v 1.15 1993/12/22 00:58:17 root Exp $
 **
 ** $Log: dist_conf.h,v $
 ** Revision 1.15  1993/12/22  00:58:17  root
 ** Added "SAVE_ART_FAILS" definition
 **
 ** Revision 1.14  1993/12/02  18:15:12  alden
 ** Renamed "NNTPLINK_LOGLEVEL" to "NNTPLINK_LOGFACILITY"
 **
 ** Revision 1.13  1993/11/24  23:00:07  root
 ** Change the ENTRY_SLEEP and CLOSE_TIMEOUT defaults
 **
 ** Revision 1.12  1993/11/18  21:58:18  alden
 ** Upped some of the logging defaults from 100 to 250
 **
 ** Revision 1.11  1993/11/04  20:23:32  root
 ** Changed a few defaults to reflect INN installation as opposed to C News
 ** Added NNTPLINK_LOGLEVEL symbol for defining syslog() facility
 **
 ** Revision 1.10  1993/10/29  14:04:14  root
 ** Updated some of the defaults
 **
 ** Revision 1.9  1993/10/25  18:21:40  root
 ** Took out LOOKUP_ARTICLE
 **
 ** Revision 1.8  1993/10/15  15:37:39  alden
 ** Removed extraneous #endif
 **
 ** Revision 1.7  1993/10/13  20:48:18  alden
 ** Renamed LOG* to DATA*
 ** Added new FLG_FUNNEL
 **
 ** Revision 1.6  1993/05/04  17:43:27  alden
 ** Rearranged the layout -- cleaned it up some.
 **
 ** Revision 1.5  1993/04/28  23:34:47  root
 ** Added "INN" and "CNEWS" #define's
 ** Cleaned up comments
 **
 ** Revision 1.4  1993/04/28  18:09:34  alden
 ** Added comment about STATS_LOGLEVEL
 **
 ** Revision 1.3  1993/04/19  14:51:29  alden
 ** Added note about CLEAR_BATCHFILE needing to be an integer
 **
 ** Revision 1.2  1993/04/17  22:50:43  alden
 ** Fixed headers
 ** Fixed MAX_NAPTIME
 ** Added directory includes
 **
 ** Revision 1.1  1993/03/28  19:37:18  alden
 ** Initial revision
 **
 **
 **/
#include "preconf.h"


/**
 ** Define one and only one of the following:
 **/
#undef BNEWS
#define INN
#undef CNEWS


/**
 ** Default news batch directory.  (Can be overridden with "-B batchdir").
 **/
#define BATCHDIR	"/var/news/out.going"


/**
 ** Where should nntplink get it articles from by default?
 ** FLG_BATCHFILE || FLG_FUNNEL || FLG_LOGFILE || FLG_STDIN
 ** (Can be overridden with "-i [batchfile|funnel|logfile|stdin]").
 **/
#define DEF_INPUT_FROM	FLG_STDIN


/**
 ** If you don't have support for syslog, but want a facsimile,
 ** define FAKESYSLOG to be the name of a file to which to log stuff.  e.g.,
 **
 **      #define FAKESYSLOG      "/usr/lib/news/nntplink.log"
 **/
/* #define  FAKESYSLOG	"/usr/local/news/nntplink.log" */


/**
 ** Default news history file.  (Can be overridden with "-H historyfile").
 **/
#define HISTORYFILE	"/usr/local/news/history"


/**
 ** Define to be the default transport protocol, either T_DECNET, T_IP_TCP,
 ** or T_DKHOST
 **/
#define HOST_TRANSPORT T_IP_TCP


/**
 ** Default news logfile/funnel file.  (Can be overridden with "-F datafile").
 **/
#define DATAFILE	"/var/log/news/news"


/**
 ** If you are using the proposed NNTP Version 2 authentication protocol,
 ** then you must define the file where the nntp site/userid/passwords are
 ** kept.  Protect this file (mode: 600)
 **/
#define	PASSFILE	"/usr/local/news/nntp_sys"


/**
 ** Default news spool directory.  (Can be overridden with "-S spooldir").
 **/
#define SPOOLDIR	"/var/spool/news"


/**
 ** What syslog() facility would you like to be assigned to all messages?
 ** Note that some systems don't allow for you to specify a facility.  If
 ** your system does, then the default is LOG_NEWS if you have that facility,
 ** otherwise it tries LOG_LOCAL0.  If you'd rather use some other facility,
 ** then define the following symbol to the facility you'd like to use.
 **
 **/
/* #define NNTPLINK_LOGFACILITY LOG_NEWS */


/**
 ** What level do you wish nntplink to use when syslog()'ing the statistics?
 **
 ** NOTE: For INN, you may want to use LOG_NOTICE.  Normally INN logs
 **       "interesting" events at the LOG_NOTICE level, and innlog.awk
 **       is capable of summarizing nntplink statistics if nntplink uses
 **       LOG_NOTICE.
 **/
#define STATS_LOGLEVEL	LOG_NOTICE



/***************************************************************************
 ** The following options are (hopefully) acceptable for your system, if you
 ** are unsure about them, do not worry.  :-)
 ***************************************************************************/

 
/**
 ** How many seconds should nntplink sleep between checks for a new batchfile?
 ** (Can be overridden with "-n num").
 **/
#define BATCHFILE_NAPTIME	60


/**
 ** Number of articles we must have offered to remote end before nntplink
 ** resets the batchfile.  This can be overridden with "-c num".
 ** NOTE:   This must be a multiple of LOG_AFTER.
 **
 ** ANOTHER NOTE:  This needs to be an interger, not a product (i.e., don't
 **                make it 1*LOG_AFTER or such).  This is due to the way
 **                the manual page is generated -- it needs an integer for
 **                this variable.
 **/
#define CLEAR_BATCHFILE	250


/**
 ** If we've offered this many articles then we want to close and reopen the
 ** link to give the remote host a chance to log statistics.  (Can be
 ** overridden with "-a num").
 **/
#define CLOSE_AFTER	250


/**
 ** How many seconds should nntplink sleep between checks for a new entry
 ** in either the log file or the batchfile?  (Can be overridden with
 ** "-E num").  Note:  I use 580 since I use select() to wake me up if
 ** there is something waiting on <stdin>.  I suggest you keep this under
 ** 600 since some news servers log a message for sessions that are idle
 ** for more than 10 minutes
 **/
#define ENTRY_SLEEP	580


/**
 ** After this many seconds of idle time we will close the connection.
 ** Can be overridden by "-C num" -- use "-C -1" to never close the
 ** connection.  Note:  For efficiency, this should be <a multiple of
 ** ENTRY_SLEEP> + 1, i.e.:  <n>*ENTRY_SLEEP + 1
 **/
#define CLOSE_TIMEOUT 581


/**
 ** After this many seconds of idle time we will exit from nntplink.
 ** (NOTE: Use NEVER to never exit nntplink).  Can be overridden by
 ** "-e num".
 **/
#define EXIT_TIMEOUT	NEVER


/**
 ** If we've gone FAIL_MINUTES between successful article transmissions then
 ** we'll syslog() an error message.  Can be overridden with "-m num".
 **
 ** Once we've hit FAIL_MINUTES, we will repeat the message every
 ** REPEAT_MINUTES until the error condition goes away.  Can be overridden
 ** with "-R num".
 **/
#define FAIL_MINUTES	720				/** 12 hours **/
#define REPEAT_MINUTES	720				/** 12 hours **/


/**
 ** Number of articles we must have offered to remote end before nntplink
 ** decides to log local statistics.  (Can be overridden with "-l num").
 **/
#define LOG_AFTER	250


/**
 ** How many seconds should nntplink sleep between checks for a new
 ** logfile/datafile?  (Can be overridden with "-N num").
 **/
#define DATAFILE_NAPTIME	60


/**
 ** Which database package are you using to keep your history file?
 ** Pick one of the following and define it:  DBZ, DBM, or NDBM.
 **/
#define DBZ


/**
 ** Should we junk articles that we have trouble sending, or should they
 ** be saved to a fail file? (Define this to save them)
 **/
#define SAVE_ART_FAILS


/**
 ** How many times can an article fail to be transferred before we either
 ** junk it or put it into the failure file?
 **/
#define MAX_ART_FAILS	2


/**
 ** When we get an error from the remote host we want to sleep for NAPTIME
 ** seconds, if we continue to get an error then we want to have exponential
 ** backoff until we get to MAX_NAPTIME seconds.
 **/
#define NAPTIME		15		/** 15 seconds **/
#define MAX_NAPTIME	(15*64)		/** 16 minutes **/


/**
 ** If we have gone this many minutes between successfull transmissions of
 ** articles then we want to "catch up" by reading to the end of the current
 ** input file (if using "logfile", "funnel", or "stdin").
 **/
#define SPOOL_MINUTES	60


/**
 ** End of Configuration Section.
 **/

#include "postconf.h"
